/*
 * Decompiled with CFR 0.152.
 */
package com.vaynberg.wicket.select2;

import com.vaynberg.wicket.select2.AjaxSettings;
import com.vaynberg.wicket.select2.ChoiceProvider;
import com.vaynberg.wicket.select2.JQuery;
import com.vaynberg.wicket.select2.Response;
import com.vaynberg.wicket.select2.Select2ResourcesBehavior;
import com.vaynberg.wicket.select2.Settings;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.http.WebResponse;
import org.json.JSONException;
import org.json.JSONWriter;

abstract class AbstractSelect2Choice<T, M>
extends HiddenField<M>
implements IResourceListener {
    private final Settings settings = new Settings();
    private ChoiceProvider<T> provider;

    public AbstractSelect2Choice(String id) {
        this(id, null, null);
    }

    public AbstractSelect2Choice(String id, IModel<M> model) {
        this(id, model, null);
    }

    public AbstractSelect2Choice(String id, ChoiceProvider<T> provider) {
        this(id, null, provider);
    }

    public AbstractSelect2Choice(String id, IModel<M> model, ChoiceProvider<T> provider) {
        super(id, model);
        this.provider = provider;
        this.add(new Behavior[]{new Select2ResourcesBehavior()});
        this.setOutputMarkupId(true);
    }

    public final Settings getSettings() {
        return this.settings;
    }

    public final void setProvider(ChoiceProvider<T> provider) {
        this.provider = provider;
    }

    public final ChoiceProvider<T> getProvider() {
        if (this.provider == null) {
            throw new IllegalStateException("Select2 choice component: " + this.getId() + " does not have a ChoiceProvider set");
        }
        return this.provider;
    }

    protected String getJquerySafeMarkupId() {
        return this.getMarkupId().replace(".", "\\\\.");
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JQuery.execute("$('#%s').select2(%s);", this.getJquerySafeMarkupId(), this.settings.toJson())));
        this.renderInitializationScript(response);
    }

    protected abstract void renderInitializationScript(IHeaderResponse var1);

    protected void onInitialize() {
        super.onInitialize();
        AjaxSettings ajax = this.settings.getAjax(true);
        ajax.setData(String.format("function(term, page) { return { term: term, page:page, '%s':true, '%s':[window.location.protocol, '//', window.location.host, window.location.pathname].join('')}; }", "wicket-ajax", "wicket-ajax-baseurl"));
        ajax.setResults("function(data, page) { return data; }");
    }

    protected void onConfigure() {
        super.onConfigure();
        this.getSettings().getAjax().setUrl(this.urlFor(IResourceListener.INTERFACE, null));
    }

    public void onEvent(IEvent<?> event) {
        AjaxRequestTarget target;
        super.onEvent(event);
        if (event.getPayload() instanceof AjaxRequestTarget && (target = (AjaxRequestTarget)event.getPayload()).getComponents().contains((Object)this)) {
            target.prependJavaScript((CharSequence)JQuery.execute("$('#%s').select2('destroy');", this.getJquerySafeMarkupId()));
        }
    }

    public void onResourceRequested() {
        Request request = this.getRequestCycle().getRequest();
        IRequestParameters params = request.getRequestParameters();
        String term = params.getParameterValue("term").toOptionalString();
        int page = params.getParameterValue("page").toInt(1);
        Response response = new Response();
        this.provider.query(term, --page, response);
        WebResponse webResponse = (WebResponse)this.getRequestCycle().getResponse();
        webResponse.setContentType("application/json");
        OutputStreamWriter out = new OutputStreamWriter(webResponse.getOutputStream(), this.getRequest().getCharset());
        JSONWriter json = new JSONWriter((Writer)out);
        try {
            json.object();
            json.key("results").array();
            for (Object item : response) {
                json.object();
                this.provider.toJson(item, json);
                json.endObject();
            }
            json.endArray();
            json.key("more").value((Object)response.getHasMore()).endObject();
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not write Json response", e);
        }
        try {
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write Json to servlet response", e);
        }
    }

    protected void onDetach() {
        this.provider.detach();
        super.onDetach();
    }
}

