/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.content.res.AppCompatResources;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiPagerAdapter;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.RecentEmoji;
import com.vanniktech.emoji.emoji.EmojiCategory;
import com.vanniktech.emoji.listeners.OnEmojiBackspaceClickListener;
import com.vanniktech.emoji.listeners.OnEmojiClickedListener;
import com.vanniktech.emoji.listeners.RepeatListener;
import java.util.concurrent.TimeUnit;

@SuppressLint(value={"ViewConstructor"})
final class EmojiView
extends LinearLayout
implements ViewPager.OnPageChangeListener {
    private static final long INITIAL_INTERVAL = TimeUnit.SECONDS.toMillis(1L) / 2L;
    private static final int NORMAL_INTERVAL = 50;
    @ColorInt
    private final int themeAccentColor;
    @ColorInt
    private final int themeIconColor;
    private final ImageButton[] emojiTabs;
    private final EmojiPagerAdapter emojiPagerAdapter;
    @Nullable
    OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
    private int emojiTabLastSelectedIndex = -1;

    EmojiView(Context context, OnEmojiClickedListener onEmojiClickedListener, @NonNull RecentEmoji recentEmoji) {
        super(context);
        View.inflate((Context)context, (int)R.layout.emoji_view, (ViewGroup)this);
        this.setOrientation(1);
        this.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.emoji_background));
        this.themeIconColor = ContextCompat.getColor((Context)context, (int)R.color.emoji_icons);
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorAccent, value, true);
        this.themeAccentColor = value.data;
        ViewPager emojisPager = (ViewPager)this.findViewById(R.id.emojis_pager);
        LinearLayout emojisTab = (LinearLayout)this.findViewById(R.id.emojis_tab);
        emojisPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        EmojiCategory[] categories = EmojiManager.getInstance().getCategories();
        this.emojiTabs = new ImageButton[categories.length + 2];
        this.emojiTabs[0] = this.inflateButton(context, R.drawable.emoji_recent, (ViewGroup)emojisTab);
        for (int i = 0; i < categories.length; ++i) {
            this.emojiTabs[i + 1] = this.inflateButton(context, categories[i].getIcon(), (ViewGroup)emojisTab);
        }
        this.emojiTabs[this.emojiTabs.length - 1] = this.inflateButton(context, R.drawable.emoji_backspace, (ViewGroup)emojisTab);
        this.handleOnClicks(emojisPager);
        this.emojiPagerAdapter = new EmojiPagerAdapter(onEmojiClickedListener, recentEmoji);
        emojisPager.setAdapter((PagerAdapter)this.emojiPagerAdapter);
        int startIndex = this.emojiPagerAdapter.numberOfRecentEmojis() > 0 ? 0 : 1;
        emojisPager.setCurrentItem(startIndex);
        this.onPageSelected(startIndex);
    }

    private void handleOnClicks(ViewPager emojisPager) {
        for (int i = 0; i < this.emojiTabs.length - 1; ++i) {
            this.emojiTabs[i].setOnClickListener((View.OnClickListener)new EmojiTabsClickListener(emojisPager, i));
        }
        this.emojiTabs[this.emojiTabs.length - 1].setOnTouchListener((View.OnTouchListener)new RepeatListener(INITIAL_INTERVAL, 50L, new View.OnClickListener(){

            public void onClick(View view) {
                if (EmojiView.this.onEmojiBackspaceClickListener != null) {
                    EmojiView.this.onEmojiBackspaceClickListener.onEmojiBackspaceClicked(view);
                }
            }
        }));
    }

    public void setOnEmojiBackspaceClickListener(@Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener) {
        this.onEmojiBackspaceClickListener = onEmojiBackspaceClickListener;
    }

    private ImageButton inflateButton(Context context, @DrawableRes int icon, ViewGroup parent) {
        ImageButton button = (ImageButton)LayoutInflater.from((Context)context).inflate(R.layout.emoji_category, parent, false);
        button.setImageDrawable(AppCompatResources.getDrawable((Context)context, (int)icon));
        button.setColorFilter(this.themeIconColor, PorterDuff.Mode.SRC_IN);
        parent.addView((View)button);
        return button;
    }

    public void onPageSelected(int i) {
        if (this.emojiTabLastSelectedIndex != i) {
            if (i == 0) {
                this.emojiPagerAdapter.invalidateRecentEmojis();
            }
            if (this.emojiTabLastSelectedIndex >= 0 && this.emojiTabLastSelectedIndex < this.emojiTabs.length) {
                this.emojiTabs[this.emojiTabLastSelectedIndex].setSelected(false);
                this.emojiTabs[this.emojiTabLastSelectedIndex].setColorFilter(this.themeIconColor, PorterDuff.Mode.SRC_IN);
            }
            this.emojiTabs[i].setSelected(true);
            this.emojiTabs[i].setColorFilter(this.themeAccentColor, PorterDuff.Mode.SRC_IN);
            this.emojiTabLastSelectedIndex = i;
        }
    }

    public void onPageScrolled(int i, float v, int i2) {
    }

    public void onPageScrollStateChanged(int i) {
    }

    static class EmojiTabsClickListener
    implements View.OnClickListener {
        private final ViewPager emojisPager;
        private final int position;

        EmojiTabsClickListener(ViewPager emojisPager, int position) {
            this.emojisPager = emojisPager;
            this.position = position;
        }

        public void onClick(View v) {
            this.emojisPager.setCurrentItem(this.position);
        }
    }
}

