/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.vanniktech.emoji.EmojiGridView;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.RecentEmoji;
import com.vanniktech.emoji.RecentEmojiGridView;
import com.vanniktech.emoji.listeners.OnEmojiClickedListener;

final class EmojiPagerAdapter
extends PagerAdapter {
    private final OnEmojiClickedListener listener;
    private final RecentEmoji recentEmoji;
    private RecentEmojiGridView recentEmojiGridView;

    EmojiPagerAdapter(OnEmojiClickedListener listener, RecentEmoji recentEmoji) {
        this.listener = listener;
        this.recentEmoji = recentEmoji;
        this.recentEmojiGridView = null;
    }

    public int getCount() {
        return EmojiManager.getInstance().getCategories().length + 1;
    }

    public Object instantiateItem(ViewGroup pager, int position) {
        EmojiGridView newView;
        if (position == 0) {
            this.recentEmojiGridView = newView = new RecentEmojiGridView(pager.getContext()).init(this.listener, this.recentEmoji);
        } else {
            newView = new EmojiGridView(pager.getContext()).init(this.listener, EmojiManager.getInstance().getCategories()[position - 1]);
        }
        pager.addView((View)newView);
        return newView;
    }

    public void destroyItem(ViewGroup pager, int position, Object view) {
        pager.removeView((View)view);
        if (position == 0) {
            this.recentEmojiGridView = null;
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        return view.equals(object);
    }

    int numberOfRecentEmojis() {
        return this.recentEmoji.getRecentEmojis().size();
    }

    void invalidateRecentEmojis() {
        if (this.recentEmojiGridView != null) {
            this.recentEmojiGridView.invalidateEmojis();
        }
    }
}

