/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.vanniktech.emoji.EmojiArrayAdapter;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.emoji.EmojiCategory;
import com.vanniktech.emoji.listeners.OnEmojiClickedListener;

class EmojiGridView
extends GridView {
    protected EmojiArrayAdapter emojiArrayAdapter;

    EmojiGridView(Context context) {
        super(context);
        int width = this.getResources().getDimensionPixelSize(R.dimen.emoji_grid_view_column_width);
        int spacing = this.getResources().getDimensionPixelSize(R.dimen.emoji_grid_view_spacing);
        this.setColumnWidth(width);
        this.setHorizontalSpacing(spacing);
        this.setVerticalSpacing(spacing);
        this.setPadding(spacing, spacing, spacing, spacing);
        this.setNumColumns(-1);
        this.setClipToPadding(false);
    }

    public EmojiGridView init(@Nullable OnEmojiClickedListener onEmojiClickedListener, @NonNull EmojiCategory category) {
        this.emojiArrayAdapter = new EmojiArrayAdapter(this.getContext(), category.getEmojis(), onEmojiClickedListener);
        this.setAdapter((ListAdapter)this.emojiArrayAdapter);
        return this;
    }
}

