/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.vanniktech.emoji.RecentEmoji;
import com.vanniktech.emoji.emoji.Emoji;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

final class RecentEmojiManager
implements RecentEmoji {
    private static final String PREFERENCE_NAME = "emoji-recent-manager";
    private static final String TIME_DELIMITER = ";";
    private static final String EMOJI_DELIMITER = "~";
    private static final String RECENT_EMOJIS = "recent-emojis";
    private static final int EMOJI_GUESS_SIZE = 5;
    private static final int MAX_RECENTS = 40;
    @NonNull
    private final Context context;
    @NonNull
    private EmojiList emojiList = new EmojiList(0);

    RecentEmojiManager(@NonNull Context context) {
        this.context = context.getApplicationContext();
    }

    @Override
    @NonNull
    public Collection<Emoji> getRecentEmojis() {
        if (this.emojiList.size() == 0) {
            String savedRecentEmojis = this.getPreferences().getString(RECENT_EMOJIS, "");
            if (savedRecentEmojis.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(savedRecentEmojis, EMOJI_DELIMITER);
                this.emojiList = new EmojiList(stringTokenizer.countTokens());
                while (stringTokenizer.hasMoreTokens()) {
                    String token = stringTokenizer.nextToken();
                    String[] parts = token.split(TIME_DELIMITER);
                    if (parts.length != 2) continue;
                    Emoji emoji = new Emoji(parts[0]);
                    long timestamp = Long.parseLong(parts[1]);
                    this.emojiList.add(emoji, timestamp);
                }
            } else {
                this.emojiList = new EmojiList(0);
            }
        }
        return this.emojiList.getEmojis();
    }

    @Override
    public void addEmoji(@NonNull Emoji emoji) {
        this.emojiList.add(emoji);
    }

    @Override
    public void persist() {
        if (this.emojiList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder(this.emojiList.size() * 5);
            for (Data data : this.emojiList) {
                stringBuilder.append(data.emoji.getEmoji()).append(TIME_DELIMITER).append(data.timestamp).append(EMOJI_DELIMITER);
            }
            stringBuilder.setLength(stringBuilder.length() - EMOJI_DELIMITER.length());
            this.getPreferences().edit().putString(RECENT_EMOJIS, stringBuilder.toString()).apply();
        }
    }

    private SharedPreferences getPreferences() {
        return this.context.getSharedPreferences(PREFERENCE_NAME, 0);
    }

    private static class Data {
        private final Emoji emoji;
        private final long timestamp;

        Data(Emoji emoji, long timestamp) {
            this.emoji = emoji;
            this.timestamp = timestamp;
        }
    }

    private static class EmojiList
    implements Iterable<Data> {
        private static final Comparator<Data> COMPARATOR = new Comparator<Data>(){

            @Override
            public int compare(Data lhs, Data rhs) {
                return Long.valueOf(rhs.timestamp).compareTo(lhs.timestamp);
            }
        };
        @NonNull
        private final List<Data> emojis;

        EmojiList(int size) {
            this.emojis = new ArrayList<Data>(size);
        }

        void add(Emoji emoji) {
            this.add(emoji, System.currentTimeMillis());
        }

        void add(Emoji emoji, long timestamp) {
            Iterator<Data> iterator = this.emojis.iterator();
            while (iterator.hasNext()) {
                Data data = iterator.next();
                if (!data.emoji.equals(emoji)) continue;
                iterator.remove();
            }
            this.emojis.add(0, new Data(emoji, timestamp));
            if (this.emojis.size() > 40) {
                this.emojis.remove(40);
            }
        }

        Collection<Emoji> getEmojis() {
            Collections.sort(this.emojis, COMPARATOR);
            ArrayList<Emoji> sortedEmojis = new ArrayList<Emoji>(this.emojis.size());
            for (Data data : this.emojis) {
                sortedEmojis.add(data.emoji);
            }
            return sortedEmojis;
        }

        int size() {
            return this.emojis.size();
        }

        @Override
        public Iterator<Data> iterator() {
            return this.emojis.iterator();
        }
    }
}

