/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.PopupWindow;
import com.vanniktech.emoji.EmojiEditText;
import com.vanniktech.emoji.EmojiView;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.RecentEmoji;
import com.vanniktech.emoji.RecentEmojiManager;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.listeners.OnEmojiBackspaceClickListener;
import com.vanniktech.emoji.listeners.OnEmojiClickedListener;
import com.vanniktech.emoji.listeners.OnEmojiPopupDismissListener;
import com.vanniktech.emoji.listeners.OnEmojiPopupShownListener;
import com.vanniktech.emoji.listeners.OnSoftKeyboardCloseListener;
import com.vanniktech.emoji.listeners.OnSoftKeyboardOpenListener;

public final class EmojiPopup {
    private static final int MIN_KEYBOARD_HEIGHT = 100;
    private final EmojiEditText emojiEditText;
    private final View rootView;
    private final Context context;
    private int keyBoardHeight;
    private boolean isPendingOpen;
    private boolean isKeyboardOpen;
    @Nullable
    private OnEmojiPopupShownListener onEmojiPopupShownListener;
    @Nullable
    private OnSoftKeyboardCloseListener onSoftKeyboardCloseListener;
    @Nullable
    private OnSoftKeyboardOpenListener onSoftKeyboardOpenListener;
    @Nullable
    private OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
    @Nullable
    private OnEmojiClickedListener onEmojiClickedListener;
    @Nullable
    private OnEmojiPopupDismissListener onEmojiPopupDismissListener;
    @NonNull
    private final RecentEmoji recentEmoji;
    private final PopupWindow popupWindow;
    private final ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            Rect rect = new Rect();
            EmojiPopup.this.rootView.getWindowVisibleDisplayFrame(rect);
            int heightDifference = EmojiPopup.this.getUsableScreenHeight() - (rect.bottom - rect.top);
            Resources resources = EmojiPopup.this.context.getResources();
            int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
            if (resourceId > 0) {
                heightDifference -= resources.getDimensionPixelSize(resourceId);
            }
            if (heightDifference > 100) {
                EmojiPopup.this.keyBoardHeight = heightDifference;
                EmojiPopup.this.popupWindow.setWidth(-1);
                EmojiPopup.this.popupWindow.setHeight(EmojiPopup.this.keyBoardHeight);
                if (!EmojiPopup.this.isKeyboardOpen && EmojiPopup.this.onSoftKeyboardOpenListener != null) {
                    EmojiPopup.this.onSoftKeyboardOpenListener.onKeyboardOpen(EmojiPopup.this.keyBoardHeight);
                }
                EmojiPopup.this.isKeyboardOpen = true;
                if (EmojiPopup.this.isPendingOpen) {
                    EmojiPopup.this.showAtBottom();
                    EmojiPopup.this.isPendingOpen = false;
                }
            } else if (EmojiPopup.this.isKeyboardOpen) {
                EmojiPopup.this.isKeyboardOpen = false;
                if (EmojiPopup.this.onSoftKeyboardCloseListener != null) {
                    EmojiPopup.this.onSoftKeyboardCloseListener.onKeyboardClose();
                }
            }
        }
    };

    private EmojiPopup(View rootView, final EmojiEditText emojiEditText, @Nullable RecentEmoji recent) {
        this.context = rootView.getContext();
        this.rootView = rootView;
        this.emojiEditText = emojiEditText;
        this.recentEmoji = recent != null ? recent : new RecentEmojiManager(this.context);
        this.popupWindow = new PopupWindow(this.context);
        this.popupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable(this.context.getResources(), (Bitmap)null));
        EmojiView emojiView = new EmojiView(this.context, new OnEmojiClickedListener(){

            @Override
            public void onEmojiClicked(Emoji emoji) {
                emojiEditText.input(emoji);
                EmojiPopup.this.recentEmoji.addEmoji(emoji);
                if (EmojiPopup.this.onEmojiClickedListener != null) {
                    EmojiPopup.this.onEmojiClickedListener.onEmojiClicked(emoji);
                }
            }
        }, this.recentEmoji);
        emojiView.setOnEmojiBackspaceClickListener(new OnEmojiBackspaceClickListener(){

            @Override
            public void onEmojiBackspaceClicked(View v) {
                emojiEditText.backspace();
                if (EmojiPopup.this.onEmojiBackspaceClickListener != null) {
                    EmojiPopup.this.onEmojiBackspaceClickListener.onEmojiBackspaceClicked(v);
                }
            }
        });
        this.popupWindow.setContentView((View)emojiView);
        this.popupWindow.setSoftInputMode(5);
        this.popupWindow.setWidth(-1);
        this.popupWindow.setHeight((int)this.context.getResources().getDimension(R.dimen.emoji_keyboard_height));
        this.popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (EmojiPopup.this.onEmojiPopupDismissListener != null) {
                    EmojiPopup.this.onEmojiPopupDismissListener.onEmojiPopupDismiss();
                }
            }
        });
    }

    private void showAtBottom() {
        this.popupWindow.showAtLocation(this.rootView, 80, 0, 0);
    }

    private void showAtBottomPending() {
        if (this.isKeyboardOpen) {
            this.showAtBottom();
        } else {
            this.isPendingOpen = true;
        }
    }

    public void toggle() {
        if (!this.popupWindow.isShowing()) {
            this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(this.onGlobalLayoutListener);
            if (this.isKeyboardOpen) {
                this.showAtBottom();
            } else {
                this.emojiEditText.setFocusableInTouchMode(true);
                this.emojiEditText.requestFocus();
                this.showAtBottomPending();
                InputMethodManager inputMethodManager = (InputMethodManager)this.context.getSystemService("input_method");
                inputMethodManager.showSoftInput((View)this.emojiEditText, 1);
            }
            if (this.onEmojiPopupShownListener != null) {
                this.onEmojiPopupShownListener.onEmojiPopupShown();
            }
        } else {
            this.dismiss();
        }
    }

    public boolean isShowing() {
        return this.popupWindow.isShowing();
    }

    public void dismiss() {
        Utils.removeOnGlobalLayoutListener(this.rootView, this.onGlobalLayoutListener);
        this.popupWindow.dismiss();
        this.recentEmoji.persist();
    }

    private int getUsableScreenHeight() {
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics metrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(metrics);
            return metrics.heightPixels;
        }
        return this.rootView.getRootView().getHeight();
    }

    public static final class Builder {
        private final View rootView;
        @Nullable
        private OnEmojiPopupShownListener onEmojiPopupShownListener;
        @Nullable
        private OnSoftKeyboardCloseListener onSoftKeyboardCloseListener;
        @Nullable
        private OnSoftKeyboardOpenListener onSoftKeyboardOpenListener;
        @Nullable
        private OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
        @Nullable
        private OnEmojiClickedListener onEmojiClickedListener;
        @Nullable
        private OnEmojiPopupDismissListener onEmojiPopupDismissListener;
        @Nullable
        private RecentEmoji recentEmoji;

        public static Builder fromRootView(View rootView) {
            return new Builder(rootView);
        }

        private Builder(View rootView) {
            this.rootView = rootView;
        }

        public Builder setOnSoftKeyboardCloseListener(@Nullable OnSoftKeyboardCloseListener listener) {
            this.onSoftKeyboardCloseListener = listener;
            return this;
        }

        public Builder setOnEmojiClickedListener(@Nullable OnEmojiClickedListener listener) {
            this.onEmojiClickedListener = listener;
            return this;
        }

        public Builder setOnSoftKeyboardOpenListener(@Nullable OnSoftKeyboardOpenListener listener) {
            this.onSoftKeyboardOpenListener = listener;
            return this;
        }

        public Builder setOnEmojiPopupShownListener(@Nullable OnEmojiPopupShownListener listener) {
            this.onEmojiPopupShownListener = listener;
            return this;
        }

        public Builder setOnEmojiPopupDismissListener(@Nullable OnEmojiPopupDismissListener listener) {
            this.onEmojiPopupDismissListener = listener;
            return this;
        }

        public Builder setOnEmojiBackspaceClickListener(@Nullable OnEmojiBackspaceClickListener listener) {
            this.onEmojiBackspaceClickListener = listener;
            return this;
        }

        public Builder setRecentEmoji(@Nullable RecentEmoji recent) {
            this.recentEmoji = recent;
            return this;
        }

        public EmojiPopup build(EmojiEditText emojiEditText) {
            EmojiPopup emojiPopup = new EmojiPopup(this.rootView, emojiEditText, this.recentEmoji);
            emojiPopup.onSoftKeyboardCloseListener = this.onSoftKeyboardCloseListener;
            emojiPopup.onEmojiClickedListener = this.onEmojiClickedListener;
            emojiPopup.onSoftKeyboardOpenListener = this.onSoftKeyboardOpenListener;
            emojiPopup.onEmojiPopupShownListener = this.onEmojiPopupShownListener;
            emojiPopup.onEmojiPopupDismissListener = this.onEmojiPopupDismissListener;
            emojiPopup.onEmojiBackspaceClickListener = this.onEmojiBackspaceClickListener;
            return emojiPopup;
        }
    }
}

