/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.vanniktech.emoji.EmojiArrayAdapter;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.RecentEmoji;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.listeners.OnEmojiClickedListener;
import java.util.Collection;

@SuppressLint(value={"ViewConstructor"})
final class RecentEmojiGridView
extends FrameLayout {
    private final RecentEmoji recentEmojis;
    private EmojiArrayAdapter emojiArrayAdapter;

    RecentEmojiGridView(@NonNull Context context, @NonNull RecentEmoji recentEmoji) {
        super(context);
        View.inflate((Context)context, (int)R.layout.emoji_grid, (ViewGroup)this);
        this.recentEmojis = recentEmoji;
    }

    public RecentEmojiGridView init(@Nullable OnEmojiClickedListener onEmojiClickedListener) {
        Collection<Emoji> emojis = this.recentEmojis.getRecentEmojis();
        GridView gridView = (GridView)this.findViewById(R.id.emoji_grid_view);
        this.emojiArrayAdapter = new EmojiArrayAdapter(this.getContext(), emojis.toArray(new Emoji[emojis.size()]));
        this.emojiArrayAdapter.setOnEmojiClickedListener(onEmojiClickedListener);
        gridView.setAdapter((ListAdapter)this.emojiArrayAdapter);
        return this;
    }

    public void invalidateEmojis() {
        this.emojiArrayAdapter.updateEmojis(this.recentEmojis.getRecentEmojis());
    }
}

