/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.util.AttributeSet;
import android.widget.TextView;
import com.vanniktech.emoji.EmojiHandler;
import com.vanniktech.emoji.R;

public class EmojiTextView
extends TextView {
    private int emojiSize;

    public EmojiTextView(Context context) {
        super(context);
        this.init(null);
    }

    public EmojiTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public EmojiTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    private void init(@Nullable AttributeSet attrs) {
        if (attrs == null) {
            this.emojiSize = (int)this.getTextSize();
        } else {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.emoji);
            try {
                this.emojiSize = (int)a.getDimension(R.styleable.emoji_emojiSize, this.getTextSize());
            }
            finally {
                a.recycle();
            }
        }
        this.setText(this.getText());
    }

    public void setText(CharSequence rawText, TextView.BufferType type) {
        CharSequence text = rawText == null ? "" : rawText;
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(text);
        EmojiHandler.addEmojis(this.getContext(), (Spannable)spannableStringBuilder, this.emojiSize);
        super.setText((CharSequence)spannableStringBuilder, type);
    }

    public void setEmojiSize(int pixels) {
        this.emojiSize = pixels;
    }
}

