/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.text.Spannable;
import android.util.SparseIntArray;
import com.vanniktech.emoji.EmojiSpan;
import com.vanniktech.emoji.R;

final class EmojiHandler {
    private static final SparseIntArray EMOJIS_MAP = new SparseIntArray(949);
    private static final SparseIntArray SOFTBANKS_MAP = new SparseIntArray(27);

    private static boolean isSoftBankEmoji(char c) {
        return c >> 12 == 14;
    }

    private static int getEmojiResource(int codePoint) {
        return EMOJIS_MAP.get(codePoint);
    }

    private static int getSoftbankEmojiResource(char c) {
        return SOFTBANKS_MAP.get((int)c);
    }

    public static void addEmojis(Context context, Spannable text, int emojiSize) {
        int skip;
        int textLength = text.length();
        EmojiSpan[] oldSpans = (EmojiSpan[])text.getSpans(0, textLength, EmojiSpan.class);
        for (int i = 0; i < oldSpans.length; ++i) {
            text.removeSpan((Object)oldSpans[i]);
        }
        for (int i = 0; i < textLength; i += skip) {
            skip = 0;
            int icon = 0;
            char c = text.charAt(i);
            if (EmojiHandler.isSoftBankEmoji(c)) {
                icon = EmojiHandler.getSoftbankEmojiResource(c);
                int n = skip = icon == 0 ? 0 : 1;
            }
            if (icon == 0) {
                int unicode = Character.codePointAt((CharSequence)text, i);
                skip = Character.charCount(unicode);
                if (unicode > 255) {
                    icon = EmojiHandler.getEmojiResource(unicode);
                }
                if (i + skip < textLength) {
                    int followSkip;
                    int followUnicode = Character.codePointAt((CharSequence)text, i + skip);
                    if (followUnicode == 65039) {
                        int nextFollowUnicode;
                        followSkip = Character.charCount(followUnicode);
                        if (i + skip + followSkip < textLength && (nextFollowUnicode = Character.codePointAt((CharSequence)text, i + skip + followSkip)) == 8419) {
                            int nextFollowSkip = Character.charCount(nextFollowUnicode);
                            int tempIcon = EmojiHandler.getKeyCapEmoji(unicode);
                            if (tempIcon == 0) {
                                followSkip = 0;
                                nextFollowSkip = 0;
                            } else {
                                icon = tempIcon;
                            }
                            skip += followSkip + nextFollowSkip;
                        }
                    } else if (followUnicode == 8419) {
                        followSkip = Character.charCount(followUnicode);
                        int tempIcon = EmojiHandler.getKeyCapEmoji(unicode);
                        if (tempIcon == 0) {
                            followSkip = 0;
                        } else {
                            icon = tempIcon;
                        }
                        skip += followSkip;
                    }
                }
            }
            if (icon <= 0) continue;
            text.setSpan((Object)new EmojiSpan(context, icon, emojiSize), i, i + skip, 33);
        }
    }

    private static int getKeyCapEmoji(int unicode) {
        int icon = 0;
        switch (unicode) {
            case 35: {
                icon = R.drawable.emoji_0023;
                break;
            }
            case 42: {
                icon = R.drawable.emoji_002a_20e3;
                break;
            }
            case 48: {
                icon = R.drawable.emoji_0030;
                break;
            }
            case 49: {
                icon = R.drawable.emoji_0031;
                break;
            }
            case 50: {
                icon = R.drawable.emoji_0032;
                break;
            }
            case 51: {
                icon = R.drawable.emoji_0033;
                break;
            }
            case 52: {
                icon = R.drawable.emoji_0034;
                break;
            }
            case 53: {
                icon = R.drawable.emoji_0035;
                break;
            }
            case 54: {
                icon = R.drawable.emoji_0036;
                break;
            }
            case 55: {
                icon = R.drawable.emoji_0037;
                break;
            }
            case 56: {
                icon = R.drawable.emoji_0038;
                break;
            }
            case 57: {
                icon = R.drawable.emoji_0039;
                break;
            }
        }
        return icon;
    }

    private EmojiHandler() {
        throw new AssertionError((Object)"No instances.");
    }

    static {
        EMOJIS_MAP.put(128512, R.drawable.emoji_1f600);
        EMOJIS_MAP.put(128556, R.drawable.emoji_1f62c);
        EMOJIS_MAP.put(128513, R.drawable.emoji_1f601);
        EMOJIS_MAP.put(128514, R.drawable.emoji_1f602);
        EMOJIS_MAP.put(128515, R.drawable.emoji_1f603);
        EMOJIS_MAP.put(128516, R.drawable.emoji_1f604);
        EMOJIS_MAP.put(128517, R.drawable.emoji_1f605);
        EMOJIS_MAP.put(128518, R.drawable.emoji_1f606);
        EMOJIS_MAP.put(128519, R.drawable.emoji_1f607);
        EMOJIS_MAP.put(128521, R.drawable.emoji_1f609);
        EMOJIS_MAP.put(128522, R.drawable.emoji_1f60a);
        EMOJIS_MAP.put(128578, R.drawable.emoji_1f642);
        EMOJIS_MAP.put(128579, R.drawable.emoji_1f643);
        EMOJIS_MAP.put(9786, R.drawable.emoji_263a);
        EMOJIS_MAP.put(128523, R.drawable.emoji_1f60b);
        EMOJIS_MAP.put(128524, R.drawable.emoji_1f60c);
        EMOJIS_MAP.put(128525, R.drawable.emoji_1f60d);
        EMOJIS_MAP.put(128536, R.drawable.emoji_1f618);
        EMOJIS_MAP.put(128535, R.drawable.emoji_1f617);
        EMOJIS_MAP.put(128537, R.drawable.emoji_1f619);
        EMOJIS_MAP.put(128538, R.drawable.emoji_1f61a);
        EMOJIS_MAP.put(128540, R.drawable.emoji_1f61c);
        EMOJIS_MAP.put(128541, R.drawable.emoji_1f61d);
        EMOJIS_MAP.put(128539, R.drawable.emoji_1f61b);
        EMOJIS_MAP.put(129297, R.drawable.emoji_1f911);
        EMOJIS_MAP.put(129299, R.drawable.emoji_1f913);
        EMOJIS_MAP.put(128526, R.drawable.emoji_1f60e);
        EMOJIS_MAP.put(129303, R.drawable.emoji_1f917);
        EMOJIS_MAP.put(128527, R.drawable.emoji_1f60f);
        EMOJIS_MAP.put(128566, R.drawable.emoji_1f636);
        EMOJIS_MAP.put(128528, R.drawable.emoji_1f610);
        EMOJIS_MAP.put(128529, R.drawable.emoji_1f611);
        EMOJIS_MAP.put(128530, R.drawable.emoji_1f612);
        EMOJIS_MAP.put(128580, R.drawable.emoji_1f644);
        EMOJIS_MAP.put(129300, R.drawable.emoji_1f914);
        EMOJIS_MAP.put(128563, R.drawable.emoji_1f633);
        EMOJIS_MAP.put(128542, R.drawable.emoji_1f61e);
        EMOJIS_MAP.put(128543, R.drawable.emoji_1f61f);
        EMOJIS_MAP.put(128544, R.drawable.emoji_1f620);
        EMOJIS_MAP.put(128545, R.drawable.emoji_1f621);
        EMOJIS_MAP.put(128532, R.drawable.emoji_1f614);
        EMOJIS_MAP.put(128533, R.drawable.emoji_1f615);
        EMOJIS_MAP.put(128577, R.drawable.emoji_1f641);
        EMOJIS_MAP.put(9785, R.drawable.emoji_2639);
        EMOJIS_MAP.put(128547, R.drawable.emoji_1f623);
        EMOJIS_MAP.put(128534, R.drawable.emoji_1f616);
        EMOJIS_MAP.put(128555, R.drawable.emoji_1f62b);
        EMOJIS_MAP.put(128553, R.drawable.emoji_1f629);
        EMOJIS_MAP.put(128548, R.drawable.emoji_1f624);
        EMOJIS_MAP.put(128558, R.drawable.emoji_1f62e);
        EMOJIS_MAP.put(128561, R.drawable.emoji_1f631);
        EMOJIS_MAP.put(128552, R.drawable.emoji_1f628);
        EMOJIS_MAP.put(128560, R.drawable.emoji_1f630);
        EMOJIS_MAP.put(128559, R.drawable.emoji_1f62f);
        EMOJIS_MAP.put(128550, R.drawable.emoji_1f626);
        EMOJIS_MAP.put(128551, R.drawable.emoji_1f627);
        EMOJIS_MAP.put(128546, R.drawable.emoji_1f622);
        EMOJIS_MAP.put(128549, R.drawable.emoji_1f625);
        EMOJIS_MAP.put(128554, R.drawable.emoji_1f62a);
        EMOJIS_MAP.put(128531, R.drawable.emoji_1f613);
        EMOJIS_MAP.put(128557, R.drawable.emoji_1f62d);
        EMOJIS_MAP.put(128565, R.drawable.emoji_1f635);
        EMOJIS_MAP.put(128562, R.drawable.emoji_1f632);
        EMOJIS_MAP.put(129296, R.drawable.emoji_1f910);
        EMOJIS_MAP.put(128567, R.drawable.emoji_1f637);
        EMOJIS_MAP.put(129298, R.drawable.emoji_1f912);
        EMOJIS_MAP.put(129301, R.drawable.emoji_1f915);
        EMOJIS_MAP.put(128564, R.drawable.emoji_1f634);
        EMOJIS_MAP.put(128164, R.drawable.emoji_1f4a4);
        EMOJIS_MAP.put(128169, R.drawable.emoji_1f4a9);
        EMOJIS_MAP.put(128520, R.drawable.emoji_1f608);
        EMOJIS_MAP.put(128127, R.drawable.emoji_1f47f);
        EMOJIS_MAP.put(128121, R.drawable.emoji_1f479);
        EMOJIS_MAP.put(128122, R.drawable.emoji_1f47a);
        EMOJIS_MAP.put(128128, R.drawable.emoji_1f480);
        EMOJIS_MAP.put(128123, R.drawable.emoji_1f47b);
        EMOJIS_MAP.put(128125, R.drawable.emoji_1f47d);
        EMOJIS_MAP.put(129302, R.drawable.emoji_1f916);
        EMOJIS_MAP.put(128570, R.drawable.emoji_1f63a);
        EMOJIS_MAP.put(128568, R.drawable.emoji_1f638);
        EMOJIS_MAP.put(128569, R.drawable.emoji_1f639);
        EMOJIS_MAP.put(128571, R.drawable.emoji_1f63b);
        EMOJIS_MAP.put(128572, R.drawable.emoji_1f63c);
        EMOJIS_MAP.put(128573, R.drawable.emoji_1f63d);
        EMOJIS_MAP.put(128576, R.drawable.emoji_1f640);
        EMOJIS_MAP.put(128575, R.drawable.emoji_1f63f);
        EMOJIS_MAP.put(128574, R.drawable.emoji_1f63e);
        EMOJIS_MAP.put(128588, R.drawable.emoji_1f64c_1f3fb);
        EMOJIS_MAP.put(128079, R.drawable.emoji_1f44f_1f3fb);
        EMOJIS_MAP.put(128075, R.drawable.emoji_1f44b_1f3fb);
        EMOJIS_MAP.put(128077, R.drawable.emoji_1f44d_1f3fb);
        EMOJIS_MAP.put(128078, R.drawable.emoji_1f44e_1f3fb);
        EMOJIS_MAP.put(128074, R.drawable.emoji_1f44a_1f3fb);
        EMOJIS_MAP.put(9994, R.drawable.emoji_270a_1f3fb);
        EMOJIS_MAP.put(9996, R.drawable.emoji_270c_1f3fb);
        EMOJIS_MAP.put(128076, R.drawable.emoji_1f44c_1f3fb);
        EMOJIS_MAP.put(9995, R.drawable.emoji_270b_1f3fb);
        EMOJIS_MAP.put(128080, R.drawable.emoji_1f450_1f3fb);
        EMOJIS_MAP.put(128170, R.drawable.emoji_1f4aa_1f3fb);
        EMOJIS_MAP.put(128591, R.drawable.emoji_1f64f_1f3fb);
        EMOJIS_MAP.put(9757, R.drawable.emoji_261d_1f3fb);
        EMOJIS_MAP.put(128070, R.drawable.emoji_1f446_1f3fb);
        EMOJIS_MAP.put(128071, R.drawable.emoji_1f447_1f3fb);
        EMOJIS_MAP.put(128072, R.drawable.emoji_1f448_1f3fb);
        EMOJIS_MAP.put(128073, R.drawable.emoji_1f449_1f3fb);
        EMOJIS_MAP.put(128405, R.drawable.emoji_1f595_1f3fb);
        EMOJIS_MAP.put(128400, R.drawable.emoji_1f590_1f3fb);
        EMOJIS_MAP.put(129304, R.drawable.emoji_1f918_1f3fb);
        EMOJIS_MAP.put(128406, R.drawable.emoji_1f596_1f3fb);
        EMOJIS_MAP.put(9997, R.drawable.emoji_270d_1f3fb);
        EMOJIS_MAP.put(128133, R.drawable.emoji_1f485_1f3fb);
        EMOJIS_MAP.put(128068, R.drawable.emoji_1f444);
        EMOJIS_MAP.put(128069, R.drawable.emoji_1f445);
        EMOJIS_MAP.put(128066, R.drawable.emoji_1f442_1f3fb);
        EMOJIS_MAP.put(128067, R.drawable.emoji_1f443_1f3fb);
        EMOJIS_MAP.put(128065, R.drawable.emoji_1f441);
        EMOJIS_MAP.put(128064, R.drawable.emoji_1f440);
        EMOJIS_MAP.put(128100, R.drawable.emoji_1f464);
        EMOJIS_MAP.put(128101, R.drawable.emoji_1f465);
        EMOJIS_MAP.put(128483, R.drawable.emoji_1f5e3);
        EMOJIS_MAP.put(128118, R.drawable.emoji_1f476_1f3fb);
        EMOJIS_MAP.put(128102, R.drawable.emoji_1f466_1f3fb);
        EMOJIS_MAP.put(128103, R.drawable.emoji_1f467_1f3fb);
        EMOJIS_MAP.put(128104, R.drawable.emoji_1f468_1f3fb);
        EMOJIS_MAP.put(128105, R.drawable.emoji_1f469_1f3fb);
        EMOJIS_MAP.put(128113, R.drawable.emoji_1f471_1f3fb);
        EMOJIS_MAP.put(128116, R.drawable.emoji_1f474_1f3fb);
        EMOJIS_MAP.put(128117, R.drawable.emoji_1f475_1f3fb);
        EMOJIS_MAP.put(128114, R.drawable.emoji_1f472_1f3fb);
        EMOJIS_MAP.put(128115, R.drawable.emoji_1f473_1f3fb);
        EMOJIS_MAP.put(128110, R.drawable.emoji_1f46e_1f3fb);
        EMOJIS_MAP.put(128119, R.drawable.emoji_1f477_1f3fb);
        EMOJIS_MAP.put(128130, R.drawable.emoji_1f482_1f3fb);
        EMOJIS_MAP.put(128373, R.drawable.emoji_1f575);
        EMOJIS_MAP.put(127877, R.drawable.emoji_1f385_1f3fb);
        EMOJIS_MAP.put(128124, R.drawable.emoji_1f47c_1f3fb);
        EMOJIS_MAP.put(128120, R.drawable.emoji_1f478_1f3fb);
        EMOJIS_MAP.put(128112, R.drawable.emoji_1f470_1f3fb);
        EMOJIS_MAP.put(128694, R.drawable.emoji_1f6b6_1f3fb);
        EMOJIS_MAP.put(127939, R.drawable.emoji_1f3c3_1f3fb);
        EMOJIS_MAP.put(128131, R.drawable.emoji_1f483_1f3fb);
        EMOJIS_MAP.put(128111, R.drawable.emoji_1f46f);
        EMOJIS_MAP.put(128107, R.drawable.emoji_1f46b);
        EMOJIS_MAP.put(128108, R.drawable.emoji_1f46c);
        EMOJIS_MAP.put(128109, R.drawable.emoji_1f46d);
        EMOJIS_MAP.put(128583, R.drawable.emoji_1f647_1f3fb);
        EMOJIS_MAP.put(128129, R.drawable.emoji_1f481_1f3fb);
        EMOJIS_MAP.put(128581, R.drawable.emoji_1f645_1f3fb);
        EMOJIS_MAP.put(128582, R.drawable.emoji_1f646_1f3fb);
        EMOJIS_MAP.put(128587, R.drawable.emoji_1f64b_1f3fb);
        EMOJIS_MAP.put(128590, R.drawable.emoji_1f64e_1f3fb);
        EMOJIS_MAP.put(128589, R.drawable.emoji_1f64d_1f3fb);
        EMOJIS_MAP.put(128135, R.drawable.emoji_1f487_1f3fb);
        EMOJIS_MAP.put(128134, R.drawable.emoji_1f486_1f3fb);
        EMOJIS_MAP.put(128145, R.drawable.emoji_1f491);
        EMOJIS_MAP.put(128143, R.drawable.emoji_1f48f);
        EMOJIS_MAP.put(128106, R.drawable.emoji_1f46a);
        EMOJIS_MAP.put(128090, R.drawable.emoji_1f45a);
        EMOJIS_MAP.put(128085, R.drawable.emoji_1f455);
        EMOJIS_MAP.put(128086, R.drawable.emoji_1f456);
        EMOJIS_MAP.put(128084, R.drawable.emoji_1f454);
        EMOJIS_MAP.put(128087, R.drawable.emoji_1f457);
        EMOJIS_MAP.put(128089, R.drawable.emoji_1f459);
        EMOJIS_MAP.put(128088, R.drawable.emoji_1f458);
        EMOJIS_MAP.put(128132, R.drawable.emoji_1f484);
        EMOJIS_MAP.put(128139, R.drawable.emoji_1f48b);
        EMOJIS_MAP.put(128099, R.drawable.emoji_1f463);
        EMOJIS_MAP.put(128096, R.drawable.emoji_1f460);
        EMOJIS_MAP.put(128097, R.drawable.emoji_1f461);
        EMOJIS_MAP.put(128098, R.drawable.emoji_1f462);
        EMOJIS_MAP.put(128094, R.drawable.emoji_1f45e);
        EMOJIS_MAP.put(128095, R.drawable.emoji_1f45f);
        EMOJIS_MAP.put(128082, R.drawable.emoji_1f452);
        EMOJIS_MAP.put(127913, R.drawable.emoji_1f3a9);
        EMOJIS_MAP.put(127891, R.drawable.emoji_1f393);
        EMOJIS_MAP.put(128081, R.drawable.emoji_1f451);
        EMOJIS_MAP.put(9937, R.drawable.emoji_26d1);
        SOFTBANKS_MAP.put(58426, R.drawable.emoji_1f392);
        EMOJIS_MAP.put(128093, R.drawable.emoji_1f45d);
        EMOJIS_MAP.put(128091, R.drawable.emoji_1f45b);
        EMOJIS_MAP.put(128092, R.drawable.emoji_1f45c);
        EMOJIS_MAP.put(128188, R.drawable.emoji_1f4bc);
        EMOJIS_MAP.put(128083, R.drawable.emoji_1f453);
        EMOJIS_MAP.put(128374, R.drawable.emoji_1f576);
        EMOJIS_MAP.put(128141, R.drawable.emoji_1f48d);
        EMOJIS_MAP.put(127746, R.drawable.emoji_1f302);
        EMOJIS_MAP.put(128054, R.drawable.emoji_1f436);
        EMOJIS_MAP.put(128049, R.drawable.emoji_1f431);
        EMOJIS_MAP.put(128045, R.drawable.emoji_1f42d);
        EMOJIS_MAP.put(128057, R.drawable.emoji_1f439);
        EMOJIS_MAP.put(128048, R.drawable.emoji_1f430);
        EMOJIS_MAP.put(128059, R.drawable.emoji_1f43b);
        EMOJIS_MAP.put(128060, R.drawable.emoji_1f43c);
        EMOJIS_MAP.put(128040, R.drawable.emoji_1f428);
        EMOJIS_MAP.put(128047, R.drawable.emoji_1f42f);
        EMOJIS_MAP.put(129409, R.drawable.emoji_1f981);
        EMOJIS_MAP.put(128046, R.drawable.emoji_1f42e);
        EMOJIS_MAP.put(128055, R.drawable.emoji_1f437);
        EMOJIS_MAP.put(128061, R.drawable.emoji_1f43d);
        EMOJIS_MAP.put(128056, R.drawable.emoji_1f438);
        EMOJIS_MAP.put(128025, R.drawable.emoji_1f419);
        EMOJIS_MAP.put(128053, R.drawable.emoji_1f435);
        EMOJIS_MAP.put(128584, R.drawable.emoji_1f648);
        EMOJIS_MAP.put(128585, R.drawable.emoji_1f649);
        EMOJIS_MAP.put(128586, R.drawable.emoji_1f64a);
        EMOJIS_MAP.put(128018, R.drawable.emoji_1f412);
        EMOJIS_MAP.put(128020, R.drawable.emoji_1f414);
        EMOJIS_MAP.put(128039, R.drawable.emoji_1f427);
        EMOJIS_MAP.put(128038, R.drawable.emoji_1f426);
        EMOJIS_MAP.put(128036, R.drawable.emoji_1f424);
        EMOJIS_MAP.put(128035, R.drawable.emoji_1f423);
        EMOJIS_MAP.put(128037, R.drawable.emoji_1f425);
        EMOJIS_MAP.put(128058, R.drawable.emoji_1f43a);
        EMOJIS_MAP.put(128023, R.drawable.emoji_1f417);
        EMOJIS_MAP.put(128052, R.drawable.emoji_1f434);
        EMOJIS_MAP.put(129412, R.drawable.emoji_1f984);
        EMOJIS_MAP.put(128029, R.drawable.emoji_1f41d);
        EMOJIS_MAP.put(128027, R.drawable.emoji_1f41b);
        EMOJIS_MAP.put(128012, R.drawable.emoji_1f40c);
        EMOJIS_MAP.put(128030, R.drawable.emoji_1f41e);
        EMOJIS_MAP.put(128028, R.drawable.emoji_1f41c);
        EMOJIS_MAP.put(128375, R.drawable.emoji_1f577);
        EMOJIS_MAP.put(129410, R.drawable.emoji_1f982);
        EMOJIS_MAP.put(129408, R.drawable.emoji_1f980);
        EMOJIS_MAP.put(128013, R.drawable.emoji_1f40d);
        EMOJIS_MAP.put(128034, R.drawable.emoji_1f422);
        EMOJIS_MAP.put(128032, R.drawable.emoji_1f420);
        EMOJIS_MAP.put(128031, R.drawable.emoji_1f41f);
        EMOJIS_MAP.put(128033, R.drawable.emoji_1f421);
        EMOJIS_MAP.put(128044, R.drawable.emoji_1f42c);
        EMOJIS_MAP.put(128051, R.drawable.emoji_1f433);
        EMOJIS_MAP.put(128011, R.drawable.emoji_1f40b);
        EMOJIS_MAP.put(128010, R.drawable.emoji_1f40a);
        EMOJIS_MAP.put(128006, R.drawable.emoji_1f406);
        EMOJIS_MAP.put(128005, R.drawable.emoji_1f405);
        EMOJIS_MAP.put(128003, R.drawable.emoji_1f403);
        EMOJIS_MAP.put(128002, R.drawable.emoji_1f402);
        EMOJIS_MAP.put(128004, R.drawable.emoji_1f404);
        EMOJIS_MAP.put(128042, R.drawable.emoji_1f42a);
        EMOJIS_MAP.put(128043, R.drawable.emoji_1f42b);
        EMOJIS_MAP.put(128024, R.drawable.emoji_1f418);
        EMOJIS_MAP.put(128016, R.drawable.emoji_1f410);
        EMOJIS_MAP.put(128015, R.drawable.emoji_1f40f);
        EMOJIS_MAP.put(128017, R.drawable.emoji_1f411);
        EMOJIS_MAP.put(128014, R.drawable.emoji_1f40e);
        EMOJIS_MAP.put(128022, R.drawable.emoji_1f416);
        EMOJIS_MAP.put(128000, R.drawable.emoji_1f400);
        EMOJIS_MAP.put(128001, R.drawable.emoji_1f401);
        EMOJIS_MAP.put(128019, R.drawable.emoji_1f413);
        EMOJIS_MAP.put(129411, R.drawable.emoji_1f983);
        EMOJIS_MAP.put(128330, R.drawable.emoji_1f54a);
        EMOJIS_MAP.put(128021, R.drawable.emoji_1f415);
        EMOJIS_MAP.put(128041, R.drawable.emoji_1f429);
        EMOJIS_MAP.put(128008, R.drawable.emoji_1f408);
        EMOJIS_MAP.put(128007, R.drawable.emoji_1f407);
        EMOJIS_MAP.put(128063, R.drawable.emoji_1f43f);
        EMOJIS_MAP.put(128062, R.drawable.emoji_1f43e);
        EMOJIS_MAP.put(128009, R.drawable.emoji_1f409);
        EMOJIS_MAP.put(128050, R.drawable.emoji_1f432);
        EMOJIS_MAP.put(127797, R.drawable.emoji_1f335);
        SOFTBANKS_MAP.put(57395, R.drawable.emoji_1f384);
        EMOJIS_MAP.put(127794, R.drawable.emoji_1f332);
        EMOJIS_MAP.put(127795, R.drawable.emoji_1f333);
        EMOJIS_MAP.put(127796, R.drawable.emoji_1f334);
        SOFTBANKS_MAP.put(57616, R.drawable.emoji_1f331);
        EMOJIS_MAP.put(127807, R.drawable.emoji_1f33f);
        EMOJIS_MAP.put(127808, R.drawable.emoji_1f340);
        EMOJIS_MAP.put(9752, R.drawable.emoji_2618);
        EMOJIS_MAP.put(127885, R.drawable.emoji_1f38d);
        EMOJIS_MAP.put(127883, R.drawable.emoji_1f38b);
        EMOJIS_MAP.put(127811, R.drawable.emoji_1f343);
        EMOJIS_MAP.put(127810, R.drawable.emoji_1f342);
        EMOJIS_MAP.put(127809, R.drawable.emoji_1f341);
        EMOJIS_MAP.put(127806, R.drawable.emoji_1f33e);
        EMOJIS_MAP.put(127802, R.drawable.emoji_1f33a);
        EMOJIS_MAP.put(127803, R.drawable.emoji_1f33b);
        EMOJIS_MAP.put(127801, R.drawable.emoji_1f339);
        EMOJIS_MAP.put(127799, R.drawable.emoji_1f337);
        EMOJIS_MAP.put(127804, R.drawable.emoji_1f33c);
        EMOJIS_MAP.put(127800, R.drawable.emoji_1f338);
        EMOJIS_MAP.put(128144, R.drawable.emoji_1f490);
        EMOJIS_MAP.put(127812, R.drawable.emoji_1f344);
        EMOJIS_MAP.put(127792, R.drawable.emoji_1f330);
        EMOJIS_MAP.put(127875, R.drawable.emoji_1f383);
        EMOJIS_MAP.put(128026, R.drawable.emoji_1f41a);
        EMOJIS_MAP.put(128376, R.drawable.emoji_1f578);
        EMOJIS_MAP.put(127757, R.drawable.emoji_1f30d);
        EMOJIS_MAP.put(127758, R.drawable.emoji_1f30e);
        EMOJIS_MAP.put(127759, R.drawable.emoji_1f30f);
        EMOJIS_MAP.put(127765, R.drawable.emoji_1f315);
        EMOJIS_MAP.put(127766, R.drawable.emoji_1f316);
        EMOJIS_MAP.put(127767, R.drawable.emoji_1f317);
        EMOJIS_MAP.put(127768, R.drawable.emoji_1f318);
        EMOJIS_MAP.put(127761, R.drawable.emoji_1f311);
        EMOJIS_MAP.put(127762, R.drawable.emoji_1f312);
        EMOJIS_MAP.put(127763, R.drawable.emoji_1f313);
        EMOJIS_MAP.put(127764, R.drawable.emoji_1f314);
        EMOJIS_MAP.put(127770, R.drawable.emoji_1f31a);
        EMOJIS_MAP.put(127773, R.drawable.emoji_1f31d);
        EMOJIS_MAP.put(127771, R.drawable.emoji_1f31b);
        EMOJIS_MAP.put(127772, R.drawable.emoji_1f31c);
        EMOJIS_MAP.put(127774, R.drawable.emoji_1f31e);
        EMOJIS_MAP.put(127769, R.drawable.emoji_1f319);
        EMOJIS_MAP.put(11088, R.drawable.emoji_2b50);
        EMOJIS_MAP.put(127775, R.drawable.emoji_1f31f);
        SOFTBANKS_MAP.put(58165, R.drawable.emoji_1f31f);
        EMOJIS_MAP.put(128171, R.drawable.emoji_1f4ab);
        EMOJIS_MAP.put(10024, R.drawable.emoji_2728);
        SOFTBANKS_MAP.put(58158, R.drawable.emoji_2728);
        EMOJIS_MAP.put(9732, R.drawable.emoji_2604);
        EMOJIS_MAP.put(9728, R.drawable.emoji_2600);
        EMOJIS_MAP.put(127780, R.drawable.emoji_1f324);
        EMOJIS_MAP.put(9925, R.drawable.emoji_26c5);
        EMOJIS_MAP.put(127781, R.drawable.emoji_1f325);
        EMOJIS_MAP.put(127782, R.drawable.emoji_1f326);
        EMOJIS_MAP.put(9729, R.drawable.emoji_2601);
        EMOJIS_MAP.put(127783, R.drawable.emoji_1f327);
        EMOJIS_MAP.put(9928, R.drawable.emoji_26c8);
        EMOJIS_MAP.put(127785, R.drawable.emoji_1f329);
        EMOJIS_MAP.put(9889, R.drawable.emoji_26a1);
        SOFTBANKS_MAP.put(57629, R.drawable.emoji_1f525);
        EMOJIS_MAP.put(128165, R.drawable.emoji_1f4a5);
        EMOJIS_MAP.put(10052, R.drawable.emoji_2744);
        EMOJIS_MAP.put(127784, R.drawable.emoji_1f328);
        EMOJIS_MAP.put(9731, R.drawable.emoji_2603);
        EMOJIS_MAP.put(9924, R.drawable.emoji_26c4);
        EMOJIS_MAP.put(127788, R.drawable.emoji_1f32c);
        EMOJIS_MAP.put(128168, R.drawable.emoji_1f4a8);
        EMOJIS_MAP.put(127786, R.drawable.emoji_1f32a);
        EMOJIS_MAP.put(127787, R.drawable.emoji_1f32b);
        EMOJIS_MAP.put(9730, R.drawable.emoji_2602);
        EMOJIS_MAP.put(9748, R.drawable.emoji_2614);
        EMOJIS_MAP.put(128166, R.drawable.emoji_1f4a6);
        EMOJIS_MAP.put(128167, R.drawable.emoji_1f4a7);
        EMOJIS_MAP.put(127754, R.drawable.emoji_1f30a);
        EMOJIS_MAP.put(127823, R.drawable.emoji_1f34f);
        EMOJIS_MAP.put(127822, R.drawable.emoji_1f34e);
        EMOJIS_MAP.put(127824, R.drawable.emoji_1f350);
        EMOJIS_MAP.put(127818, R.drawable.emoji_1f34a);
        EMOJIS_MAP.put(127819, R.drawable.emoji_1f34b);
        EMOJIS_MAP.put(127820, R.drawable.emoji_1f34c);
        EMOJIS_MAP.put(127817, R.drawable.emoji_1f349);
        EMOJIS_MAP.put(127815, R.drawable.emoji_1f347);
        EMOJIS_MAP.put(127827, R.drawable.emoji_1f353);
        EMOJIS_MAP.put(127816, R.drawable.emoji_1f348);
        EMOJIS_MAP.put(127826, R.drawable.emoji_1f352);
        EMOJIS_MAP.put(127825, R.drawable.emoji_1f351);
        EMOJIS_MAP.put(127821, R.drawable.emoji_1f34d);
        EMOJIS_MAP.put(127813, R.drawable.emoji_1f345);
        EMOJIS_MAP.put(127814, R.drawable.emoji_1f346);
        EMOJIS_MAP.put(127798, R.drawable.emoji_1f336);
        EMOJIS_MAP.put(127805, R.drawable.emoji_1f33d);
        EMOJIS_MAP.put(127840, R.drawable.emoji_1f360);
        EMOJIS_MAP.put(127855, R.drawable.emoji_1f36f);
        EMOJIS_MAP.put(127838, R.drawable.emoji_1f35e);
        EMOJIS_MAP.put(129472, R.drawable.emoji_1f9c0);
        EMOJIS_MAP.put(127831, R.drawable.emoji_1f357);
        EMOJIS_MAP.put(127830, R.drawable.emoji_1f356);
        EMOJIS_MAP.put(127844, R.drawable.emoji_1f364);
        EMOJIS_MAP.put(127859, R.drawable.emoji_1f373);
        EMOJIS_MAP.put(127828, R.drawable.emoji_1f354);
        EMOJIS_MAP.put(127839, R.drawable.emoji_1f35f);
        EMOJIS_MAP.put(127789, R.drawable.emoji_1f32d);
        EMOJIS_MAP.put(127829, R.drawable.emoji_1f355);
        EMOJIS_MAP.put(127837, R.drawable.emoji_1f35d);
        EMOJIS_MAP.put(127790, R.drawable.emoji_1f32e);
        EMOJIS_MAP.put(127791, R.drawable.emoji_1f32f);
        EMOJIS_MAP.put(127836, R.drawable.emoji_1f35c);
        EMOJIS_MAP.put(127858, R.drawable.emoji_1f372);
        EMOJIS_MAP.put(127845, R.drawable.emoji_1f365);
        EMOJIS_MAP.put(127843, R.drawable.emoji_1f363);
        EMOJIS_MAP.put(127857, R.drawable.emoji_1f371);
        EMOJIS_MAP.put(127835, R.drawable.emoji_1f35b);
        EMOJIS_MAP.put(127833, R.drawable.emoji_1f359);
        EMOJIS_MAP.put(127834, R.drawable.emoji_1f35a);
        EMOJIS_MAP.put(127832, R.drawable.emoji_1f358);
        EMOJIS_MAP.put(127842, R.drawable.emoji_1f362);
        EMOJIS_MAP.put(127841, R.drawable.emoji_1f361);
        EMOJIS_MAP.put(127847, R.drawable.emoji_1f367);
        EMOJIS_MAP.put(127848, R.drawable.emoji_1f368);
        EMOJIS_MAP.put(127846, R.drawable.emoji_1f366);
        EMOJIS_MAP.put(127856, R.drawable.emoji_1f370);
        EMOJIS_MAP.put(127874, R.drawable.emoji_1f382);
        EMOJIS_MAP.put(127854, R.drawable.emoji_1f36e);
        EMOJIS_MAP.put(127852, R.drawable.emoji_1f36c);
        EMOJIS_MAP.put(127853, R.drawable.emoji_1f36d);
        EMOJIS_MAP.put(127851, R.drawable.emoji_1f36b);
        EMOJIS_MAP.put(127871, R.drawable.emoji_1f37f);
        EMOJIS_MAP.put(127849, R.drawable.emoji_1f369);
        EMOJIS_MAP.put(127850, R.drawable.emoji_1f36a);
        EMOJIS_MAP.put(127866, R.drawable.emoji_1f37a);
        EMOJIS_MAP.put(127867, R.drawable.emoji_1f37b);
        EMOJIS_MAP.put(127863, R.drawable.emoji_1f377);
        EMOJIS_MAP.put(127864, R.drawable.emoji_1f378);
        EMOJIS_MAP.put(127865, R.drawable.emoji_1f379);
        EMOJIS_MAP.put(127870, R.drawable.emoji_1f37e);
        EMOJIS_MAP.put(127862, R.drawable.emoji_1f376);
        EMOJIS_MAP.put(127861, R.drawable.emoji_1f375);
        EMOJIS_MAP.put(9749, R.drawable.emoji_2615);
        EMOJIS_MAP.put(127868, R.drawable.emoji_1f37c);
        EMOJIS_MAP.put(127860, R.drawable.emoji_1f374);
        EMOJIS_MAP.put(127869, R.drawable.emoji_1f37d);
        EMOJIS_MAP.put(9917, R.drawable.emoji_26bd);
        EMOJIS_MAP.put(127936, R.drawable.emoji_1f3c0);
        EMOJIS_MAP.put(127944, R.drawable.emoji_1f3c8);
        EMOJIS_MAP.put(9918, R.drawable.emoji_26be);
        EMOJIS_MAP.put(127934, R.drawable.emoji_1f3be);
        EMOJIS_MAP.put(127952, R.drawable.emoji_1f3d0);
        EMOJIS_MAP.put(127945, R.drawable.emoji_1f3c9);
        EMOJIS_MAP.put(127921, R.drawable.emoji_1f3b1);
        EMOJIS_MAP.put(9971, R.drawable.emoji_26f3);
        EMOJIS_MAP.put(127948, R.drawable.emoji_1f3cc);
        EMOJIS_MAP.put(127955, R.drawable.emoji_1f3d3);
        EMOJIS_MAP.put(127992, R.drawable.emoji_1f3f8);
        EMOJIS_MAP.put(127954, R.drawable.emoji_1f3d2);
        EMOJIS_MAP.put(127953, R.drawable.emoji_1f3d1);
        EMOJIS_MAP.put(127951, R.drawable.emoji_1f3cf);
        EMOJIS_MAP.put(127935, R.drawable.emoji_1f3bf);
        EMOJIS_MAP.put(9975, R.drawable.emoji_26f7);
        EMOJIS_MAP.put(127938, R.drawable.emoji_1f3c2);
        EMOJIS_MAP.put(9976, R.drawable.emoji_26f8);
        EMOJIS_MAP.put(127993, R.drawable.emoji_1f3f9);
        EMOJIS_MAP.put(127907, R.drawable.emoji_1f3a3);
        EMOJIS_MAP.put(128675, R.drawable.emoji_1f6a3_1f3fb);
        EMOJIS_MAP.put(127946, R.drawable.emoji_1f3ca_1f3fb);
        EMOJIS_MAP.put(127940, R.drawable.emoji_1f3c4_1f3fb);
        EMOJIS_MAP.put(128704, R.drawable.emoji_1f6c0_1f3fb);
        EMOJIS_MAP.put(9977, R.drawable.emoji_26f9_1f3fb);
        EMOJIS_MAP.put(127947, R.drawable.emoji_1f3cb_1f3fb);
        EMOJIS_MAP.put(128692, R.drawable.emoji_1f6b4_1f3fb);
        EMOJIS_MAP.put(128693, R.drawable.emoji_1f6b5_1f3fb);
        EMOJIS_MAP.put(127943, R.drawable.emoji_1f3c7_1f3fb);
        EMOJIS_MAP.put(128372, R.drawable.emoji_1f574);
        EMOJIS_MAP.put(127942, R.drawable.emoji_1f3c6);
        EMOJIS_MAP.put(127933, R.drawable.emoji_1f3bd);
        EMOJIS_MAP.put(127941, R.drawable.emoji_1f3c5);
        EMOJIS_MAP.put(127894, R.drawable.emoji_1f396);
        EMOJIS_MAP.put(127895, R.drawable.emoji_1f397);
        EMOJIS_MAP.put(127989, R.drawable.emoji_1f3f5);
        SOFTBANKS_MAP.put(57637, R.drawable.emoji_1f3ab);
        EMOJIS_MAP.put(127903, R.drawable.emoji_1f39f);
        EMOJIS_MAP.put(127917, R.drawable.emoji_1f3ad);
        EMOJIS_MAP.put(127912, R.drawable.emoji_1f3a8);
        EMOJIS_MAP.put(127914, R.drawable.emoji_1f3aa);
        EMOJIS_MAP.put(127908, R.drawable.emoji_1f3a4);
        EMOJIS_MAP.put(127911, R.drawable.emoji_1f3a7);
        EMOJIS_MAP.put(127932, R.drawable.emoji_1f3bc);
        EMOJIS_MAP.put(127929, R.drawable.emoji_1f3b9);
        EMOJIS_MAP.put(127927, R.drawable.emoji_1f3b7);
        EMOJIS_MAP.put(127930, R.drawable.emoji_1f3ba);
        EMOJIS_MAP.put(127931, R.drawable.emoji_1f3bb);
        EMOJIS_MAP.put(127928, R.drawable.emoji_1f3b8);
        EMOJIS_MAP.put(127916, R.drawable.emoji_1f3ac);
        EMOJIS_MAP.put(127918, R.drawable.emoji_1f3ae);
        EMOJIS_MAP.put(128126, R.drawable.emoji_1f47e);
        EMOJIS_MAP.put(127919, R.drawable.emoji_1f3af);
        EMOJIS_MAP.put(127922, R.drawable.emoji_1f3b2);
        EMOJIS_MAP.put(127920, R.drawable.emoji_1f3b0);
        EMOJIS_MAP.put(127923, R.drawable.emoji_1f3b3);
        EMOJIS_MAP.put(128663, R.drawable.emoji_1f697);
        EMOJIS_MAP.put(128661, R.drawable.emoji_1f695);
        EMOJIS_MAP.put(128665, R.drawable.emoji_1f699);
        EMOJIS_MAP.put(128652, R.drawable.emoji_1f68c);
        EMOJIS_MAP.put(128654, R.drawable.emoji_1f68e);
        EMOJIS_MAP.put(127950, R.drawable.emoji_1f3ce);
        EMOJIS_MAP.put(128659, R.drawable.emoji_1f693);
        EMOJIS_MAP.put(128657, R.drawable.emoji_1f691);
        EMOJIS_MAP.put(128658, R.drawable.emoji_1f692);
        EMOJIS_MAP.put(128656, R.drawable.emoji_1f690);
        EMOJIS_MAP.put(128666, R.drawable.emoji_1f69a);
        EMOJIS_MAP.put(128667, R.drawable.emoji_1f69b);
        EMOJIS_MAP.put(128668, R.drawable.emoji_1f69c);
        EMOJIS_MAP.put(127949, R.drawable.emoji_1f3cd);
        EMOJIS_MAP.put(128690, R.drawable.emoji_1f6b2);
        EMOJIS_MAP.put(128680, R.drawable.emoji_1f6a8);
        EMOJIS_MAP.put(128660, R.drawable.emoji_1f694);
        EMOJIS_MAP.put(128653, R.drawable.emoji_1f68d);
        EMOJIS_MAP.put(128664, R.drawable.emoji_1f698);
        EMOJIS_MAP.put(128662, R.drawable.emoji_1f696);
        EMOJIS_MAP.put(128673, R.drawable.emoji_1f6a1);
        EMOJIS_MAP.put(128672, R.drawable.emoji_1f6a0);
        EMOJIS_MAP.put(128671, R.drawable.emoji_1f69f);
        EMOJIS_MAP.put(128651, R.drawable.emoji_1f68b);
        EMOJIS_MAP.put(128643, R.drawable.emoji_1f683);
        EMOJIS_MAP.put(128669, R.drawable.emoji_1f69d);
        EMOJIS_MAP.put(128644, R.drawable.emoji_1f684);
        EMOJIS_MAP.put(128645, R.drawable.emoji_1f685);
        EMOJIS_MAP.put(128648, R.drawable.emoji_1f688);
        EMOJIS_MAP.put(128670, R.drawable.emoji_1f69e);
        EMOJIS_MAP.put(128642, R.drawable.emoji_1f682);
        EMOJIS_MAP.put(128646, R.drawable.emoji_1f686);
        EMOJIS_MAP.put(128647, R.drawable.emoji_1f687);
        EMOJIS_MAP.put(128650, R.drawable.emoji_1f68a);
        EMOJIS_MAP.put(128649, R.drawable.emoji_1f689);
        EMOJIS_MAP.put(128641, R.drawable.emoji_1f681);
        EMOJIS_MAP.put(128745, R.drawable.emoji_1f6e9);
        EMOJIS_MAP.put(9992, R.drawable.emoji_2708);
        EMOJIS_MAP.put(128747, R.drawable.emoji_1f6eb);
        EMOJIS_MAP.put(128748, R.drawable.emoji_1f6ec);
        EMOJIS_MAP.put(9973, R.drawable.emoji_26f5);
        EMOJIS_MAP.put(128741, R.drawable.emoji_1f6e5);
        EMOJIS_MAP.put(128676, R.drawable.emoji_1f6a4);
        EMOJIS_MAP.put(9972, R.drawable.emoji_26f4);
        EMOJIS_MAP.put(128755, R.drawable.emoji_1f6f3);
        EMOJIS_MAP.put(128640, R.drawable.emoji_1f680);
        EMOJIS_MAP.put(128752, R.drawable.emoji_1f6f0);
        EMOJIS_MAP.put(128186, R.drawable.emoji_1f4ba);
        EMOJIS_MAP.put(9875, R.drawable.emoji_2693);
        EMOJIS_MAP.put(128679, R.drawable.emoji_1f6a7);
        EMOJIS_MAP.put(9981, R.drawable.emoji_26fd);
        EMOJIS_MAP.put(128655, R.drawable.emoji_1f68f);
        EMOJIS_MAP.put(128678, R.drawable.emoji_1f6a6);
        EMOJIS_MAP.put(128677, R.drawable.emoji_1f6a5);
        EMOJIS_MAP.put(127937, R.drawable.emoji_1f3c1);
        EMOJIS_MAP.put(128674, R.drawable.emoji_1f6a2);
        EMOJIS_MAP.put(127905, R.drawable.emoji_1f3a1);
        EMOJIS_MAP.put(127906, R.drawable.emoji_1f3a2);
        EMOJIS_MAP.put(127904, R.drawable.emoji_1f3a0);
        EMOJIS_MAP.put(127959, R.drawable.emoji_1f3d7);
        EMOJIS_MAP.put(127745, R.drawable.emoji_1f301);
        EMOJIS_MAP.put(128508, R.drawable.emoji_1f5fc);
        EMOJIS_MAP.put(127981, R.drawable.emoji_1f3ed);
        EMOJIS_MAP.put(9970, R.drawable.emoji_26f2);
        SOFTBANKS_MAP.put(58438, R.drawable.emoji_1f391);
        EMOJIS_MAP.put(9968, R.drawable.emoji_26f0);
        EMOJIS_MAP.put(127956, R.drawable.emoji_1f3d4);
        EMOJIS_MAP.put(128507, R.drawable.emoji_1f5fb);
        EMOJIS_MAP.put(127755, R.drawable.emoji_1f30b);
        EMOJIS_MAP.put(128510, R.drawable.emoji_1f5fe);
        EMOJIS_MAP.put(127957, R.drawable.emoji_1f3d5);
        EMOJIS_MAP.put(9978, R.drawable.emoji_26fa);
        EMOJIS_MAP.put(127966, R.drawable.emoji_1f3de);
        EMOJIS_MAP.put(128739, R.drawable.emoji_1f6e3);
        EMOJIS_MAP.put(128740, R.drawable.emoji_1f6e4);
        EMOJIS_MAP.put(127749, R.drawable.emoji_1f305);
        EMOJIS_MAP.put(127748, R.drawable.emoji_1f304);
        EMOJIS_MAP.put(127964, R.drawable.emoji_1f3dc);
        EMOJIS_MAP.put(127958, R.drawable.emoji_1f3d6);
        EMOJIS_MAP.put(127965, R.drawable.emoji_1f3dd);
        EMOJIS_MAP.put(127751, R.drawable.emoji_1f307);
        EMOJIS_MAP.put(127750, R.drawable.emoji_1f306);
        EMOJIS_MAP.put(127961, R.drawable.emoji_1f3d9);
        EMOJIS_MAP.put(127747, R.drawable.emoji_1f303);
        EMOJIS_MAP.put(127776, R.drawable.emoji_1f320);
        EMOJIS_MAP.put(127753, R.drawable.emoji_1f309);
        EMOJIS_MAP.put(127756, R.drawable.emoji_1f30c);
        EMOJIS_MAP.put(127878, R.drawable.emoji_1f386);
        EMOJIS_MAP.put(127879, R.drawable.emoji_1f387);
        SOFTBANKS_MAP.put(58444, R.drawable.emoji_1f308);
        EMOJIS_MAP.put(127960, R.drawable.emoji_1f3d8);
        EMOJIS_MAP.put(127984, R.drawable.emoji_1f3f0);
        EMOJIS_MAP.put(127983, R.drawable.emoji_1f3ef);
        EMOJIS_MAP.put(127967, R.drawable.emoji_1f3df);
        EMOJIS_MAP.put(128509, R.drawable.emoji_1f5fd);
        EMOJIS_MAP.put(127968, R.drawable.emoji_1f3e0);
        EMOJIS_MAP.put(127969, R.drawable.emoji_1f3e1);
        EMOJIS_MAP.put(127962, R.drawable.emoji_1f3da);
        EMOJIS_MAP.put(127970, R.drawable.emoji_1f3e2);
        EMOJIS_MAP.put(127980, R.drawable.emoji_1f3ec);
        EMOJIS_MAP.put(127971, R.drawable.emoji_1f3e3);
        EMOJIS_MAP.put(127972, R.drawable.emoji_1f3e4);
        EMOJIS_MAP.put(127973, R.drawable.emoji_1f3e5);
        EMOJIS_MAP.put(127974, R.drawable.emoji_1f3e6);
        EMOJIS_MAP.put(127976, R.drawable.emoji_1f3e8);
        EMOJIS_MAP.put(127978, R.drawable.emoji_1f3ea);
        EMOJIS_MAP.put(127979, R.drawable.emoji_1f3eb);
        EMOJIS_MAP.put(127977, R.drawable.emoji_1f3e9);
        EMOJIS_MAP.put(128146, R.drawable.emoji_1f492);
        EMOJIS_MAP.put(127963, R.drawable.emoji_1f3db);
        EMOJIS_MAP.put(9962, R.drawable.emoji_26ea);
        EMOJIS_MAP.put(128332, R.drawable.emoji_1f54c);
        EMOJIS_MAP.put(128333, R.drawable.emoji_1f54d);
        EMOJIS_MAP.put(128331, R.drawable.emoji_1f54b);
        EMOJIS_MAP.put(9961, R.drawable.emoji_26e9);
        EMOJIS_MAP.put(8986, R.drawable.emoji_231a);
        EMOJIS_MAP.put(128241, R.drawable.emoji_1f4f1);
        EMOJIS_MAP.put(128242, R.drawable.emoji_1f4f2);
        EMOJIS_MAP.put(128187, R.drawable.emoji_1f4bb);
        EMOJIS_MAP.put(9000, R.drawable.emoji_2328);
        EMOJIS_MAP.put(128421, R.drawable.emoji_1f5a5);
        EMOJIS_MAP.put(128424, R.drawable.emoji_1f5a8);
        EMOJIS_MAP.put(128433, R.drawable.emoji_1f5b1);
        EMOJIS_MAP.put(128434, R.drawable.emoji_1f5b2);
        EMOJIS_MAP.put(128377, R.drawable.emoji_1f579);
        EMOJIS_MAP.put(128476, R.drawable.emoji_1f5dc);
        EMOJIS_MAP.put(128189, R.drawable.emoji_1f4bd);
        EMOJIS_MAP.put(128190, R.drawable.emoji_1f4be);
        EMOJIS_MAP.put(128191, R.drawable.emoji_1f4bf);
        EMOJIS_MAP.put(128192, R.drawable.emoji_1f4c0);
        EMOJIS_MAP.put(128252, R.drawable.emoji_1f4fc);
        EMOJIS_MAP.put(128247, R.drawable.emoji_1f4f7);
        EMOJIS_MAP.put(128248, R.drawable.emoji_1f4f8);
        EMOJIS_MAP.put(128249, R.drawable.emoji_1f4f9);
        EMOJIS_MAP.put(127909, R.drawable.emoji_1f3a5);
        EMOJIS_MAP.put(128253, R.drawable.emoji_1f4fd);
        EMOJIS_MAP.put(127902, R.drawable.emoji_1f39e);
        EMOJIS_MAP.put(128222, R.drawable.emoji_1f4de);
        EMOJIS_MAP.put(9742, R.drawable.emoji_260e);
        EMOJIS_MAP.put(128223, R.drawable.emoji_1f4df);
        EMOJIS_MAP.put(128224, R.drawable.emoji_1f4e0);
        EMOJIS_MAP.put(128250, R.drawable.emoji_1f4fa);
        EMOJIS_MAP.put(128251, R.drawable.emoji_1f4fb);
        EMOJIS_MAP.put(127897, R.drawable.emoji_1f399);
        EMOJIS_MAP.put(127898, R.drawable.emoji_1f39a);
        EMOJIS_MAP.put(127899, R.drawable.emoji_1f39b);
        EMOJIS_MAP.put(9201, R.drawable.emoji_23f1);
        EMOJIS_MAP.put(9202, R.drawable.emoji_23f2);
        EMOJIS_MAP.put(9200, R.drawable.emoji_23f0);
        EMOJIS_MAP.put(128368, R.drawable.emoji_1f570);
        EMOJIS_MAP.put(9203, R.drawable.emoji_23f3);
        EMOJIS_MAP.put(8987, R.drawable.emoji_231b);
        EMOJIS_MAP.put(128225, R.drawable.emoji_1f4e1);
        EMOJIS_MAP.put(128267, R.drawable.emoji_1f50b);
        EMOJIS_MAP.put(128268, R.drawable.emoji_1f50c);
        EMOJIS_MAP.put(128161, R.drawable.emoji_1f4a1);
        EMOJIS_MAP.put(128294, R.drawable.emoji_1f526);
        EMOJIS_MAP.put(128367, R.drawable.emoji_1f56f);
        EMOJIS_MAP.put(128465, R.drawable.emoji_1f5d1);
        EMOJIS_MAP.put(128738, R.drawable.emoji_1f6e2);
        EMOJIS_MAP.put(128184, R.drawable.emoji_1f4b8);
        EMOJIS_MAP.put(128181, R.drawable.emoji_1f4b5);
        EMOJIS_MAP.put(128180, R.drawable.emoji_1f4b4);
        EMOJIS_MAP.put(128183, R.drawable.emoji_1f4b7);
        EMOJIS_MAP.put(128182, R.drawable.emoji_1f4b6);
        EMOJIS_MAP.put(128176, R.drawable.emoji_1f4b0);
        EMOJIS_MAP.put(128179, R.drawable.emoji_1f4b3);
        EMOJIS_MAP.put(128142, R.drawable.emoji_1f48e);
        EMOJIS_MAP.put(9878, R.drawable.emoji_2696);
        EMOJIS_MAP.put(128295, R.drawable.emoji_1f527);
        EMOJIS_MAP.put(128296, R.drawable.emoji_1f528);
        EMOJIS_MAP.put(9874, R.drawable.emoji_2692);
        EMOJIS_MAP.put(128736, R.drawable.emoji_1f6e0);
        EMOJIS_MAP.put(9935, R.drawable.emoji_26cf);
        EMOJIS_MAP.put(128297, R.drawable.emoji_1f529);
        EMOJIS_MAP.put(9881, R.drawable.emoji_2699);
        EMOJIS_MAP.put(9939, R.drawable.emoji_26d3);
        EMOJIS_MAP.put(128299, R.drawable.emoji_1f52b);
        EMOJIS_MAP.put(128163, R.drawable.emoji_1f4a3);
        EMOJIS_MAP.put(128298, R.drawable.emoji_1f52a);
        EMOJIS_MAP.put(128481, R.drawable.emoji_1f5e1);
        EMOJIS_MAP.put(9876, R.drawable.emoji_2694);
        EMOJIS_MAP.put(128737, R.drawable.emoji_1f6e1);
        EMOJIS_MAP.put(128684, R.drawable.emoji_1f6ac);
        EMOJIS_MAP.put(9760, R.drawable.emoji_2620);
        EMOJIS_MAP.put(9904, R.drawable.emoji_26b0);
        EMOJIS_MAP.put(9905, R.drawable.emoji_26b1);
        EMOJIS_MAP.put(127994, R.drawable.emoji_1f3fa);
        EMOJIS_MAP.put(128302, R.drawable.emoji_1f52e);
        EMOJIS_MAP.put(128255, R.drawable.emoji_1f4ff);
        EMOJIS_MAP.put(128136, R.drawable.emoji_1f488);
        EMOJIS_MAP.put(9879, R.drawable.emoji_2697);
        EMOJIS_MAP.put(128300, R.drawable.emoji_1f52c);
        EMOJIS_MAP.put(128301, R.drawable.emoji_1f52d);
        EMOJIS_MAP.put(128371, R.drawable.emoji_1f573);
        EMOJIS_MAP.put(128138, R.drawable.emoji_1f48a);
        EMOJIS_MAP.put(128137, R.drawable.emoji_1f489);
        EMOJIS_MAP.put(127777, R.drawable.emoji_1f321);
        EMOJIS_MAP.put(127991, R.drawable.emoji_1f3f7);
        EMOJIS_MAP.put(128278, R.drawable.emoji_1f516);
        EMOJIS_MAP.put(128701, R.drawable.emoji_1f6bd);
        EMOJIS_MAP.put(128703, R.drawable.emoji_1f6bf);
        EMOJIS_MAP.put(128705, R.drawable.emoji_1f6c1);
        EMOJIS_MAP.put(128273, R.drawable.emoji_1f511);
        EMOJIS_MAP.put(128477, R.drawable.emoji_1f5dd);
        EMOJIS_MAP.put(128715, R.drawable.emoji_1f6cb);
        EMOJIS_MAP.put(128716, R.drawable.emoji_1f6cc);
        EMOJIS_MAP.put(128719, R.drawable.emoji_1f6cf);
        EMOJIS_MAP.put(128682, R.drawable.emoji_1f6aa);
        EMOJIS_MAP.put(128718, R.drawable.emoji_1f6ce);
        EMOJIS_MAP.put(128444, R.drawable.emoji_1f5bc);
        EMOJIS_MAP.put(128506, R.drawable.emoji_1f5fa);
        EMOJIS_MAP.put(9969, R.drawable.emoji_26f1);
        EMOJIS_MAP.put(128511, R.drawable.emoji_1f5ff);
        EMOJIS_MAP.put(128717, R.drawable.emoji_1f6cd);
        EMOJIS_MAP.put(127880, R.drawable.emoji_1f388);
        EMOJIS_MAP.put(127887, R.drawable.emoji_1f38f);
        EMOJIS_MAP.put(127872, R.drawable.emoji_1f380);
        EMOJIS_MAP.put(127873, R.drawable.emoji_1f381);
        EMOJIS_MAP.put(127882, R.drawable.emoji_1f38a);
        EMOJIS_MAP.put(127881, R.drawable.emoji_1f389);
        SOFTBANKS_MAP.put(58424, R.drawable.emoji_1f38e);
        EMOJIS_MAP.put(127888, R.drawable.emoji_1f390);
        EMOJIS_MAP.put(127884, R.drawable.emoji_1f38c);
        EMOJIS_MAP.put(127982, R.drawable.emoji_1f3ee);
        EMOJIS_MAP.put(9993, R.drawable.emoji_2709);
        EMOJIS_MAP.put(128233, R.drawable.emoji_1f4e9);
        EMOJIS_MAP.put(128232, R.drawable.emoji_1f4e8);
        EMOJIS_MAP.put(128231, R.drawable.emoji_1f4e7);
        EMOJIS_MAP.put(128140, R.drawable.emoji_1f48c);
        EMOJIS_MAP.put(128238, R.drawable.emoji_1f4ee);
        EMOJIS_MAP.put(128234, R.drawable.emoji_1f4ea);
        EMOJIS_MAP.put(128235, R.drawable.emoji_1f4eb);
        EMOJIS_MAP.put(128236, R.drawable.emoji_1f4ec);
        EMOJIS_MAP.put(128237, R.drawable.emoji_1f4ed);
        EMOJIS_MAP.put(128230, R.drawable.emoji_1f4e6);
        EMOJIS_MAP.put(128239, R.drawable.emoji_1f4ef);
        EMOJIS_MAP.put(128229, R.drawable.emoji_1f4e5);
        EMOJIS_MAP.put(128228, R.drawable.emoji_1f4e4);
        EMOJIS_MAP.put(128220, R.drawable.emoji_1f4dc);
        EMOJIS_MAP.put(128195, R.drawable.emoji_1f4c3);
        EMOJIS_MAP.put(128209, R.drawable.emoji_1f4d1);
        EMOJIS_MAP.put(128202, R.drawable.emoji_1f4ca);
        EMOJIS_MAP.put(128200, R.drawable.emoji_1f4c8);
        EMOJIS_MAP.put(128201, R.drawable.emoji_1f4c9);
        EMOJIS_MAP.put(128196, R.drawable.emoji_1f4c4);
        EMOJIS_MAP.put(128197, R.drawable.emoji_1f4c5);
        EMOJIS_MAP.put(128198, R.drawable.emoji_1f4c6);
        EMOJIS_MAP.put(128467, R.drawable.emoji_1f5d3);
        EMOJIS_MAP.put(128199, R.drawable.emoji_1f4c7);
        EMOJIS_MAP.put(128451, R.drawable.emoji_1f5c3);
        EMOJIS_MAP.put(128499, R.drawable.emoji_1f5f3);
        EMOJIS_MAP.put(128452, R.drawable.emoji_1f5c4);
        EMOJIS_MAP.put(128203, R.drawable.emoji_1f4cb);
        EMOJIS_MAP.put(128466, R.drawable.emoji_1f5d2);
        EMOJIS_MAP.put(128193, R.drawable.emoji_1f4c1);
        EMOJIS_MAP.put(128194, R.drawable.emoji_1f4c2);
        EMOJIS_MAP.put(128450, R.drawable.emoji_1f5c2);
        EMOJIS_MAP.put(128478, R.drawable.emoji_1f5de);
        EMOJIS_MAP.put(128240, R.drawable.emoji_1f4f0);
        EMOJIS_MAP.put(128211, R.drawable.emoji_1f4d3);
        EMOJIS_MAP.put(128213, R.drawable.emoji_1f4d5);
        EMOJIS_MAP.put(128215, R.drawable.emoji_1f4d7);
        EMOJIS_MAP.put(128216, R.drawable.emoji_1f4d8);
        EMOJIS_MAP.put(128217, R.drawable.emoji_1f4d9);
        EMOJIS_MAP.put(128212, R.drawable.emoji_1f4d4);
        EMOJIS_MAP.put(128210, R.drawable.emoji_1f4d2);
        EMOJIS_MAP.put(128218, R.drawable.emoji_1f4da);
        EMOJIS_MAP.put(128214, R.drawable.emoji_1f4d6);
        EMOJIS_MAP.put(128279, R.drawable.emoji_1f517);
        EMOJIS_MAP.put(128206, R.drawable.emoji_1f4ce);
        EMOJIS_MAP.put(128391, R.drawable.emoji_1f587);
        EMOJIS_MAP.put(9986, R.drawable.emoji_2702);
        EMOJIS_MAP.put(128208, R.drawable.emoji_1f4d0);
        EMOJIS_MAP.put(128207, R.drawable.emoji_1f4cf);
        EMOJIS_MAP.put(128204, R.drawable.emoji_1f4cc);
        EMOJIS_MAP.put(128205, R.drawable.emoji_1f4cd);
        EMOJIS_MAP.put(128681, R.drawable.emoji_1f6a9);
        EMOJIS_MAP.put(127987, R.drawable.emoji_1f3f3);
        EMOJIS_MAP.put(127988, R.drawable.emoji_1f3f4);
        EMOJIS_MAP.put(128272, R.drawable.emoji_1f510);
        EMOJIS_MAP.put(128274, R.drawable.emoji_1f512);
        EMOJIS_MAP.put(128275, R.drawable.emoji_1f513);
        EMOJIS_MAP.put(128271, R.drawable.emoji_1f50f);
        EMOJIS_MAP.put(128394, R.drawable.emoji_1f58a);
        EMOJIS_MAP.put(128395, R.drawable.emoji_1f58b);
        EMOJIS_MAP.put(10002, R.drawable.emoji_2712);
        EMOJIS_MAP.put(128221, R.drawable.emoji_1f4dd);
        EMOJIS_MAP.put(9999, R.drawable.emoji_270f);
        EMOJIS_MAP.put(128397, R.drawable.emoji_1f58d);
        EMOJIS_MAP.put(128396, R.drawable.emoji_1f58c);
        EMOJIS_MAP.put(128269, R.drawable.emoji_1f50d);
        EMOJIS_MAP.put(128270, R.drawable.emoji_1f50e);
        EMOJIS_MAP.put(10084, R.drawable.emoji_2764);
        EMOJIS_MAP.put(128155, R.drawable.emoji_1f49b);
        EMOJIS_MAP.put(128154, R.drawable.emoji_1f49a);
        EMOJIS_MAP.put(128153, R.drawable.emoji_1f499);
        EMOJIS_MAP.put(128156, R.drawable.emoji_1f49c);
        EMOJIS_MAP.put(128148, R.drawable.emoji_1f494);
        EMOJIS_MAP.put(10083, R.drawable.emoji_2763);
        EMOJIS_MAP.put(128149, R.drawable.emoji_1f495);
        EMOJIS_MAP.put(128158, R.drawable.emoji_1f49e);
        EMOJIS_MAP.put(128147, R.drawable.emoji_1f493);
        EMOJIS_MAP.put(128151, R.drawable.emoji_1f497);
        EMOJIS_MAP.put(128150, R.drawable.emoji_1f496);
        EMOJIS_MAP.put(128152, R.drawable.emoji_1f498);
        EMOJIS_MAP.put(128157, R.drawable.emoji_1f49d);
        EMOJIS_MAP.put(128159, R.drawable.emoji_1f49f);
        EMOJIS_MAP.put(9774, R.drawable.emoji_262e);
        EMOJIS_MAP.put(10013, R.drawable.emoji_271d);
        EMOJIS_MAP.put(9770, R.drawable.emoji_262a);
        EMOJIS_MAP.put(128329, R.drawable.emoji_1f549);
        EMOJIS_MAP.put(9784, R.drawable.emoji_2638);
        EMOJIS_MAP.put(128334, R.drawable.emoji_1f54e);
        EMOJIS_MAP.put(9775, R.drawable.emoji_262f);
        EMOJIS_MAP.put(127539, R.drawable.emoji_1f233);
        EMOJIS_MAP.put(127545, R.drawable.emoji_1f239);
        SOFTBANKS_MAP.put(58674, R.drawable.emoji_1f170);
        SOFTBANKS_MAP.put(58675, R.drawable.emoji_1f171);
        SOFTBANKS_MAP.put(58676, R.drawable.emoji_1f18e);
        SOFTBANKS_MAP.put(58677, R.drawable.emoji_1f17e);
        EMOJIS_MAP.put(127568, R.drawable.emoji_1f250);
        EMOJIS_MAP.put(12953, R.drawable.emoji_3299);
        EMOJIS_MAP.put(12951, R.drawable.emoji_3297);
        EMOJIS_MAP.put(127540, R.drawable.emoji_1f234);
        EMOJIS_MAP.put(127538, R.drawable.emoji_1f232);
        EMOJIS_MAP.put(127377, R.drawable.emoji_1f191);
        EMOJIS_MAP.put(127384, R.drawable.emoji_1f198);
        EMOJIS_MAP.put(9940, R.drawable.emoji_26d4);
        EMOJIS_MAP.put(128219, R.drawable.emoji_1f4db);
        EMOJIS_MAP.put(128683, R.drawable.emoji_1f6ab);
        EMOJIS_MAP.put(10060, R.drawable.emoji_274c);
        EMOJIS_MAP.put(11093, R.drawable.emoji_2b55);
        SOFTBANKS_MAP.put(58164, R.drawable.emoji_1f4a2);
        EMOJIS_MAP.put(128286, R.drawable.emoji_1f51e);
        EMOJIS_MAP.put(128245, R.drawable.emoji_1f4f5);
        EMOJIS_MAP.put(128687, R.drawable.emoji_1f6af);
        EMOJIS_MAP.put(128689, R.drawable.emoji_1f6b1);
        EMOJIS_MAP.put(128691, R.drawable.emoji_1f6b3);
        EMOJIS_MAP.put(128695, R.drawable.emoji_1f6b7);
        EMOJIS_MAP.put(8252, R.drawable.emoji_203c);
        EMOJIS_MAP.put(8265, R.drawable.emoji_2049);
        EMOJIS_MAP.put(10071, R.drawable.emoji_2757);
        EMOJIS_MAP.put(10067, R.drawable.emoji_2753);
        EMOJIS_MAP.put(10069, R.drawable.emoji_2755);
        EMOJIS_MAP.put(10068, R.drawable.emoji_2754);
        EMOJIS_MAP.put(128175, R.drawable.emoji_1f4af);
        SOFTBANKS_MAP.put(57938, R.drawable.emoji_26a0);
        EMOJIS_MAP.put(128696, R.drawable.emoji_1f6b8);
        EMOJIS_MAP.put(128262, R.drawable.emoji_1f506);
        EMOJIS_MAP.put(128261, R.drawable.emoji_1f505);
        EMOJIS_MAP.put(128305, R.drawable.emoji_1f531);
        EMOJIS_MAP.put(128304, R.drawable.emoji_1f530);
        EMOJIS_MAP.put(9851, R.drawable.emoji_267b);
        EMOJIS_MAP.put(10035, R.drawable.emoji_2733);
        EMOJIS_MAP.put(10055, R.drawable.emoji_2747);
        EMOJIS_MAP.put(10062, R.drawable.emoji_274e);
        EMOJIS_MAP.put(9989, R.drawable.emoji_2705);
        EMOJIS_MAP.put(128185, R.drawable.emoji_1f4b9);
        EMOJIS_MAP.put(127744, R.drawable.emoji_1f300);
        EMOJIS_MAP.put(128702, R.drawable.emoji_1f6be);
        EMOJIS_MAP.put(128688, R.drawable.emoji_1f6b0);
        EMOJIS_MAP.put(127359, R.drawable.emoji_1f17f);
        EMOJIS_MAP.put(9855, R.drawable.emoji_267f);
        EMOJIS_MAP.put(128685, R.drawable.emoji_1f6ad);
        EMOJIS_MAP.put(127490, R.drawable.emoji_1f202);
        EMOJIS_MAP.put(9410, R.drawable.emoji_24c2);
        EMOJIS_MAP.put(128706, R.drawable.emoji_1f6c2);
        EMOJIS_MAP.put(128708, R.drawable.emoji_1f6c4);
        EMOJIS_MAP.put(128709, R.drawable.emoji_1f6c5);
        EMOJIS_MAP.put(128707, R.drawable.emoji_1f6c3);
        EMOJIS_MAP.put(128697, R.drawable.emoji_1f6b9);
        EMOJIS_MAP.put(128698, R.drawable.emoji_1f6ba);
        EMOJIS_MAP.put(128700, R.drawable.emoji_1f6bc);
        EMOJIS_MAP.put(128699, R.drawable.emoji_1f6bb);
        EMOJIS_MAP.put(128686, R.drawable.emoji_1f6ae);
        SOFTBANKS_MAP.put(57893, R.drawable.emoji_0030);
        SOFTBANKS_MAP.put(57884, R.drawable.emoji_0031);
        SOFTBANKS_MAP.put(57885, R.drawable.emoji_0032);
        SOFTBANKS_MAP.put(57886, R.drawable.emoji_0033);
        SOFTBANKS_MAP.put(57887, R.drawable.emoji_0034);
        SOFTBANKS_MAP.put(57888, R.drawable.emoji_0035);
        SOFTBANKS_MAP.put(57889, R.drawable.emoji_0036);
        SOFTBANKS_MAP.put(57890, R.drawable.emoji_0037);
        SOFTBANKS_MAP.put(57891, R.drawable.emoji_0038);
        SOFTBANKS_MAP.put(57892, R.drawable.emoji_0039);
        EMOJIS_MAP.put(128287, R.drawable.emoji_1f51f);
        EMOJIS_MAP.put(128290, R.drawable.emoji_1f522);
        EMOJIS_MAP.put(128291, R.drawable.emoji_1f523);
        EMOJIS_MAP.put(11014, R.drawable.emoji_2b06);
        EMOJIS_MAP.put(11015, R.drawable.emoji_2b07);
        EMOJIS_MAP.put(11013, R.drawable.emoji_2b05);
        EMOJIS_MAP.put(10145, R.drawable.emoji_27a1);
        EMOJIS_MAP.put(128288, R.drawable.emoji_1f520);
        EMOJIS_MAP.put(128289, R.drawable.emoji_1f521);
        EMOJIS_MAP.put(128292, R.drawable.emoji_1f524);
        EMOJIS_MAP.put(8599, R.drawable.emoji_2197);
        EMOJIS_MAP.put(8598, R.drawable.emoji_2196);
        EMOJIS_MAP.put(8600, R.drawable.emoji_2198);
        EMOJIS_MAP.put(8601, R.drawable.emoji_2199);
        EMOJIS_MAP.put(8596, R.drawable.emoji_2194);
        EMOJIS_MAP.put(8597, R.drawable.emoji_2195);
        EMOJIS_MAP.put(128260, R.drawable.emoji_1f504);
        EMOJIS_MAP.put(9664, R.drawable.emoji_25c0);
        EMOJIS_MAP.put(9654, R.drawable.emoji_25b6);
        EMOJIS_MAP.put(128316, R.drawable.emoji_1f53c);
        EMOJIS_MAP.put(128317, R.drawable.emoji_1f53d);
        EMOJIS_MAP.put(8617, R.drawable.emoji_21a9);
        EMOJIS_MAP.put(8618, R.drawable.emoji_21aa);
        EMOJIS_MAP.put(8505, R.drawable.emoji_2139);
        EMOJIS_MAP.put(9194, R.drawable.emoji_23ea);
        EMOJIS_MAP.put(9193, R.drawable.emoji_23e9);
        EMOJIS_MAP.put(9197, R.drawable.emoji_23ed);
        EMOJIS_MAP.put(9199, R.drawable.emoji_23ef);
        EMOJIS_MAP.put(9198, R.drawable.emoji_23ee);
        EMOJIS_MAP.put(9208, R.drawable.emoji_23f8);
        EMOJIS_MAP.put(9209, R.drawable.emoji_23f9);
        EMOJIS_MAP.put(9210, R.drawable.emoji_23fa);
        EMOJIS_MAP.put(9195, R.drawable.emoji_23eb);
        EMOJIS_MAP.put(9196, R.drawable.emoji_23ec);
        EMOJIS_MAP.put(10549, R.drawable.emoji_2935);
        EMOJIS_MAP.put(10548, R.drawable.emoji_2934);
        EMOJIS_MAP.put(127383, R.drawable.emoji_1f197);
        EMOJIS_MAP.put(128256, R.drawable.emoji_1f500);
        EMOJIS_MAP.put(128257, R.drawable.emoji_1f501);
        EMOJIS_MAP.put(128258, R.drawable.emoji_1f502);
        EMOJIS_MAP.put(127381, R.drawable.emoji_1f195);
        EMOJIS_MAP.put(127385, R.drawable.emoji_1f199);
        EMOJIS_MAP.put(127378, R.drawable.emoji_1f192);
        EMOJIS_MAP.put(127379, R.drawable.emoji_1f193);
        EMOJIS_MAP.put(127382, R.drawable.emoji_1f196);
        EMOJIS_MAP.put(128246, R.drawable.emoji_1f4f6);
        EMOJIS_MAP.put(127910, R.drawable.emoji_1f3a6);
        EMOJIS_MAP.put(127489, R.drawable.emoji_1f201);
        EMOJIS_MAP.put(128178, R.drawable.emoji_1f4b2);
        EMOJIS_MAP.put(128177, R.drawable.emoji_1f4b1);
        EMOJIS_MAP.put(169, R.drawable.emoji_00a9);
        EMOJIS_MAP.put(174, R.drawable.emoji_00ae);
        EMOJIS_MAP.put(8482, R.drawable.emoji_2122);
        EMOJIS_MAP.put(128285, R.drawable.emoji_1f51d);
        EMOJIS_MAP.put(128282, R.drawable.emoji_1f51a);
        EMOJIS_MAP.put(128281, R.drawable.emoji_1f519);
        EMOJIS_MAP.put(128283, R.drawable.emoji_1f51b);
        EMOJIS_MAP.put(128284, R.drawable.emoji_1f51c);
        EMOJIS_MAP.put(128259, R.drawable.emoji_1f503);
        EMOJIS_MAP.put(10006, R.drawable.emoji_2716);
        EMOJIS_MAP.put(10133, R.drawable.emoji_2795);
        EMOJIS_MAP.put(10134, R.drawable.emoji_2796);
        EMOJIS_MAP.put(10135, R.drawable.emoji_2797);
        EMOJIS_MAP.put(10004, R.drawable.emoji_2714);
        EMOJIS_MAP.put(9745, R.drawable.emoji_2611);
        EMOJIS_MAP.put(128280, R.drawable.emoji_1f518);
        EMOJIS_MAP.put(10160, R.drawable.emoji_27b0);
        EMOJIS_MAP.put(12336, R.drawable.emoji_3030);
        EMOJIS_MAP.put(128174, R.drawable.emoji_1f4ae);
        EMOJIS_MAP.put(9723, R.drawable.emoji_25fb);
        EMOJIS_MAP.put(9726, R.drawable.emoji_25fe);
        EMOJIS_MAP.put(9725, R.drawable.emoji_25fd);
        EMOJIS_MAP.put(9642, R.drawable.emoji_25aa);
        EMOJIS_MAP.put(9643, R.drawable.emoji_25ab);
        EMOJIS_MAP.put(128314, R.drawable.emoji_1f53a);
        EMOJIS_MAP.put(128306, R.drawable.emoji_1f532);
        EMOJIS_MAP.put(128307, R.drawable.emoji_1f533);
        EMOJIS_MAP.put(9899, R.drawable.emoji_26ab);
        EMOJIS_MAP.put(9898, R.drawable.emoji_26aa);
        EMOJIS_MAP.put(128308, R.drawable.emoji_1f534);
        EMOJIS_MAP.put(128309, R.drawable.emoji_1f535);
        EMOJIS_MAP.put(128315, R.drawable.emoji_1f53b);
        EMOJIS_MAP.put(11036, R.drawable.emoji_2b1c);
        EMOJIS_MAP.put(11035, R.drawable.emoji_2b1b);
        EMOJIS_MAP.put(128310, R.drawable.emoji_1f536);
        EMOJIS_MAP.put(128311, R.drawable.emoji_1f537);
        EMOJIS_MAP.put(128312, R.drawable.emoji_1f538);
        EMOJIS_MAP.put(128313, R.drawable.emoji_1f539);
        EMOJIS_MAP.put(128266, R.drawable.emoji_1f50a);
        EMOJIS_MAP.put(128265, R.drawable.emoji_1f509);
        EMOJIS_MAP.put(128264, R.drawable.emoji_1f508);
        EMOJIS_MAP.put(128263, R.drawable.emoji_1f507);
        EMOJIS_MAP.put(128276, R.drawable.emoji_1f514);
        EMOJIS_MAP.put(128277, R.drawable.emoji_1f515);
        EMOJIS_MAP.put(128226, R.drawable.emoji_1f4e2);
        EMOJIS_MAP.put(128227, R.drawable.emoji_1f4e3);
        EMOJIS_MAP.put(127183, R.drawable.emoji_1f0cf);
        EMOJIS_MAP.put(126980, R.drawable.emoji_1f004);
        EMOJIS_MAP.put(9824, R.drawable.emoji_2660);
        EMOJIS_MAP.put(9829, R.drawable.emoji_2665);
        EMOJIS_MAP.put(9827, R.drawable.emoji_2663);
        EMOJIS_MAP.put(9830, R.drawable.emoji_2666);
        EMOJIS_MAP.put(127924, R.drawable.emoji_1f3b4);
        EMOJIS_MAP.put(128172, R.drawable.emoji_1f4ac);
        EMOJIS_MAP.put(128495, R.drawable.emoji_1f5ef);
        EMOJIS_MAP.put(128173, R.drawable.emoji_1f4ad);
        EMOJIS_MAP.put(128347, R.drawable.emoji_1f55b);
        EMOJIS_MAP.put(128359, R.drawable.emoji_1f567);
        EMOJIS_MAP.put(128336, R.drawable.emoji_1f550);
        EMOJIS_MAP.put(128348, R.drawable.emoji_1f55c);
        EMOJIS_MAP.put(128337, R.drawable.emoji_1f551);
        EMOJIS_MAP.put(128349, R.drawable.emoji_1f55d);
        EMOJIS_MAP.put(128338, R.drawable.emoji_1f552);
        EMOJIS_MAP.put(128350, R.drawable.emoji_1f55e);
        EMOJIS_MAP.put(128339, R.drawable.emoji_1f553);
        EMOJIS_MAP.put(128351, R.drawable.emoji_1f55f);
        EMOJIS_MAP.put(128340, R.drawable.emoji_1f554);
        EMOJIS_MAP.put(128352, R.drawable.emoji_1f560);
        EMOJIS_MAP.put(128341, R.drawable.emoji_1f555);
        EMOJIS_MAP.put(128342, R.drawable.emoji_1f556);
        EMOJIS_MAP.put(128343, R.drawable.emoji_1f557);
        EMOJIS_MAP.put(128344, R.drawable.emoji_1f558);
        EMOJIS_MAP.put(128345, R.drawable.emoji_1f559);
        EMOJIS_MAP.put(128346, R.drawable.emoji_1f55a);
        EMOJIS_MAP.put(128353, R.drawable.emoji_1f561);
        EMOJIS_MAP.put(128354, R.drawable.emoji_1f562);
        EMOJIS_MAP.put(128355, R.drawable.emoji_1f563);
        EMOJIS_MAP.put(128356, R.drawable.emoji_1f564);
        EMOJIS_MAP.put(128357, R.drawable.emoji_1f565);
        EMOJIS_MAP.put(128358, R.drawable.emoji_1f566);
    }
}

