/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.listeners.OnEmojiClickedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class EmojiArrayAdapter
extends ArrayAdapter<Emoji> {
    @Nullable
    private OnEmojiClickedListener onEmojiClickedListener;

    private static List<Emoji> toList(Emoji[] data) {
        ArrayList<Emoji> list = new ArrayList<Emoji>(data.length);
        Collections.addAll(list, data);
        return list;
    }

    EmojiArrayAdapter(Context context, Emoji[] data) {
        super(context, R.layout.emoji_text_view, EmojiArrayAdapter.toList(data));
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View view = convertView;
        if (view == null) {
            view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.emoji_text_view, parent, false);
            ViewHolder holder = new ViewHolder();
            holder.icon = (TextView)view.findViewById(R.id.emoji_icon);
            view.setTag((Object)holder);
        }
        Emoji emoji = (Emoji)this.getItem(position);
        ViewHolder holder = (ViewHolder)view.getTag();
        holder.emoji = emoji;
        holder.icon.setText((CharSequence)emoji.getEmoji());
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EmojiArrayAdapter.this.onEmojiClickedListener != null) {
                    ViewHolder tag = (ViewHolder)v.getTag();
                    EmojiArrayAdapter.this.onEmojiClickedListener.onEmojiClicked(tag.emoji);
                }
            }
        });
        return view;
    }

    public void updateEmojis(Collection<Emoji> emojis) {
        this.clear();
        this.addAll(emojis);
        this.notifyDataSetChanged();
    }

    public void setOnEmojiClickedListener(@Nullable OnEmojiClickedListener onEmojiClickedListener) {
        this.onEmojiClickedListener = onEmojiClickedListener;
    }

    static class ViewHolder {
        Emoji emoji;
        TextView icon;

        ViewHolder() {
        }
    }
}

