/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.recent;

import android.content.Context;
import android.content.SharedPreferences;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.recent.RecentEmoji;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0003\u0015\u0016\u0017B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/vanniktech/emoji/recent/RecentEmojiManager;", "Lcom/vanniktech/emoji/recent/RecentEmoji;", "context", "Landroid/content/Context;", "maxRecents", "", "<init>", "(Landroid/content/Context;I)V", "emojiList", "Lcom/vanniktech/emoji/recent/RecentEmojiManager$EmojiList;", "sharedPreferences", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "Landroid/content/SharedPreferences;", "getRecentEmojis", "", "Lcom/vanniktech/emoji/Emoji;", "addEmoji", "", "emoji", "persist", "EmojiList", "RecentEmojiData", "Companion", "emoji_release"})
@SourceDebugExtension(value={"SMAP\nRecentEmojiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentEmojiManager.kt\ncom/vanniktech/emoji/recent/RecentEmojiManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1611#2,9:120\n1863#2:129\n1864#2:133\n1620#2:134\n1062#2:135\n37#3,2:130\n1#4:132\n*S KotlinDebug\n*F\n+ 1 RecentEmojiManager.kt\ncom/vanniktech/emoji/recent/RecentEmojiManager\n*L\n38#1:120,9\n38#1:129\n38#1:133\n38#1:134\n52#1:135\n39#1:130,2\n38#1:132\n*E\n"})
public final class RecentEmojiManager
implements RecentEmoji {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxRecents;
    @NotNull
    private EmojiList emojiList;
    private final SharedPreferences sharedPreferences;
    @NotNull
    private static final String PREFERENCE_NAME = "emoji-recent-manager";
    @NotNull
    private static final String TIME_DELIMITER = ";";
    @NotNull
    private static final String EMOJI_DELIMITER = "~";
    @NotNull
    private static final String RECENT_EMOJIS = "recent-emojis";
    public static final int EMOJI_GUESS_SIZE = 5;

    @JvmOverloads
    public RecentEmojiManager(@NotNull Context context, int maxRecents) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.maxRecents = maxRecents;
        this.emojiList = new EmojiList(new ArrayList(), this.maxRecents);
        this.sharedPreferences = context.getApplicationContext().getSharedPreferences(PREFERENCE_NAME, 0);
    }

    public /* synthetic */ RecentEmojiManager(Context context, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 40;
        }
        this(context, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Emoji> getRecentEmojis() {
        if (this.emojiList.size() == 0) {
            String savedRecentEmojis;
            String string2 = this.sharedPreferences.getString(RECENT_EMOJIS, "");
            if (string2 == null) {
                string2 = "";
            }
            if (((CharSequence)(savedRecentEmojis = string2)).length() > 0) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Object object = new String[]{EMOJI_DELIMITER};
                List split = StringsKt.split$default((CharSequence)savedRecentEmojis, (String[])object, (boolean)false, (int)0, (int)6, null);
                object = split;
                RecentEmojiManager recentEmojiManager = this;
                boolean $i$f$mapNotNull = false;
                void var5_6 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    RecentEmojiData recentEmojiData;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    String[] stringArray = new String[]{TIME_DELIMITER};
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] parts = thisCollection$iv.toArray(new String[0]);
                    if (parts.length == 2) {
                        String candidate = parts[0];
                        Emoji emoji = EmojiManager.INSTANCE.findEmoji$emoji_release(candidate);
                        if (emoji != null) {
                            long timestamp = Long.parseLong(parts[1]);
                            recentEmojiData = new RecentEmojiData(emoji, timestamp);
                        } else {
                            recentEmojiData = null;
                        }
                    } else {
                        recentEmojiData = null;
                    }
                    if (recentEmojiData == null) continue;
                    RecentEmojiData it$iv$iv = recentEmojiData;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
                boolean $i$f$sortedByDescending = false;
                int n = this.maxRecents;
                List list = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        RecentEmojiData it = (RecentEmojiData)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTimestamp());
                        it = (RecentEmojiData)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
                    }
                }));
                recentEmojiManager.emojiList = new EmojiList(list, n);
            }
        }
        return this.emojiList.getEmojis();
    }

    @Override
    public void addEmoji(@NotNull Emoji emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        EmojiList.add$default(this.emojiList, emoji, 0L, 2, null);
    }

    @Override
    public void persist() {
        if (this.emojiList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder(this.emojiList.size() * 5);
            int n = this.emojiList.size();
            for (int i = 0; i < n; ++i) {
                RecentEmojiData data = this.emojiList.get(i);
                stringBuilder.append(data.getEmoji().getUnicode()).append(TIME_DELIMITER).append(data.getTimestamp()).append(EMOJI_DELIMITER);
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            this.sharedPreferences.edit().putString(RECENT_EMOJIS, stringBuilder.toString()).apply();
        }
    }

    @JvmOverloads
    public RecentEmojiManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, 0, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/vanniktech/emoji/recent/RecentEmojiManager$Companion;", "", "<init>", "()V", "PREFERENCE_NAME", "", "TIME_DELIMITER", "EMOJI_DELIMITER", "RECENT_EMOJIS", "EMOJI_GUESS_SIZE", "", "emoji_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010J\u0006\u0010\u0011\u001a\u00020\u0006J\u0011\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006H\u0086\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/vanniktech/emoji/recent/RecentEmojiManager$EmojiList;", "", "emojis", "", "Lcom/vanniktech/emoji/recent/RecentEmojiManager$RecentEmojiData;", "maxRecents", "", "<init>", "(Ljava/util/List;I)V", "add", "", "emoji", "Lcom/vanniktech/emoji/Emoji;", "timestamp", "", "getEmojis", "", "size", "get", "index", "emoji_release"})
    @SourceDebugExtension(value={"SMAP\nRecentEmojiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentEmojiManager.kt\ncom/vanniktech/emoji/recent/RecentEmojiManager$EmojiList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1062#2:120\n1557#2:121\n1628#2,3:122\n*S KotlinDebug\n*F\n+ 1 RecentEmojiManager.kt\ncom/vanniktech/emoji/recent/RecentEmojiManager$EmojiList\n*L\n102#1:120\n102#1:121\n102#1:122,3\n*E\n"})
    public static final class EmojiList {
        @NotNull
        private List<RecentEmojiData> emojis;
        private final int maxRecents;

        public EmojiList(@NotNull List<RecentEmojiData> emojis, int maxRecents) {
            Intrinsics.checkNotNullParameter(emojis, (String)"emojis");
            this.emojis = emojis;
            this.maxRecents = maxRecents;
        }

        public final void add(@NotNull Emoji emoji, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
            Iterator<RecentEmojiData> iterator = this.emojis.iterator();
            Emoji emojiBase = emoji.getBase();
            while (iterator.hasNext()) {
                RecentEmojiData data = iterator.next();
                if (!Intrinsics.areEqual((Object)data.getEmoji().getBase(), (Object)emojiBase)) continue;
                iterator.remove();
            }
            this.emojis.add(0, new RecentEmojiData(emoji, timestamp));
            if (this.emojis.size() > this.maxRecents) {
                this.emojis.remove(this.maxRecents);
            }
        }

        public static /* synthetic */ void add$default(EmojiList emojiList, Emoji emoji, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = System.currentTimeMillis();
            }
            emojiList.add(emoji, l);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Emoji> getEmojis() {
            void $this$mapTo$iv$iv;
            Iterable $this$sortedByDescending$iv = this.emojis;
            boolean $i$f$sortedByDescending = false;
            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    RecentEmojiData it = (RecentEmojiData)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getTimestamp());
                    it = (RecentEmojiData)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
                }
            });
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RecentEmojiData recentEmojiData = (RecentEmojiData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getEmoji());
            }
            return (List)destination$iv$iv;
        }

        public final int size() {
            return this.emojis.size();
        }

        @NotNull
        public final RecentEmojiData get(int index) {
            return this.emojis.get(index);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/vanniktech/emoji/recent/RecentEmojiManager$RecentEmojiData;", "", "emoji", "Lcom/vanniktech/emoji/Emoji;", "timestamp", "", "<init>", "(Lcom/vanniktech/emoji/Emoji;J)V", "getEmoji", "()Lcom/vanniktech/emoji/Emoji;", "getTimestamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "emoji_release"})
    public static final class RecentEmojiData {
        @NotNull
        private final Emoji emoji;
        private final long timestamp;

        public RecentEmojiData(@NotNull Emoji emoji, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
            this.emoji = emoji;
            this.timestamp = timestamp;
        }

        @NotNull
        public final Emoji getEmoji() {
            return this.emoji;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final Emoji component1() {
            return this.emoji;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final RecentEmojiData copy(@NotNull Emoji emoji, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
            return new RecentEmojiData(emoji, timestamp);
        }

        public static /* synthetic */ RecentEmojiData copy$default(RecentEmojiData recentEmojiData, Emoji emoji, long l, int n, Object object) {
            if ((n & 1) != 0) {
                emoji = recentEmojiData.emoji;
            }
            if ((n & 2) != 0) {
                l = recentEmojiData.timestamp;
            }
            return recentEmojiData.copy(emoji, l);
        }

        @NotNull
        public String toString() {
            return "RecentEmojiData(emoji=" + this.emoji + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result = this.emoji.hashCode();
            result = result * 31 + Long.hashCode(this.timestamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecentEmojiData)) {
                return false;
            }
            RecentEmojiData recentEmojiData = (RecentEmojiData)other;
            if (!Intrinsics.areEqual((Object)this.emoji, (Object)recentEmojiData.emoji)) {
                return false;
            }
            return this.timestamp == recentEmojiData.timestamp;
        }
    }
}

