/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.view.View;
import android.view.WindowInsets;
import android.view.autofill.AutofillManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.PopupWindow;
import androidx.annotation.StyleRes;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.ViewPager;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiTheming;
import com.vanniktech.emoji.EmojiView;
import com.vanniktech.emoji.internal.EmojiResultReceiver;
import com.vanniktech.emoji.internal.Utils;
import com.vanniktech.emoji.listeners.OnEmojiBackspaceClickListener;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.listeners.OnEmojiPopupDismissListener;
import com.vanniktech.emoji.listeners.OnEmojiPopupShownListener;
import com.vanniktech.emoji.listeners.OnSoftKeyboardCloseListener;
import com.vanniktech.emoji.listeners.OnSoftKeyboardOpenListener;
import com.vanniktech.emoji.recent.RecentEmoji;
import com.vanniktech.emoji.recent.RecentEmojiManager;
import com.vanniktech.emoji.search.SearchEmoji;
import com.vanniktech.emoji.search.SearchEmojiManager;
import com.vanniktech.emoji.variant.VariantEmoji;
import com.vanniktech.emoji.variant.VariantEmojiManager;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\u0018\u0000 L2\u00020\u0001:\u0003JKLB\u00a9\u0001\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0003\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\r\u00109\u001a\u00020:H\u0000\u00a2\u0006\u0002\b;J\r\u0010<\u001a\u00020:H\u0000\u00a2\u0006\u0002\b=J\u0015\u0010>\u001a\u00020:2\u0006\u0010?\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b@J\r\u0010A\u001a\u00020:H\u0000\u00a2\u0006\u0002\bBJ\u0006\u0010C\u001a\u00020:J\u0006\u0010D\u001a\u00020:J\b\u0010E\u001a\u00020:H\u0002J\u0006\u0010H\u001a\u00020:J\b\u0010I\u001a\u00020:H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010F\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006M"}, d2={"Lcom/vanniktech/emoji/EmojiPopup;", "", "rootView", "Landroid/view/View;", "editText", "Landroid/widget/EditText;", "theming", "Lcom/vanniktech/emoji/EmojiTheming;", "recentEmoji", "Lcom/vanniktech/emoji/recent/RecentEmoji;", "searchEmoji", "Lcom/vanniktech/emoji/search/SearchEmoji;", "variantEmoji", "Lcom/vanniktech/emoji/variant/VariantEmoji;", "pageTransformer", "Landroidx/viewpager/widget/ViewPager$PageTransformer;", "keyboardAnimationStyle", "", "popupWindowHeight", "onEmojiPopupShownListener", "Lcom/vanniktech/emoji/listeners/OnEmojiPopupShownListener;", "onSoftKeyboardCloseListener", "Lcom/vanniktech/emoji/listeners/OnSoftKeyboardCloseListener;", "onSoftKeyboardOpenListener", "Lcom/vanniktech/emoji/listeners/OnSoftKeyboardOpenListener;", "onEmojiBackspaceClickListener", "Lcom/vanniktech/emoji/listeners/OnEmojiBackspaceClickListener;", "onEmojiClickListener", "Lcom/vanniktech/emoji/listeners/OnEmojiClickListener;", "onEmojiPopupDismissListener", "Lcom/vanniktech/emoji/listeners/OnEmojiPopupDismissListener;", "<init>", "(Landroid/view/View;Landroid/widget/EditText;Lcom/vanniktech/emoji/EmojiTheming;Lcom/vanniktech/emoji/recent/RecentEmoji;Lcom/vanniktech/emoji/search/SearchEmoji;Lcom/vanniktech/emoji/variant/VariantEmoji;Landroidx/viewpager/widget/ViewPager$PageTransformer;IILcom/vanniktech/emoji/listeners/OnEmojiPopupShownListener;Lcom/vanniktech/emoji/listeners/OnSoftKeyboardCloseListener;Lcom/vanniktech/emoji/listeners/OnSoftKeyboardOpenListener;Lcom/vanniktech/emoji/listeners/OnEmojiBackspaceClickListener;Lcom/vanniktech/emoji/listeners/OnEmojiClickListener;Lcom/vanniktech/emoji/listeners/OnEmojiPopupDismissListener;)V", "getTheming$emoji_release", "()Lcom/vanniktech/emoji/EmojiTheming;", "getSearchEmoji$emoji_release", "()Lcom/vanniktech/emoji/search/SearchEmoji;", "getRootView$emoji_release", "()Landroid/view/View;", "context", "Landroid/app/Activity;", "getContext$emoji_release", "()Landroid/app/Activity;", "emojiView", "Lcom/vanniktech/emoji/EmojiView;", "popupWindow", "Landroid/widget/PopupWindow;", "isPendingOpen", "", "isKeyboardOpen", "globalKeyboardHeight", "delay", "originalImeOptions", "emojiResultReceiver", "Lcom/vanniktech/emoji/internal/EmojiResultReceiver;", "onDismissListener", "Landroid/widget/PopupWindow$OnDismissListener;", "start", "", "start$emoji_release", "stop", "stop$emoji_release", "updateKeyboardStateOpened", "keyboardHeight", "updateKeyboardStateOpened$emoji_release", "updateKeyboardStateClosed", "updateKeyboardStateClosed$emoji_release", "toggle", "show", "showAtBottomPending", "isShowing", "()Z", "dismiss", "showAtBottom", "EmojiPopUpOnAttachStateChangeListener", "EmojiPopUpOnApplyWindowInsetsListener", "Companion", "emoji_release"})
@SourceDebugExtension(value={"SMAP\nEmojiPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmojiPopup.kt\ncom/vanniktech/emoji/EmojiPopup\n+ 2 Utils.kt\ncom/vanniktech/emoji/internal/UtilsKt\n*L\n1#1,303:1\n128#2:304\n128#2:305\n*S KotlinDebug\n*F\n+ 1 EmojiPopup.kt\ncom/vanniktech/emoji/EmojiPopup\n*L\n192#1:304\n215#1:305\n*E\n"})
public final class EmojiPopup {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final EditText editText;
    @NotNull
    private final EmojiTheming theming;
    @NotNull
    private final SearchEmoji searchEmoji;
    private int popupWindowHeight;
    @Nullable
    private final OnEmojiPopupShownListener onEmojiPopupShownListener;
    @Nullable
    private final OnSoftKeyboardCloseListener onSoftKeyboardCloseListener;
    @Nullable
    private final OnSoftKeyboardOpenListener onSoftKeyboardOpenListener;
    @Nullable
    private final OnEmojiPopupDismissListener onEmojiPopupDismissListener;
    @NotNull
    private final View rootView;
    @NotNull
    private final Activity context;
    @NotNull
    private final EmojiView emojiView;
    @NotNull
    private final PopupWindow popupWindow;
    private boolean isPendingOpen;
    private boolean isKeyboardOpen;
    private int globalKeyboardHeight;
    private int delay;
    private int originalImeOptions;
    @NotNull
    private final EmojiResultReceiver emojiResultReceiver;
    @NotNull
    private final PopupWindow.OnDismissListener onDismissListener;
    private static final int MIN_KEYBOARD_HEIGHT = 50;
    private static final int APPLY_WINDOW_INSETS_DURATION = 250;

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji, @Nullable ViewPager.PageTransformer pageTransformer, @StyleRes int keyboardAnimationStyle, int popupWindowHeight, @Nullable OnEmojiPopupShownListener onEmojiPopupShownListener, @Nullable OnSoftKeyboardCloseListener onSoftKeyboardCloseListener, @Nullable OnSoftKeyboardOpenListener onSoftKeyboardOpenListener, @Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener, @Nullable OnEmojiClickListener onEmojiClickListener, @Nullable OnEmojiPopupDismissListener onEmojiPopupDismissListener) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        this.editText = editText;
        this.theming = theming;
        this.searchEmoji = searchEmoji;
        this.popupWindowHeight = popupWindowHeight;
        this.onEmojiPopupShownListener = onEmojiPopupShownListener;
        this.onSoftKeyboardCloseListener = onSoftKeyboardCloseListener;
        this.onSoftKeyboardOpenListener = onSoftKeyboardOpenListener;
        this.onEmojiPopupDismissListener = onEmojiPopupDismissListener;
        View view = rootView.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getRootView(...)");
        this.rootView = view;
        Context context = rootView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.context = Utils.INSTANCE.asActivity$emoji_release(context);
        this.emojiView = new EmojiView((Context)this.context, null, 2, null);
        this.popupWindow = new PopupWindow((Context)this.context);
        this.originalImeOptions = -1;
        this.emojiResultReceiver = new EmojiResultReceiver(new Handler(Looper.getMainLooper()));
        this.onDismissListener = () -> EmojiPopup.onDismissListener$lambda$0(this);
        EmojiManager.INSTANCE.verifyInstalled$emoji_release();
        this.emojiView.setUp(rootView, onEmojiClickListener, onEmojiBackspaceClickListener, this.editText, this.theming, recentEmoji, this.searchEmoji, variantEmoji, pageTransformer);
        this.popupWindow.setContentView((View)this.emojiView);
        this.popupWindow.setInputMethodMode(2);
        this.popupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable(this.context.getResources(), null));
        this.popupWindow.setOnDismissListener(this.onDismissListener);
        if (keyboardAnimationStyle != 0) {
            this.popupWindow.setAnimationStyle(keyboardAnimationStyle);
        }
        if (rootView.getParent() != null) {
            this.start$emoji_release();
        }
        rootView.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)new EmojiPopUpOnAttachStateChangeListener(this));
    }

    public /* synthetic */ EmojiPopup(View view, EditText editText, EmojiTheming emojiTheming, RecentEmoji recentEmoji, SearchEmoji searchEmoji, VariantEmoji variantEmoji, ViewPager.PageTransformer pageTransformer, int n, int n2, OnEmojiPopupShownListener onEmojiPopupShownListener, OnSoftKeyboardCloseListener onSoftKeyboardCloseListener, OnSoftKeyboardOpenListener onSoftKeyboardOpenListener, OnEmojiBackspaceClickListener onEmojiBackspaceClickListener, OnEmojiClickListener onEmojiClickListener, OnEmojiPopupDismissListener onEmojiPopupDismissListener, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            emojiTheming = EmojiTheming.Companion.from(context);
        }
        if ((n3 & 8) != 0) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            recentEmoji = new RecentEmojiManager(context, 0, 2, null);
        }
        if ((n3 & 0x10) != 0) {
            searchEmoji = new SearchEmojiManager();
        }
        if ((n3 & 0x20) != 0) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            variantEmoji = new VariantEmojiManager(context);
        }
        if ((n3 & 0x40) != 0) {
            pageTransformer = null;
        }
        if ((n3 & 0x80) != 0) {
            n = 0;
        }
        if ((n3 & 0x100) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x200) != 0) {
            onEmojiPopupShownListener = null;
        }
        if ((n3 & 0x400) != 0) {
            onSoftKeyboardCloseListener = null;
        }
        if ((n3 & 0x800) != 0) {
            onSoftKeyboardOpenListener = null;
        }
        if ((n3 & 0x1000) != 0) {
            onEmojiBackspaceClickListener = null;
        }
        if ((n3 & 0x2000) != 0) {
            onEmojiClickListener = null;
        }
        if ((n3 & 0x4000) != 0) {
            onEmojiPopupDismissListener = null;
        }
        this(view, editText, emojiTheming, recentEmoji, searchEmoji, variantEmoji, pageTransformer, n, n2, onEmojiPopupShownListener, onSoftKeyboardCloseListener, onSoftKeyboardOpenListener, onEmojiBackspaceClickListener, onEmojiClickListener, onEmojiPopupDismissListener);
    }

    @NotNull
    public final EmojiTheming getTheming$emoji_release() {
        return this.theming;
    }

    @NotNull
    public final SearchEmoji getSearchEmoji$emoji_release() {
        return this.searchEmoji;
    }

    @NotNull
    public final View getRootView$emoji_release() {
        return this.rootView;
    }

    @NotNull
    public final Activity getContext$emoji_release() {
        return this.context;
    }

    public final void start$emoji_release() {
        this.context.getWindow().getDecorView().setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener)new EmojiPopUpOnApplyWindowInsetsListener(this));
    }

    public final void stop$emoji_release() {
        this.dismiss();
        this.context.getWindow().getDecorView().setOnApplyWindowInsetsListener(null);
        this.popupWindow.setOnDismissListener(null);
    }

    public final void updateKeyboardStateOpened$emoji_release(int keyboardHeight) {
        int n;
        if (this.popupWindowHeight > 0 && this.popupWindow.getHeight() != this.popupWindowHeight) {
            this.popupWindow.setHeight(this.popupWindowHeight);
        } else if (this.popupWindowHeight == 0 && this.popupWindow.getHeight() != keyboardHeight) {
            this.popupWindow.setHeight(keyboardHeight);
        }
        if (this.globalKeyboardHeight != keyboardHeight) {
            this.globalKeyboardHeight = keyboardHeight;
            n = 250;
        } else {
            n = 0;
        }
        this.delay = n;
        int properWidth = Utils.INSTANCE.getProperWidth$emoji_release(this.context);
        if (this.popupWindow.getWidth() != properWidth) {
            this.popupWindow.setWidth(properWidth);
        }
        if (!this.isKeyboardOpen) {
            this.isKeyboardOpen = true;
            OnSoftKeyboardOpenListener onSoftKeyboardOpenListener = this.onSoftKeyboardOpenListener;
            if (onSoftKeyboardOpenListener != null) {
                onSoftKeyboardOpenListener.onKeyboardOpen(keyboardHeight);
            }
        }
        if (this.isPendingOpen) {
            this.showAtBottom();
        }
    }

    public final void updateKeyboardStateClosed$emoji_release() {
        this.isKeyboardOpen = false;
        OnSoftKeyboardCloseListener onSoftKeyboardCloseListener = this.onSoftKeyboardCloseListener;
        if (onSoftKeyboardCloseListener != null) {
            onSoftKeyboardCloseListener.onKeyboardClose();
        }
        if (this.isShowing()) {
            this.dismiss();
        }
    }

    public final void toggle() {
        if (!this.popupWindow.isShowing()) {
            this.start$emoji_release();
            ViewCompat.requestApplyInsets((View)this.context.getWindow().getDecorView());
            this.show();
        } else {
            this.dismiss();
        }
    }

    public final void show() {
        if (Utils.INSTANCE.shouldOverrideRegularCondition$emoji_release((Context)this.context, this.editText) && this.originalImeOptions == -1) {
            this.originalImeOptions = this.editText.getImeOptions();
        }
        this.editText.setFocusableInTouchMode(true);
        this.editText.requestFocus();
        this.showAtBottomPending();
    }

    private final void showAtBottomPending() {
        this.isPendingOpen = true;
        Context $this$inputMethodManager$iv = (Context)this.context;
        boolean $i$f$getInputMethodManager = false;
        Object object = $this$inputMethodManager$iv.getSystemService("input_method");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        InputMethodManager inputMethodManager = (InputMethodManager)object;
        if (Utils.INSTANCE.shouldOverrideRegularCondition$emoji_release((Context)this.context, this.editText)) {
            this.editText.setImeOptions(this.editText.getImeOptions() | 0x10000000);
            inputMethodManager.restartInput((View)this.editText);
        }
        this.emojiResultReceiver.setReceiver((arg_0, arg_1) -> EmojiPopup.showAtBottomPending$lambda$1(this, arg_0, arg_1));
        inputMethodManager.showSoftInput((View)this.editText, 0, (ResultReceiver)this.emojiResultReceiver);
    }

    public final boolean isShowing() {
        return this.popupWindow.isShowing();
    }

    public final void dismiss() {
        block2: {
            this.popupWindow.dismiss();
            this.emojiView.tearDown();
            this.emojiResultReceiver.setReceiver(null);
            if (this.originalImeOptions == -1) break block2;
            this.editText.setImeOptions(this.originalImeOptions);
            Context $this$inputMethodManager$iv = (Context)this.context;
            boolean $i$f$getInputMethodManager = false;
            Object object = $this$inputMethodManager$iv.getSystemService("input_method");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
            InputMethodManager inputMethodManager = (InputMethodManager)object;
            inputMethodManager.restartInput((View)this.editText);
            if (Build.VERSION.SDK_INT >= 26) {
                AutofillManager autofillManager;
                AutofillManager autofillManager2 = autofillManager = (AutofillManager)this.context.getSystemService(AutofillManager.class);
                if (autofillManager2 != null) {
                    autofillManager2.cancel();
                }
            }
        }
    }

    private final void showAtBottom() {
        block0: {
            this.isPendingOpen = false;
            this.editText.postDelayed(() -> EmojiPopup.showAtBottom$lambda$2(this), (long)this.delay);
            OnEmojiPopupShownListener onEmojiPopupShownListener = this.onEmojiPopupShownListener;
            if (onEmojiPopupShownListener == null) break block0;
            onEmojiPopupShownListener.onEmojiPopupShown();
        }
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji, @Nullable ViewPager.PageTransformer pageTransformer, @StyleRes int keyboardAnimationStyle, int popupWindowHeight, @Nullable OnEmojiPopupShownListener onEmojiPopupShownListener, @Nullable OnSoftKeyboardCloseListener onSoftKeyboardCloseListener, @Nullable OnSoftKeyboardOpenListener onSoftKeyboardOpenListener, @Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener, @Nullable OnEmojiClickListener onEmojiClickListener) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        this(rootView, editText, theming, recentEmoji, searchEmoji, variantEmoji, pageTransformer, keyboardAnimationStyle, popupWindowHeight, onEmojiPopupShownListener, onSoftKeyboardCloseListener, onSoftKeyboardOpenListener, onEmojiBackspaceClickListener, onEmojiClickListener, null, 16384, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji, @Nullable ViewPager.PageTransformer pageTransformer, @StyleRes int keyboardAnimationStyle, int popupWindowHeight, @Nullable OnEmojiPopupShownListener onEmojiPopupShownListener, @Nullable OnSoftKeyboardCloseListener onSoftKeyboardCloseListener, @Nullable OnSoftKeyboardOpenListener onSoftKeyboardOpenListener, @Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        this(rootView, editText, theming, recentEmoji, searchEmoji, variantEmoji, pageTransformer, keyboardAnimationStyle, popupWindowHeight, onEmojiPopupShownListener, onSoftKeyboardCloseListener, onSoftKeyboardOpenListener, onEmojiBackspaceClickListener, null, null, 24576, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji, @Nullable ViewPager.PageTransformer pageTransformer, @StyleRes int keyboardAnimationStyle, int popupWindowHeight, @Nullable OnEmojiPopupShownListener onEmojiPopupShownListener, @Nullable OnSoftKeyboardCloseListener onSoftKeyboardCloseListener, @Nullable OnSoftKeyboardOpenListener onSoftKeyboardOpenListener) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        this(rootView, editText, theming, recentEmoji, searchEmoji, variantEmoji, pageTransformer, keyboardAnimationStyle, popupWindowHeight, onEmojiPopupShownListener, onSoftKeyboardCloseListener, onSoftKeyboardOpenListener, null, null, null, 28672, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji, @Nullable ViewPager.PageTransformer pageTransformer, @StyleRes int keyboardAnimationStyle, int popupWindowHeight, @Nullable OnEmojiPopupShownListener onEmojiPopupShownListener, @Nullable OnSoftKeyboardCloseListener onSoftKeyboardCloseListener) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        this(rootView, editText, theming, recentEmoji, searchEmoji, variantEmoji, pageTransformer, keyboardAnimationStyle, popupWindowHeight, onEmojiPopupShownListener, onSoftKeyboardCloseListener, null, null, null, null, 30720, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji, @Nullable ViewPager.PageTransformer pageTransformer, @StyleRes int keyboardAnimationStyle, int popupWindowHeight, @Nullable OnEmojiPopupShownListener onEmojiPopupShownListener) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        this(rootView, editText, theming, recentEmoji, searchEmoji, variantEmoji, pageTransformer, keyboardAnimationStyle, popupWindowHeight, onEmojiPopupShownListener, null, null, null, null, null, 31744, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji, @Nullable ViewPager.PageTransformer pageTransformer, @StyleRes int keyboardAnimationStyle, int popupWindowHeight) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        this(rootView, editText, theming, recentEmoji, searchEmoji, variantEmoji, pageTransformer, keyboardAnimationStyle, popupWindowHeight, null, null, null, null, null, null, 32256, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji, @Nullable ViewPager.PageTransformer pageTransformer, @StyleRes int keyboardAnimationStyle) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        this(rootView, editText, theming, recentEmoji, searchEmoji, variantEmoji, pageTransformer, keyboardAnimationStyle, 0, null, null, null, null, null, null, 32512, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji, @Nullable ViewPager.PageTransformer pageTransformer) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        this(rootView, editText, theming, recentEmoji, searchEmoji, variantEmoji, pageTransformer, 0, 0, null, null, null, null, null, null, 32640, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji, @NotNull VariantEmoji variantEmoji) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        Intrinsics.checkNotNullParameter((Object)variantEmoji, (String)"variantEmoji");
        this(rootView, editText, theming, recentEmoji, searchEmoji, variantEmoji, null, 0, 0, null, null, null, null, null, null, 32704, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji, @NotNull SearchEmoji searchEmoji) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        Intrinsics.checkNotNullParameter((Object)searchEmoji, (String)"searchEmoji");
        this(rootView, editText, theming, recentEmoji, searchEmoji, null, null, 0, 0, null, null, null, null, null, null, 32736, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming, @NotNull RecentEmoji recentEmoji) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Intrinsics.checkNotNullParameter((Object)recentEmoji, (String)"recentEmoji");
        this(rootView, editText, theming, recentEmoji, null, null, null, 0, 0, null, null, null, null, null, null, 32752, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText, @NotNull EmojiTheming theming) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        this(rootView, editText, theming, null, null, null, null, 0, 0, null, null, null, null, null, null, 32760, null);
    }

    @JvmOverloads
    public EmojiPopup(@NotNull View rootView, @NotNull EditText editText) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        this(rootView, editText, null, null, null, null, null, 0, 0, null, null, null, null, null, null, 32764, null);
    }

    private static final void onDismissListener$lambda$0(EmojiPopup this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            OnEmojiPopupDismissListener onEmojiPopupDismissListener = this$0.onEmojiPopupDismissListener;
            if (onEmojiPopupDismissListener == null) break block0;
            onEmojiPopupDismissListener.onEmojiPopupDismiss();
        }
    }

    private static final void showAtBottomPending$lambda$1(EmojiPopup this$0, int resultCode, Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        switch (resultCode) {
            case 0: 
            case 1: {
                this$0.showAtBottom();
            }
        }
    }

    private static final void showAtBottom$lambda$2(EmojiPopup this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.popupWindow.showAtLocation(this$0.rootView, 0, 0, Utils.INSTANCE.getProperHeight$emoji_release(this$0.context) + this$0.popupWindowHeight);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/vanniktech/emoji/EmojiPopup$Companion;", "", "<init>", "()V", "MIN_KEYBOARD_HEIGHT", "", "APPLY_WINDOW_INSETS_DURATION", "emoji_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/vanniktech/emoji/EmojiPopup$EmojiPopUpOnApplyWindowInsetsListener;", "Landroid/view/View$OnApplyWindowInsetsListener;", "emojiPopup", "Lcom/vanniktech/emoji/EmojiPopup;", "<init>", "(Lcom/vanniktech/emoji/EmojiPopup;)V", "Ljava/lang/ref/WeakReference;", "previousOffset", "", "onApplyWindowInsets", "Landroid/view/WindowInsets;", "v", "Landroid/view/View;", "insets", "emoji_release"})
    public static final class EmojiPopUpOnApplyWindowInsetsListener
    implements View.OnApplyWindowInsetsListener {
        @NotNull
        private final WeakReference<EmojiPopup> emojiPopup;
        private int previousOffset;

        public EmojiPopUpOnApplyWindowInsetsListener(@NotNull EmojiPopup emojiPopup) {
            Intrinsics.checkNotNullParameter((Object)emojiPopup, (String)"emojiPopup");
            this.emojiPopup = new WeakReference<EmojiPopup>(emojiPopup);
        }

        @NotNull
        public WindowInsets onApplyWindowInsets(@NotNull View v, @NotNull WindowInsets insets) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
            EmojiPopup popup = (EmojiPopup)this.emojiPopup.get();
            if (popup != null) {
                int offset;
                int systemWindowInsetBottom = Build.VERSION.SDK_INT >= 30 ? insets.getInsets((int)WindowInsets.Type.ime()).bottom : insets.getSystemWindowInsetBottom();
                int stableInsetBottom = Build.VERSION.SDK_INT >= 30 ? insets.getInsetsIgnoringVisibility((int)WindowInsets.Type.systemBars()).bottom : insets.getStableInsetBottom();
                int n = offset = systemWindowInsetBottom < stableInsetBottom ? systemWindowInsetBottom : systemWindowInsetBottom - stableInsetBottom;
                if (offset != this.previousOffset || offset == 0) {
                    this.previousOffset = offset;
                    if (offset > Utils.INSTANCE.dpToPx$emoji_release((Context)popup.getContext$emoji_release(), 50.0f)) {
                        popup.updateKeyboardStateOpened$emoji_release(offset);
                    } else {
                        popup.updateKeyboardStateClosed$emoji_release();
                    }
                }
                WindowInsets windowInsets = popup.getContext$emoji_release().getWindow().getDecorView().onApplyWindowInsets(insets);
                Intrinsics.checkNotNullExpressionValue((Object)windowInsets, (String)"onApplyWindowInsets(...)");
                return windowInsets;
            }
            return insets;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/vanniktech/emoji/EmojiPopup$EmojiPopUpOnAttachStateChangeListener;", "Landroid/view/View$OnAttachStateChangeListener;", "emojiPopup", "Lcom/vanniktech/emoji/EmojiPopup;", "<init>", "(Lcom/vanniktech/emoji/EmojiPopup;)V", "Ljava/lang/ref/WeakReference;", "onViewAttachedToWindow", "", "v", "Landroid/view/View;", "onViewDetachedFromWindow", "emoji_release"})
    public static final class EmojiPopUpOnAttachStateChangeListener
    implements View.OnAttachStateChangeListener {
        @NotNull
        private final WeakReference<EmojiPopup> emojiPopup;

        public EmojiPopUpOnAttachStateChangeListener(@NotNull EmojiPopup emojiPopup) {
            Intrinsics.checkNotNullParameter((Object)emojiPopup, (String)"emojiPopup");
            this.emojiPopup = new WeakReference<EmojiPopup>(emojiPopup);
        }

        public void onViewAttachedToWindow(@NotNull View v) {
            block0: {
                EmojiPopup popup;
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                EmojiPopup emojiPopup = popup = (EmojiPopup)this.emojiPopup.get();
                if (emojiPopup == null) break block0;
                emojiPopup.start$emoji_release();
            }
        }

        public void onViewDetachedFromWindow(@NotNull View v) {
            EmojiPopup popup;
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            EmojiPopup emojiPopup = popup = (EmojiPopup)this.emojiPopup.get();
            if (emojiPopup != null) {
                emojiPopup.stop$emoji_release();
            }
            this.emojiPopup.clear();
            v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }
    }
}

