/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiProvider;
import com.vanniktech.emoji.EmojiRange;
import com.vanniktech.emoji.EmojiReplacer;
import com.vanniktech.emoji.internal.EmojiSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\"\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"replaceWithImages", "", "Lcom/vanniktech/emoji/EmojiManager;", "context", "Landroid/content/Context;", "text", "Landroid/text/Spannable;", "emojiSize", "", "defaultEmojiReplacer", "Lcom/vanniktech/emoji/EmojiReplacer;", "getDefaultEmojiReplacer", "()Lcom/vanniktech/emoji/EmojiReplacer;", "emoji_release"})
@JvmName(name="EmojiManagers")
public final class EmojiManagers {
    @NotNull
    private static final EmojiReplacer defaultEmojiReplacer = EmojiManagers::defaultEmojiReplacer$lambda$0;

    public static final void replaceWithImages(@NotNull EmojiManager $this$replaceWithImages, @NotNull Context context, @Nullable Spannable text, float emojiSize) {
        Spannable spannable;
        EmojiReplacer emojiReplacer;
        Intrinsics.checkNotNullParameter((Object)$this$replaceWithImages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        EmojiProvider emojiProvider = $this$replaceWithImages.emojiProvider$emoji_release();
        EmojiReplacer emojiReplacer2 = emojiProvider instanceof EmojiReplacer ? (EmojiReplacer)((Object)emojiProvider) : null;
        if (emojiReplacer2 == null) {
            emojiReplacer2 = emojiReplacer = defaultEmojiReplacer;
        }
        if ((spannable = text) == null) {
            spannable = (Spannable)new SpannableStringBuilder((CharSequence)"");
        }
        emojiReplacer.replaceWithImages(context, spannable, emojiSize, defaultEmojiReplacer);
    }

    @NotNull
    public static final EmojiReplacer getDefaultEmojiReplacer() {
        return defaultEmojiReplacer;
    }

    private static final void defaultEmojiReplacer$lambda$0(Context context, Spannable text, float emojiSize, EmojiReplacer emojiReplacer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        EmojiSpan[] existingSpans = (EmojiSpan[])text.getSpans(0, text.length(), EmojiSpan.class);
        List existingSpanPositions = new ArrayList(existingSpans.length);
        int size = existingSpans.length;
        for (int i = 0; i < size; ++i) {
            existingSpanPositions.add(text.getSpanStart((Object)existingSpans[i]));
        }
        List<EmojiRange> findAllEmojis = EmojiManager.INSTANCE.findAllEmojis$emoji_release((CharSequence)text);
        int n = ((Collection)findAllEmojis).size();
        for (int i = 0; i < n; ++i) {
            EmojiRange emojiRange = findAllEmojis.get(i);
            Emoji emoji = emojiRange.component1();
            IntRange range = emojiRange.component2();
            if (existingSpanPositions.contains(range.getFirst())) continue;
            text.setSpan((Object)new EmojiSpan(context, emoji, emojiSize), range.getFirst(), range.getLast(), 33);
        }
    }
}

