/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiCategory;
import com.vanniktech.emoji.EmojiProvider;
import com.vanniktech.emoji.EmojiRange;
import com.vanniktech.emoji.Lock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001bJ\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0000\u00a2\u0006\u0002\b!J\u0017\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020 H\u0000\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\fH\u0007J\b\u0010*\u001a\u00020&H\u0007J\b\u0010+\u001a\u00020&H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/vanniktech/emoji/EmojiManager;", "", "<init>", "()V", "GUESSED_UNICODE_AMOUNT", "", "GUESSED_TOTAL_PATTERN_LENGTH", "emojiMap", "", "", "Lcom/vanniktech/emoji/Emoji;", "emojiProvider", "Lcom/vanniktech/emoji/EmojiProvider;", "categories", "", "Lcom/vanniktech/emoji/EmojiCategory;", "[Lcom/vanniktech/emoji/EmojiCategory;", "emojiPattern", "Lkotlin/text/Regex;", "getEmojiPattern$emoji_release", "()Lkotlin/text/Regex;", "setEmojiPattern$emoji_release", "(Lkotlin/text/Regex;)V", "LOCK", "Lcom/vanniktech/emoji/Lock;", "categories$emoji_release", "()[Lcom/vanniktech/emoji/EmojiCategory;", "emojiProvider$emoji_release", "findAllEmojis", "", "Lcom/vanniktech/emoji/EmojiRange;", "text", "", "findAllEmojis$emoji_release", "findEmoji", "candidate", "findEmoji$emoji_release", "verifyInstalled", "", "verifyInstalled$emoji_release", "install", "provider", "destroy", "release", "emoji_release"})
@SourceDebugExtension(value={"SMAP\nEmojiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmojiManager.kt\ncom/vanniktech/emoji/EmojiManager\n+ 2 commonLockApi.kt\ncom/vanniktech/emoji/CommonLockApiKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n11#2,3:158\n15#2:162\n11#2,5:163\n11#2,5:168\n1#3:161\n*S KotlinDebug\n*F\n+ 1 EmojiManager.kt\ncom/vanniktech/emoji/EmojiManager\n*L\n87#1:158,3\n87#1:162\n133#1:163,5\n152#1:168,5\n*E\n"})
public final class EmojiManager {
    @NotNull
    public static final EmojiManager INSTANCE = new EmojiManager();
    private static final int GUESSED_UNICODE_AMOUNT = 3000;
    private static final int GUESSED_TOTAL_PATTERN_LENGTH = 12000;
    @NotNull
    private static final Map<String, Emoji> emojiMap = new LinkedHashMap(3000);
    @Nullable
    private static EmojiProvider emojiProvider;
    @Nullable
    private static EmojiCategory[] categories;
    @Nullable
    private static Regex emojiPattern;
    @NotNull
    private static final Lock LOCK;

    private EmojiManager() {
    }

    @Nullable
    public final Regex getEmojiPattern$emoji_release() {
        return emojiPattern;
    }

    public final void setEmojiPattern$emoji_release(@Nullable Regex regex) {
        emojiPattern = regex;
    }

    @NotNull
    public final EmojiCategory[] categories$emoji_release() {
        this.verifyInstalled$emoji_release();
        Intrinsics.checkNotNull((Object)categories);
        return categories;
    }

    @NotNull
    public final EmojiProvider emojiProvider$emoji_release() {
        this.verifyInstalled$emoji_release();
        EmojiProvider emojiProvider = EmojiManager.emojiProvider;
        Intrinsics.checkNotNull((Object)emojiProvider);
        return emojiProvider;
    }

    @NotNull
    public final List<EmojiRange> findAllEmojis$emoji_release(@Nullable CharSequence text) {
        this.verifyInstalled$emoji_release();
        CharSequence charSequence = text;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Sequence sequence;
            charSequence = emojiPattern;
            Sequence sequence2 = charSequence != null && (sequence = Regex.findAll$default((Regex)charSequence, (CharSequence)text, (int)0, (int)2, null)) != null ? SequencesKt.mapNotNull((Sequence)sequence, EmojiManager::findAllEmojis$lambda$0) : null;
            if (sequence2 == null) {
                sequence2 = SequencesKt.emptySequence();
            }
            return SequencesKt.toList(sequence2);
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public final Emoji findEmoji$emoji_release(@NotNull CharSequence candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        this.verifyInstalled$emoji_release();
        return emojiMap.get(((Object)candidate).toString());
    }

    public final void verifyInstalled$emoji_release() {
        EmojiCategory[] emojiCategoryArray = categories;
        if (categories == null) {
            boolean bl = false;
            String string = "Please install an EmojiProvider through the EmojiManager.install() method first.";
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void install(@NotNull EmojiProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Lock $this$use$iv = LOCK;
        boolean $i$f$use = false;
        try {
            $this$use$iv.lock();
            boolean bl = false;
            categories = provider.getCategories();
            emojiProvider = provider;
            emojiMap.clear();
            List unicodesForPattern = new ArrayList(3000);
            int categoriesSize = provider.getCategories().length;
            for (int i = 0; i < categoriesSize; ++i) {
                List<Emoji> emojis = provider.getCategories()[i].getEmojis();
                int emojisSize = emojis.size();
                for (int j = 0; j < emojisSize; ++j) {
                    Emoji emoji = emojis.get(j);
                    String unicode = emoji.getUnicode();
                    List<Emoji> variants = emoji.getVariants();
                    emojiMap.put(unicode, emoji);
                    unicodesForPattern.add(unicode);
                    int n = ((Collection)variants).size();
                    for (int k = 0; k < n; ++k) {
                        Emoji variant = variants.get(k);
                        String variantUnicode = variant.getUnicode();
                        emojiMap.put(variantUnicode, variant);
                        unicodesForPattern.add(variantUnicode);
                    }
                }
            }
            if (!(!((Collection)unicodesForPattern).isEmpty())) {
                boolean $i$a$-require-EmojiManager$install$1$22 = false;
                String $i$a$-require-EmojiManager$install$1$22 = "Your EmojiProvider must at least have one category with at least one emoji.";
                throw new IllegalArgumentException($i$a$-require-EmojiManager$install$1$22.toString());
            }
            CollectionsKt.sortWith((List)unicodesForPattern, (arg_0, arg_1) -> EmojiManager.install$lambda$5$lambda$4(EmojiManager::install$lambda$5$lambda$3, arg_0, arg_1));
            StringBuilder patternBuilder = new StringBuilder(12000);
            int unicodesForPatternSize = unicodesForPattern.size();
            for (int i = 0; i < unicodesForPatternSize; ++i) {
                patternBuilder.append(Regex.Companion.escape((String)unicodesForPattern.get(i))).append('|');
            }
            StringBuilder stringBuilder = patternBuilder.deleteCharAt(patternBuilder.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"deleteCharAt(...)");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String regex = string;
            emojiPattern = new Regex(regex, RegexOption.IGNORE_CASE);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$use$iv.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void destroy() {
        Lock $this$use$iv = LOCK;
        boolean $i$f$use = false;
        try {
            $this$use$iv.lock();
            boolean bl = false;
            EmojiManager.release();
            emojiMap.clear();
            emojiProvider = null;
            categories = null;
            emojiPattern = null;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$use$iv.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void release() {
        Lock $this$use$iv = LOCK;
        boolean $i$f$use = false;
        try {
            Unit unit;
            $this$use$iv.lock();
            boolean bl = false;
            EmojiProvider emojiProvider = EmojiManager.emojiProvider;
            if (emojiProvider != null) {
                emojiProvider.release();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            $this$use$iv.unlock();
        }
    }

    private static final EmojiRange findAllEmojis$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Emoji emoji = INSTANCE.findEmoji$emoji_release(it.getValue());
        return emoji != null ? new EmojiRange(emoji, new IntRange(it.getRange().getFirst(), it.getRange().getLast() + 1)) : null;
    }

    private static final int install$lambda$5$lambda$3(String first, String second) {
        return Intrinsics.compare((int)second.length(), (int)first.length());
    }

    private static final int install$lambda$5$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    static {
        LOCK = new Lock();
    }
}

