/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.ImageView;
import com.canhub.cropper.CropOverlayView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0001H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/canhub/cropper/CropImageAnimation;", "Landroid/view/animation/Animation;", "Landroid/view/animation/Animation$AnimationListener;", "imageView", "Landroid/widget/ImageView;", "cropOverlayView", "Lcom/canhub/cropper/CropOverlayView;", "<init>", "(Landroid/widget/ImageView;Lcom/canhub/cropper/CropOverlayView;)V", "startBoundPoints", "", "endBoundPoints", "startCropWindowRect", "Landroid/graphics/RectF;", "endCropWindowRect", "startImageMatrix", "endImageMatrix", "setStartState", "", "boundPoints", "imageMatrix", "Landroid/graphics/Matrix;", "setEndState", "applyTransformation", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "onAnimationStart", "animation", "onAnimationEnd", "onAnimationRepeat", "cropper_release"})
public final class CropImageAnimation
extends Animation
implements Animation.AnimationListener {
    @NotNull
    private final ImageView imageView;
    @NotNull
    private final CropOverlayView cropOverlayView;
    @NotNull
    private final float[] startBoundPoints;
    @NotNull
    private final float[] endBoundPoints;
    @NotNull
    private final RectF startCropWindowRect;
    @NotNull
    private final RectF endCropWindowRect;
    @NotNull
    private final float[] startImageMatrix;
    @NotNull
    private final float[] endImageMatrix;

    public CropImageAnimation(@NotNull ImageView imageView, @NotNull CropOverlayView cropOverlayView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)((Object)cropOverlayView), (String)"cropOverlayView");
        this.imageView = imageView;
        this.cropOverlayView = cropOverlayView;
        this.startBoundPoints = new float[8];
        this.endBoundPoints = new float[8];
        this.startCropWindowRect = new RectF();
        this.endCropWindowRect = new RectF();
        this.startImageMatrix = new float[9];
        this.endImageMatrix = new float[9];
        this.setDuration(300L);
        this.setFillAfter(true);
        this.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.setAnimationListener(this);
    }

    public final void setStartState(@NotNull float[] boundPoints, @NotNull Matrix imageMatrix) {
        Intrinsics.checkNotNullParameter((Object)boundPoints, (String)"boundPoints");
        Intrinsics.checkNotNullParameter((Object)imageMatrix, (String)"imageMatrix");
        this.reset();
        System.arraycopy(boundPoints, 0, this.startBoundPoints, 0, 8);
        this.startCropWindowRect.set(this.cropOverlayView.getCropWindowRect());
        imageMatrix.getValues(this.startImageMatrix);
    }

    public final void setEndState(@NotNull float[] boundPoints, @NotNull Matrix imageMatrix) {
        Intrinsics.checkNotNullParameter((Object)boundPoints, (String)"boundPoints");
        Intrinsics.checkNotNullParameter((Object)imageMatrix, (String)"imageMatrix");
        System.arraycopy(boundPoints, 0, this.endBoundPoints, 0, 8);
        this.endCropWindowRect.set(this.cropOverlayView.getCropWindowRect());
        imageMatrix.getValues(this.endImageMatrix);
    }

    protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
        ImageView imageView;
        CropOverlayView i2;
        RectF rectF;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        RectF $this$applyTransformation_u24lambda_u240 = rectF = new RectF();
        int n = 0;
        $this$applyTransformation_u24lambda_u240.left = this.startCropWindowRect.left + (this.endCropWindowRect.left - this.startCropWindowRect.left) * interpolatedTime;
        $this$applyTransformation_u24lambda_u240.top = this.startCropWindowRect.top + (this.endCropWindowRect.top - this.startCropWindowRect.top) * interpolatedTime;
        $this$applyTransformation_u24lambda_u240.right = this.startCropWindowRect.right + (this.endCropWindowRect.right - this.startCropWindowRect.right) * interpolatedTime;
        $this$applyTransformation_u24lambda_u240.bottom = this.startCropWindowRect.bottom + (this.endCropWindowRect.bottom - this.startCropWindowRect.bottom) * interpolatedTime;
        RectF animRect = rectF;
        float[] animPoints = new float[8];
        n = animPoints.length;
        for (int i2 = 0; i2 < n; ++i2) {
            animPoints[i2] = this.startBoundPoints[i2] + (this.endBoundPoints[i2] - this.startBoundPoints[i2]) * interpolatedTime;
        }
        CropOverlayView $this$applyTransformation_u24lambda_u241 = i2 = this.cropOverlayView;
        int n2 = 0;
        $this$applyTransformation_u24lambda_u241.setCropWindowRect(animRect);
        $this$applyTransformation_u24lambda_u241.setBounds(animPoints, this.imageView.getWidth(), this.imageView.getHeight());
        $this$applyTransformation_u24lambda_u241.invalidate();
        float[] animMatrix = new float[9];
        n2 = animMatrix.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            animMatrix[i3] = this.startImageMatrix[i3] + (this.endImageMatrix[i3] - this.startImageMatrix[i3]) * interpolatedTime;
        }
        ImageView $this$applyTransformation_u24lambda_u242 = imageView = this.imageView;
        boolean bl = false;
        $this$applyTransformation_u24lambda_u242.getImageMatrix().setValues(animMatrix);
        $this$applyTransformation_u24lambda_u242.invalidate();
    }

    public void onAnimationStart(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }

    public void onAnimationEnd(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this.imageView.clearAnimation();
    }

    public void onAnimationRepeat(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }
}

