/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;

final class FieldValidationUtil {
    private FieldValidationUtil() {
    }

    static void disableClientValidation(Component component) {
        FieldValidationUtil.overrideClientValidation(component);
        component.addAttachListener((ComponentEventListener & Serializable)e -> FieldValidationUtil.overrideClientValidation(component));
    }

    private static void overrideClientValidation(Component component) {
        PendingJavaScriptResult javaScriptResult = component.getElement().executeJs("$0.validate = function () {return this.checkValidity();}", new Serializable[]{component.getElement()});
        javaScriptResult.then((SerializableConsumer & Serializable)result -> {
            if (component instanceof HasValidation && ((HasValidation)component).isInvalid()) {
                component.getElement().executeJs("$0.invalid = true", new Serializable[]{component.getElement()});
            }
        });
    }
}

