/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.server;

import com.vaadin.navigator.PushStateNavigation;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.UICreateEvent;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.spring.annotation.SpringViewDisplay;
import com.vaadin.spring.internal.SpringViewDisplayPostProcessor;
import com.vaadin.spring.internal.SpringViewDisplayRegistrationBean;
import com.vaadin.spring.internal.UIID;
import com.vaadin.spring.navigator.SpringNavigator;
import com.vaadin.spring.server.SpringVaadinServletService;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.SingleComponentContainer;
import com.vaadin.ui.UI;
import com.vaadin.util.CurrentInstance;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public class SpringUIProvider
extends UIProvider {
    private static final long serialVersionUID = 6954428459733726004L;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final VaadinSession vaadinSession;
    private transient WebApplicationContext webApplicationContext = null;
    private final Map<String, Class<? extends UI>> pathToUIMap = new ConcurrentHashMap<String, Class<? extends UI>>();
    private final Map<String, Class<? extends UI>> wildcardPathToUIMap = new ConcurrentHashMap<String, Class<? extends UI>>();
    private transient ServletContext servletContext;

    public SpringUIProvider(VaadinSession vaadinSession) {
        this.vaadinSession = vaadinSession;
        if (this.getWebApplicationContext() == null) {
            throw new IllegalStateException("Spring WebApplicationContext not initialized for UI provider. Use e.g. ContextLoaderListener to initialize it.");
        }
        this.detectUIs();
        if (this.pathToUIMap.isEmpty() && this.wildcardPathToUIMap.isEmpty()) {
            this.logger.warn("Found no Vaadin UIs in the application context");
        }
    }

    protected void detectUIs() {
        String[] uiBeanNames;
        this.logger.debug("Checking the application context for Vaadin UIs");
        for (String uiBeanName : uiBeanNames = this.getWebApplicationContext().getBeanNamesForAnnotation(SpringUI.class)) {
            Class beanType = this.getWebApplicationContext().getType(uiBeanName);
            Assert.notNull((Object)beanType, (String)("BeanType for UI " + uiBeanName + " was null"));
            if (!UI.class.isAssignableFrom(beanType)) continue;
            this.logger.debug("Found Vaadin UI [{}]", (Object)beanType.getCanonicalName());
            String tempPath = this.deriveMappingForUI(uiBeanName);
            String path = tempPath.length() > 0 && !tempPath.startsWith("/") ? "/".concat(tempPath) : tempPath.replaceAll("/$", "");
            Class<? extends UI> existingBeanType = this.getUIByPath(path);
            if (existingBeanType != null) {
                throw new IllegalStateException(String.format("[%s] is already mapped to the path [%s]", existingBeanType.getCanonicalName(), path));
            }
            this.logger.debug("Mapping Vaadin UI [{}] to path [{}]", (Object)beanType.getCanonicalName(), (Object)path);
            this.mapPathToUI(path, beanType);
        }
    }

    protected String deriveMappingForUI(String uiBeanName) {
        SpringUI annotation = (SpringUI)this.getWebApplicationContext().findAnnotationOnBean(uiBeanName, SpringUI.class);
        Assert.notNull((Object)annotation, (String)("SpringUI annotation for bean " + uiBeanName + " could not be found!"));
        if (annotation == null) {
            return "";
        }
        return this.resolvePropertyPlaceholders(annotation.path());
    }

    public Class<? extends UI> getUIClass(UIClassSelectionEvent uiClassSelectionEvent) {
        String path = this.extractUIPathFromRequest(uiClassSelectionEvent.getRequest());
        Class ui = null;
        Object pathInfo = path;
        if (this.pathToUIMap.containsKey(path)) {
            ui = this.pathToUIMap.get(path);
        } else {
            Map.Entry entry = this.wildcardPathToUIMap.entrySet().stream().filter(e -> path.startsWith((String)e.getKey())).sorted(Comparator.comparing(e -> {
                String key = (String)((Map.Entry)e).getKey();
                return key.length();
            }).reversed()).findFirst().orElse(null);
            if (entry != null) {
                ui = (Class)entry.getValue();
                pathInfo = (String)entry.getKey();
            }
        }
        if (!((String)pathInfo).isEmpty() && !((String)pathInfo).startsWith("/")) {
            pathInfo = "/" + (String)pathInfo;
        }
        uiClassSelectionEvent.getRequest().setAttribute("com.vaadin.server.UI_ROOT_PATH", (Object)(uiClassSelectionEvent.getRequest().getContextPath() + (String)pathInfo));
        return ui;
    }

    private String extractUIPathFromRequest(VaadinRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.length() > 1) {
            String path = pathInfo;
            int indexOfBang = path.indexOf(33);
            if (indexOfBang > -1) {
                path = path.substring(0, indexOfBang);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path;
        }
        return "";
    }

    protected WebApplicationContext getWebApplicationContext() {
        if (this.webApplicationContext == null) {
            this.webApplicationContext = ((SpringVaadinServletService)this.vaadinSession.getService()).getWebApplicationContext();
        }
        return this.webApplicationContext;
    }

    protected void mapPathToUI(String path, Class<? extends UI> uiClass) {
        boolean isWildcardPath;
        boolean pathEndsWithWildcard = false;
        if (path.endsWith("/*")) {
            path = path.substring(0, path.length() - 2);
            pathEndsWithWildcard = true;
        } else if (path.endsWith("/**")) {
            path = path.substring(0, path.length() - 3);
            pathEndsWithWildcard = true;
        }
        boolean bl = isWildcardPath = pathEndsWithWildcard || uiClass.isAnnotationPresent(PushStateNavigation.class);
        if (isWildcardPath) {
            this.wildcardPathToUIMap.put(path, uiClass);
        } else {
            this.pathToUIMap.put(path, uiClass);
        }
    }

    protected Class<? extends UI> getUIByPath(String path) {
        return this.pathToUIMap.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UI createInstance(UICreateEvent event) {
        Class<UIID> key = UIID.class;
        UIID identifier = new UIID(event);
        CurrentInstance.set(key, (Object)identifier);
        try {
            this.logger.debug("Creating a new UI bean of class [{}] with identifier [{}]", (Object)event.getUIClass().getCanonicalName(), (Object)identifier);
            UI ui = (UI)this.getWebApplicationContext().getBean(event.getUIClass());
            this.configureNavigator(ui);
            UI uI = ui;
            return uI;
        }
        finally {
            CurrentInstance.set(key, null);
        }
    }

    protected void createThemeDirectory(String theme) {
        File path = null;
        try {
            String root;
            ServletContext servletContext = this.getServletContext();
            if (servletContext != null && (root = servletContext.getRealPath("/")) != null && new File(root).isDirectory()) {
                path = new File(servletContext.getRealPath("/VAADIN/themes/" + theme));
                this.logger.debug("Creating directory [{}]", (Object)path);
                path.mkdirs();
            }
        }
        catch (Exception e) {
            this.logger.info("Unable to create the directory [{}] for caching of themes compiled on the fly", path);
        }
    }

    protected ServletContext getServletContext() {
        if (this.servletContext == null) {
            try {
                this.servletContext = (ServletContext)this.getWebApplicationContext().getBean(ServletContext.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                this.logger.debug("Unable to access the servlet context", (Throwable)e);
                return null;
            }
        }
        return this.servletContext;
    }

    protected void configureNavigator(UI ui) {
        SpringNavigator navigator = this.getNavigator();
        if (navigator == null) {
            return;
        }
        Object springViewDisplay = this.findSpringViewDisplay(ui);
        if (springViewDisplay == null) {
            return;
        }
        if (springViewDisplay instanceof ViewDisplay) {
            navigator.init(ui, (ViewDisplay)springViewDisplay);
        } else if (springViewDisplay instanceof SingleComponentContainer) {
            navigator.init(ui, (SingleComponentContainer)springViewDisplay);
        } else if (springViewDisplay instanceof ComponentContainer) {
            navigator.init(ui, (ComponentContainer)springViewDisplay);
        } else {
            this.logger.error("View display does not implement ViewDisplay/SingleComponentContainer/ComponentContainer: " + springViewDisplay);
            throw new IllegalStateException("View display does not implement ViewDisplay/SingleComponentContainer/ComponentContainer: " + springViewDisplay);
        }
    }

    protected SpringNavigator getNavigator() {
        try {
            return (SpringNavigator)((Object)this.getWebApplicationContext().getBean(SpringNavigator.class));
        }
        catch (NoUniqueBeanDefinitionException e) {
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.info("No Vaadin navigator bean defined");
            return null;
        }
    }

    protected Object findSpringViewDisplay(UI ui) {
        try {
            SpringViewDisplayRegistrationBean springViewDisplayRegistration = (SpringViewDisplayRegistrationBean)this.getWebApplicationContext().getBean(SpringViewDisplayRegistrationBean.class);
            return springViewDisplayRegistration.getSpringViewDisplay((ApplicationContext)this.getWebApplicationContext());
        }
        catch (NoUniqueBeanDefinitionException e) {
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.debug("Looking for a SpringViewDisplay bean based on bean level annotations");
            Object[] springViewDisplayBeanNames = this.getWebApplicationContext().getBeanNamesForAnnotation(SpringViewDisplay.class);
            if (springViewDisplayBeanNames.length == 0) {
                this.logger.debug("No view display defined for the UI " + ui.getId());
                return null;
            }
            if (springViewDisplayBeanNames.length > 1) {
                this.logger.error("Multiple view displays defined for the UI " + ui.getId() + ": " + Arrays.toString(springViewDisplayBeanNames));
                throw new NoUniqueBeanDefinitionException(Object.class, Arrays.asList(springViewDisplayBeanNames));
            }
            return this.getWebApplicationContext().getBean(springViewDisplayBeanNames[0]);
        }
    }

    protected SpringViewDisplayPostProcessor getSpringViewDisplayPostProcessor() {
        try {
            return (SpringViewDisplayPostProcessor)this.getWebApplicationContext().getBean(SpringViewDisplayPostProcessor.class);
        }
        catch (NoUniqueBeanDefinitionException e) {
            this.logger.error("Multiple " + SpringViewDisplayPostProcessor.class.getName() + " beans exist");
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            this.logger.info(SpringViewDisplayPostProcessor.class.getName() + " is not active");
            return null;
        }
    }

    public String getTheme(UICreateEvent event) {
        String theme = super.getTheme(event);
        if (theme != null) {
            theme = this.resolvePropertyPlaceholders(theme);
            this.createThemeDirectory(theme);
        }
        return theme;
    }

    public String getPageTitle(UICreateEvent event) {
        String pageTitle = super.getPageTitle(event);
        if (pageTitle != null) {
            pageTitle = this.resolvePropertyPlaceholders(pageTitle);
        }
        return pageTitle;
    }

    private String resolvePropertyPlaceholders(String value) {
        if (StringUtils.hasText((String)value)) {
            return this.getWebApplicationContext().getEnvironment().resolvePlaceholders(value);
        }
        return value;
    }
}

