/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.internal;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.ServiceDestroyEvent;
import com.vaadin.server.ServiceDestroyListener;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.Registration;
import com.vaadin.spring.internal.BeanStore;
import com.vaadin.spring.internal.BeanStoreRetrievalStrategy;
import com.vaadin.spring.internal.SessionLockingBeanStore;
import com.vaadin.spring.internal.UIID;
import com.vaadin.ui.UI;
import com.vaadin.util.CurrentInstance;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.util.Assert;

public class UIScopeImpl
implements Scope,
BeanFactoryPostProcessor {
    public static final String VAADIN_UI_SCOPE_NAME = "vaadin-ui";
    private static final Logger LOGGER = LoggerFactory.getLogger(UIScopeImpl.class);
    private static BeanStoreRetrievalStrategy beanStoreRetrievalStrategy = new VaadinSessionBeanStoreRetrievalStrategy();

    public static synchronized void setBeanStoreRetrievalStrategy(BeanStoreRetrievalStrategy beanStoreRetrievalStrategy) {
        if (beanStoreRetrievalStrategy == null) {
            beanStoreRetrievalStrategy = new VaadinSessionBeanStoreRetrievalStrategy();
        }
        UIScopeImpl.beanStoreRetrievalStrategy = beanStoreRetrievalStrategy;
    }

    public static synchronized BeanStoreRetrievalStrategy getBeanStoreRetrievalStrategy() {
        return beanStoreRetrievalStrategy;
    }

    public Object get(String s, ObjectFactory<?> objectFactory) {
        return this.getBeanStore().get(s, objectFactory);
    }

    public Object remove(String s) {
        return this.getBeanStore().remove(s);
    }

    public void registerDestructionCallback(String s, Runnable runnable) {
        this.getBeanStore().registerDestructionCallback(s, runnable);
    }

    public Object resolveContextualObject(String s) {
        return null;
    }

    public String getConversationId() {
        return UIScopeImpl.getBeanStoreRetrievalStrategy().getConversationId();
    }

    private BeanStore getBeanStore() {
        return UIScopeImpl.getBeanStoreRetrievalStrategy().getBeanStore();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
        LOGGER.debug("Registering Vaadin UI scope with bean factory [{}]", (Object)configurableListableBeanFactory);
        configurableListableBeanFactory.registerScope(VAADIN_UI_SCOPE_NAME, (Scope)this);
    }

    public static void cleanupSession(VaadinSession session) {
        assert (session != null);
        UIStore uiStore = (UIStore)session.getAttribute(UIStore.class);
        if (uiStore != null) {
            LOGGER.debug("Vaadin session has been destroyed, destroying [{}]", (Object)uiStore);
            uiStore.destroy();
        }
    }

    public static class VaadinSessionBeanStoreRetrievalStrategy
    implements BeanStoreRetrievalStrategy {
        private VaadinSession getVaadinSession() {
            VaadinSession current = VaadinSession.getCurrent();
            if (current == null) {
                throw new IllegalStateException("No VaadinSession bound to current thread");
            }
            if (current.getState() != VaadinSession.State.OPEN) {
                throw new IllegalStateException("Current VaadinSession is not open");
            }
            return current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UIStore getUIStore() {
            VaadinSession session = this.getVaadinSession();
            session.lock();
            try {
                UIStore uiStore = (UIStore)session.getAttribute(UIStore.class);
                if (uiStore == null) {
                    uiStore = new UIStore(session);
                }
                UIStore uIStore = uiStore;
                return uIStore;
            }
            finally {
                session.unlock();
            }
        }

        private UIID getUIID() {
            UI currentUI = UI.getCurrent();
            if (currentUI != null && currentUI.getUIId() != -1) {
                return new UIID(currentUI);
            }
            UIID currentIdentifier = (UIID)CurrentInstance.get(UIID.class);
            Assert.notNull((Object)currentIdentifier, (String)String.format("Found no valid %s instance!", UIID.class.getName()));
            return currentIdentifier;
        }

        @Override
        public BeanStore getBeanStore() {
            return this.getUIStore().getBeanStore(this.getUIID());
        }

        @Override
        public String getConversationId() {
            return this.getVaadinSession().getSession().getId() + this.getUIID();
        }
    }

    static class UIStore
    implements ServiceDestroyListener,
    HttpSessionActivationListener {
        private static final long serialVersionUID = -2964924681534104416L;
        private static final Logger LOGGER = LoggerFactory.getLogger(UIStore.class);
        private final Map<UIID, BeanStore> beanStoreMap = new ConcurrentHashMap<UIID, BeanStore>();
        private final VaadinSession session;
        private final String sessionId;
        private transient Registration serviceDestroyRegistration;

        UIStore() {
            this.sessionId = null;
            this.session = null;
            this.serviceDestroyRegistration = null;
        }

        UIStore(VaadinSession session) {
            this.sessionId = session.getSession().getId();
            this.session = session;
            this.serviceDestroyRegistration = this.session.getService().addServiceDestroyListener((ServiceDestroyListener)this);
            this.session.setAttribute(UIStore.class, (Object)this);
        }

        BeanStore getBeanStore(final UIID uiid) {
            BeanStore beanStore;
            if (this.serviceDestroyRegistration == null) {
                this.serviceDestroyRegistration = this.session.getService().addServiceDestroyListener((ServiceDestroyListener)this);
            }
            if ((beanStore = this.beanStoreMap.get(uiid)) == null) {
                beanStore = new UIBeanStore(this.session, uiid, new BeanStore.DestructionCallback(){
                    private static final long serialVersionUID = 2829542503960939412L;

                    @Override
                    public void beanStoreDestroyed(BeanStore beanStore) {
                        this.removeBeanStore(uiid);
                    }
                });
                LOGGER.trace("Added [{}] to [{}]", (Object)beanStore, (Object)this);
                this.beanStoreMap.put(uiid, beanStore);
            }
            return beanStore;
        }

        void removeBeanStore(UIID uiid) {
            BeanStore removed = this.beanStoreMap.remove(uiid);
            if (removed != null) {
                LOGGER.trace("Removed [{}] from [{}]", (Object)removed, (Object)this);
            }
        }

        void destroy() {
            LOGGER.trace("Destroying [{}]", (Object)this);
            this.session.accessSynchronously(() -> {
                this.session.setAttribute(UIStore.class, null);
                this.serviceDestroyRegistration.remove();
            });
            for (BeanStore beanStore : new HashSet<BeanStore>(this.beanStoreMap.values())) {
                beanStore.destroy();
            }
            Assert.isTrue((boolean)this.beanStoreMap.isEmpty(), (String)"beanStore should have been emptied by the destruction callbacks");
        }

        public void serviceDestroy(ServiceDestroyEvent event) {
            LOGGER.debug("Vaadin service has been destroyed, destroying [{}]", (Object)this);
            this.destroy();
        }

        public String toString() {
            return String.format("%s[id=%x, sessionId=%s]", this.getClass().getSimpleName(), System.identityHashCode(this), this.sessionId);
        }

        public void sessionWillPassivate(HttpSessionEvent se) {
            this.serviceDestroyRegistration.remove();
            this.serviceDestroyRegistration = null;
        }

        public void sessionDidActivate(HttpSessionEvent se) {
        }
    }

    static class UIBeanStore
    extends SessionLockingBeanStore
    implements ClientConnector.DetachListener {
        private static final long serialVersionUID = 8775528615443492292L;

        UIBeanStore(VaadinSession session, UIID uuid, BeanStore.DestructionCallback destructionCallback) {
            super(session, uuid.toString(), destructionCallback);
        }

        @Override
        protected Object create(String s, ObjectFactory<?> objectFactory) {
            Object bean = super.create(s, objectFactory);
            if (bean instanceof UI) {
                ((UI)bean).addDetachListener((ClientConnector.DetachListener)this);
            }
            return bean;
        }

        public void detach(ClientConnector.DetachEvent event) {
            LOGGER.debug("UI [{}] has been detached, destroying [{}]", event.getSource(), (Object)this);
            this.destroy();
        }
    }
}

