/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.springnative;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.spring.VaadinConfigurationProperties;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class ClientCallableAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCallableAotProcessor.class);

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        HashSet usedTypes = new HashSet();
        Collection<String> packagesToScan = ClientCallableAotProcessor.getPackagesToScan(beanFactory);
        LOGGER.info("Scanning packages {} for @ClientCallable methods", packagesToScan);
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        this.configureScanner(scanner);
        for (String packageName : packagesToScan) {
            Set candidates = scanner.findCandidateComponents(packageName);
            LOGGER.debug("Found {} candidate components for package {}", (Object)candidates.size(), (Object)packageName);
            for (BeanDefinition bd : candidates) {
                if (bd.getBeanClassName() == null) continue;
                LOGGER.debug("Inspecting component class {} for @ClientCallable methods", (Object)bd.getBeanClassName());
                try {
                    Class clazz = ClassUtils.forName((String)bd.getBeanClassName(), (ClassLoader)beanFactory.getBeanClassLoader());
                    this.processClass(clazz, usedTypes);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn("Could not load class {}", (Object)bd.getBeanClassName(), (Object)e);
                }
            }
        }
        if (usedTypes.isEmpty()) {
            LOGGER.debug("No @ClientCallable types to register for reflection found");
            return null;
        }
        LOGGER.debug("Found @ClientCallable types to register for reflection: {}", usedTypes);
        return (generationContext, beanFactoryInitializationCode) -> {
            BindingReflectionHintsRegistrar registrar = new BindingReflectionHintsRegistrar();
            ReflectionHints reflectionHints = generationContext.getRuntimeHints().reflection();
            registrar.registerReflectionHints(reflectionHints, (Type[])usedTypes.toArray(new Class[0]));
        };
    }

    void configureScanner(ClassPathScanningCandidateComponentProvider scanner) {
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Component.class));
    }

    private static Collection<String> getPackagesToScan(ConfigurableListableBeanFactory beanFactory) {
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("com.vaadin");
        packages.addAll(AutoConfigurationPackages.get((BeanFactory)beanFactory));
        ConfigurableEnvironment environment = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        List<String> allowedPackages = VaadinConfigurationProperties.getAllowedPackages((Environment)environment);
        if (allowedPackages != null && !allowedPackages.isEmpty()) {
            packages.addAll(allowedPackages);
        }
        packages.sort(Comparator.comparingInt(String::length));
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String pkg : packages) {
            if (!result.isEmpty() && !result.stream().noneMatch(registeredPkg -> pkg.startsWith(registeredPkg + "."))) continue;
            result.add(pkg);
        }
        return result;
    }

    private void processClass(Class<?> clazz, Set<Class<?>> types) {
        if (!Component.class.isAssignableFrom(clazz)) {
            return;
        }
        while (Component.class != clazz) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(ClientCallable.class)) continue;
                this.processMethod(method, types);
            }
            clazz = clazz.getSuperclass();
        }
    }

    private void processMethod(Method method, Set<Class<?>> types) {
        Type[] paramTypes;
        LOGGER.info("Processing @ClientCallable method {}", (Object)method);
        Type returnType = method.getGenericReturnType();
        this.processType(returnType, types);
        for (Type paramType : paramTypes = method.getGenericParameterTypes()) {
            this.processType(paramType, types);
        }
    }

    private void processType(Type type, Set<Class<?>> types) {
        HashSet typesToRegister = new HashSet();
        this.resolveTypes(type, typesToRegister);
        for (Class clazz : typesToRegister) {
            if (this.shouldRegisterType(clazz)) {
                types.add(clazz);
                continue;
            }
            LOGGER.trace("Ignoring @ClientCallable return/parameter type {}", (Object)clazz);
        }
    }

    private void resolveTypes(Type type, Set<Class<?>> result) {
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            if (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            result.add(clazz);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            if (rawType instanceof Class) {
                result.add((Class)rawType);
            }
            for (Type typeArg : paramType.getActualTypeArguments()) {
                this.resolveTypes(typeArg, result);
            }
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type upperBound : wildcardType.getUpperBounds()) {
                this.resolveTypes(upperBound, result);
            }
            for (Type lowerBound : wildcardType.getLowerBounds()) {
                this.resolveTypes(lowerBound, result);
            }
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            for (Type bound : typeVar.getBounds()) {
                this.resolveTypes(bound, result);
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            this.resolveTypes(arrayType.getGenericComponentType(), result);
        }
    }

    private boolean shouldRegisterType(Class<?> type) {
        if (type.isPrimitive()) {
            return false;
        }
        if (type == Void.class || type == Void.TYPE) {
            return false;
        }
        String packageName = type.getPackageName();
        if (packageName.startsWith("java.") || packageName.startsWith("javax.") || packageName.startsWith("jakarta.") || packageName.startsWith("tools.jackson.")) {
            return false;
        }
        return !type.isArray();
    }
}

