/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServletRequest;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.util.FieldUtils;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;

public class VaadinRolePrefixHolder
implements Serializable {
    private String rolePrefix;
    private boolean rolePrefixSet;

    public VaadinRolePrefixHolder(String rolePrefix) {
        this.rolePrefix = rolePrefix;
        this.rolePrefixSet = this.rolePrefix != null;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public boolean isSet() {
        return this.rolePrefixSet;
    }

    public void resetRolePrefix(VaadinRequest request) {
        SecurityContextHolderAwareRequestWrapper requestWrapper = this.findSecurityContextHolderAwareRequestWrapper(request);
        this.resetRolePrefix(requestWrapper);
    }

    public void resetRolePrefix(DefaultSecurityFilterChain defaultSecurityFilterChain) {
        defaultSecurityFilterChain.getFilters().stream().filter(filter -> SecurityContextHolderAwareRequestFilter.class.isAssignableFrom(filter.getClass())).map(SecurityContextHolderAwareRequestFilter.class::cast).findFirst().ifPresent(this::resetRolePrefix);
    }

    void resetRolePrefix(SecurityContextHolderAwareRequestFilter securityContextHolderAwareRequestFilter) {
        this.resetRolePrefix(securityContextHolderAwareRequestFilter, SecurityContextHolderAwareRequestFilter.class);
    }

    void resetRolePrefix(SecurityContextHolderAwareRequestWrapper securityContextHolderAwareRequestWrapper) {
        this.resetRolePrefix(securityContextHolderAwareRequestWrapper, SecurityContextHolderAwareRequestWrapper.class);
    }

    void resetRolePrefix(Object source, Class<?> type) {
        if (source != null) {
            try {
                Field field = FieldUtils.getField(type, (String)"rolePrefix");
                field.setAccessible(true);
                this.rolePrefix = (String)field.get(source);
            }
            catch (IllegalAccessException e) {
                VaadinRolePrefixHolder.getLogger().warn(String.format("Could not read %s#rolePrefix field.", type.getSimpleName()), (Throwable)e);
            }
        }
        this.rolePrefixSet = true;
    }

    private SecurityContextHolderAwareRequestWrapper findSecurityContextHolderAwareRequestWrapper(VaadinRequest request) {
        if (request instanceof VaadinServletRequest) {
            ServletRequest servletRequest = ((VaadinServletRequest)request).getRequest();
            HashSet<ServletRequest> checkedWrappers = new HashSet<ServletRequest>();
            while (servletRequest instanceof ServletRequestWrapper && !checkedWrappers.contains(servletRequest)) {
                checkedWrappers.add(servletRequest);
                if (SecurityContextHolderAwareRequestWrapper.class.isAssignableFrom(servletRequest.getClass())) {
                    return (SecurityContextHolderAwareRequestWrapper)servletRequest;
                }
                servletRequest = ((ServletRequestWrapper)servletRequest).getRequest();
            }
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VaadinRolePrefixHolder.class);
    }
}

