/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.spring.RootMappedCondition;
import com.vaadin.flow.spring.SpringServlet;
import com.vaadin.flow.spring.VaadinApplicationConfiguration;
import com.vaadin.flow.spring.VaadinScopesConfig;
import com.vaadin.flow.spring.VaadinServletConfiguration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.stream.Stream;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public abstract class VaadinMVCWebAppInitializer
implements WebApplicationInitializer {
    public void onStartup(ServletContext servletContext) throws ServletException {
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        context.setServletContext(servletContext);
        this.registerConfiguration(context);
        servletContext.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)context));
        context.refresh();
        Environment env = (Environment)context.getBean(Environment.class);
        String mapping = RootMappedCondition.getUrlMapping(env);
        if (mapping == null) {
            mapping = "/*";
        }
        boolean rootMapping = RootMappedCondition.isRootMapping(mapping);
        ServletRegistration.Dynamic registration = servletContext.addServlet(ClassUtils.getShortNameAsProperty(SpringServlet.class), (Servlet)new SpringServlet((ApplicationContext)context, rootMapping));
        HashMap<String, Object> initParameters = new HashMap<String, Object>();
        if (rootMapping) {
            ServletRegistration.Dynamic dispatcherRegistration = servletContext.addServlet("dispatcher", (Servlet)new DispatcherServlet((WebApplicationContext)context));
            dispatcherRegistration.addMapping(new String[]{"/*"});
            mapping = "/vaadinServlet/*";
        }
        registration.addMapping(new String[]{mapping});
        Object pushUrl = rootMapping ? "" : mapping.replace("/*", "");
        pushUrl = (String)pushUrl + "/VAADIN/push";
        initParameters.put("org.atmosphere.container.JSR356AsyncSupport.mappingPath", pushUrl);
        registration.setInitParameters(initParameters);
        registration.setAsyncSupported(Boolean.TRUE.toString().equals(env.getProperty("vaadin.asyncSupported", Boolean.TRUE.toString())));
    }

    static String makeContextRelative(String url) {
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        return "context://" + url;
    }

    protected void registerConfiguration(AnnotationConfigWebApplicationContext context) {
        Stream<Class<?>> configs = Stream.concat(Stream.of(VaadinScopesConfig.class, VaadinServletConfiguration.class, VaadinApplicationConfiguration.class), this.getConfigurationClasses().stream());
        context.register((Class[])configs.toArray(Class[]::new));
    }

    protected abstract Collection<Class<?>> getConfigurationClasses();
}

