/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.spring.security.RequestUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Component;

@Component
public class VaadinDefaultRequestCache
implements RequestCache {
    @Autowired
    private RequestUtil requestUtil;
    @Value(value="${server.error.path:/error}")
    private String configuredErrorPath;
    private RequestCache delegateRequestCache = new HttpSessionRequestCache();

    public void saveRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.requestUtil.isFrameworkInternalRequest(request)) {
            return;
        }
        if (this.requestUtil.isEndpointRequest(request)) {
            return;
        }
        if (this.isServiceWorkerInitiated(request)) {
            return;
        }
        if (this.isErrorRequest(request)) {
            return;
        }
        LoggerFactory.getLogger(this.getClass()).debug("Saving request to " + request.getRequestURI());
        this.delegateRequestCache.saveRequest(request, response);
    }

    private boolean isErrorRequest(HttpServletRequest request) {
        String pathInContext = HandlerHelper.getRequestPathInsideContext((HttpServletRequest)request);
        String errorPath = this.configuredErrorPath;
        if (errorPath.startsWith("/")) {
            errorPath = errorPath.substring(1);
        }
        return errorPath.equals(pathInContext);
    }

    public SavedRequest getRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.delegateRequestCache.getRequest(request, response);
    }

    public HttpServletRequest getMatchingRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.delegateRequestCache.getMatchingRequest(request, response);
    }

    public void removeRequest(HttpServletRequest request, HttpServletResponse response) {
        this.delegateRequestCache.removeRequest(request, response);
    }

    private boolean isServiceWorkerInitiated(HttpServletRequest request) {
        String referer = request.getHeader("Referer");
        return referer != null && referer.endsWith("sw.js");
    }

    public void setDelegateRequestCache(RequestCache delegateRequestCache) {
        this.delegateRequestCache = delegateRequestCache;
    }
}

