/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.scopes;

import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;

class BeanStore
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BeanStore.class.getName());
    private final VaadinSession session;
    private final Map<String, Object> objects = new HashMap<String, Object>();
    private final Map<String, Runnable> destructionCallbacks = new HashMap<String, Runnable>();

    BeanStore(VaadinSession session) {
        assert (session.hasLock());
        this.session = session;
    }

    Object get(String name, ObjectFactory<?> objectFactory) {
        return this.execute(() -> this.doGet(name, objectFactory));
    }

    Object remove(String name) {
        return this.execute(() -> this.doRemove(name));
    }

    void registerDestructionCallback(String name, Runnable callback) {
        this.execute(() -> this.destructionCallbacks.put(name, callback));
    }

    void destroy() {
        this.execute(this::doDestroy);
    }

    VaadinSession getVaadinSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Void doDestroy() {
        assert (this.session.hasLock());
        try {
            for (Runnable destructionCallback : this.destructionCallbacks.values()) {
                try {
                    destructionCallback.run();
                }
                catch (Throwable throwable) {
                    LOGGER.error("BeanStore destruction callback failed", throwable);
                }
            }
        }
        finally {
            this.destructionCallbacks.clear();
            this.objects.clear();
        }
        return null;
    }

    Object doRemove(String name) {
        Runnable destructionCallback = this.destructionCallbacks.remove(name);
        try {
            if (destructionCallback != null) {
                destructionCallback.run();
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("BeanStore destruction callback failed", throwable);
        }
        return this.objects.remove(name);
    }

    Object doGet(String name, ObjectFactory<?> objectFactory) {
        Object bean = this.objects.get(name);
        if (bean == null) {
            bean = objectFactory.getObject();
            this.storeBean(name, bean);
        }
        return bean;
    }

    void storeBean(String name, Object bean) {
        this.objects.put(name, bean);
    }

    private <T> T execute(Supplier<T> supplier) {
        if (this.session.hasLock()) {
            return supplier.get();
        }
        this.session.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.session.unlock();
        }
    }
}

