/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.navigator;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.spring.access.ViewAccessControl;
import com.vaadin.spring.access.ViewInstanceAccessControl;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.spring.internal.Conventions;
import com.vaadin.spring.internal.ViewCache;
import com.vaadin.spring.internal.ViewScopeImpl;
import com.vaadin.spring.server.SpringVaadinServletService;
import com.vaadin.ui.UI;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;

public class SpringViewProvider
implements ViewProvider {
    private static final long serialVersionUID = 6906237177564157222L;
    private final Map<String, Set<String>> viewNameToBeanNamesMap = new ConcurrentHashMap<String, Set<String>>();
    private transient BeanDefinitionRegistry beanDefinitionRegistry;
    private transient ApplicationContext applicationContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringViewProvider.class);
    private Class<? extends View> accessDeniedViewClass;

    @Autowired
    public SpringViewProvider(ApplicationContext applicationContext, BeanDefinitionRegistry beanDefinitionRegistry) {
        this.applicationContext = applicationContext;
        this.beanDefinitionRegistry = beanDefinitionRegistry;
    }

    public Class<? extends View> getAccessDeniedViewClass() {
        return this.accessDeniedViewClass;
    }

    public void setAccessDeniedViewClass(Class<? extends View> accessDeniedViewClass) {
        this.accessDeniedViewClass = accessDeniedViewClass;
    }

    @PostConstruct
    void init() {
        String[] viewBeanNames;
        LOGGER.debug("Looking up SpringViews");
        int count = 0;
        for (String beanName : viewBeanNames = this.getWebApplicationContext().getBeanNamesForAnnotation(SpringView.class)) {
            Class type = this.getWebApplicationContext().getType(beanName);
            if (View.class.isAssignableFrom(type)) {
                SpringView annotation = (SpringView)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)type, SpringView.class);
                String viewName = this.getViewNameFromAnnotation(type, annotation);
                LOGGER.debug("Found SpringView bean [{}] with view name [{}]", (Object)beanName, (Object)viewName);
                if (this.getWebApplicationContext().isSingleton(beanName)) {
                    throw new IllegalStateException("SpringView bean [" + beanName + "] must not be a singleton");
                }
                Set<String> beanNames = this.getViewNameToBeanNamesMap().get(viewName);
                if (beanNames == null) {
                    beanNames = new ConcurrentSkipListSet<String>();
                    this.getViewNameToBeanNamesMap().put(viewName, beanNames);
                }
                beanNames.add(beanName);
                ++count;
                continue;
            }
            LOGGER.error("The view bean [{}] does not implement View", (Object)beanName);
            throw new IllegalStateException("SpringView bean [" + beanName + "] must implement View");
        }
        if (count == 0) {
            LOGGER.warn("No SpringViews found");
        } else if (count == 1) {
            LOGGER.debug("1 SpringView found");
        } else {
            LOGGER.debug("{} SpringViews found", (Object)count);
        }
    }

    protected String getViewNameFromAnnotation(Class<?> beanClass, SpringView annotation) {
        String viewName = Conventions.deriveMappingForView(beanClass, annotation);
        return this.getWebApplicationContext().getEnvironment().resolvePlaceholders(viewName);
    }

    protected List<ViewInfo> getAllViewsForCurrentUI() {
        ArrayList<ViewInfo> views = new ArrayList<ViewInfo>();
        for (String viewName : this.getViewNameToBeanNamesMap().keySet()) {
            for (String beanName : this.getViewNameToBeanNamesMap().get(viewName)) {
                ViewInfo viewInfo = new ViewInfo(viewName, beanName);
                if (!this.isViewValidForCurrentUI(viewInfo)) continue;
                views.add(viewInfo);
            }
        }
        return views;
    }

    protected List<ViewInfo> getAllowedViewsForCurrentUI() {
        ArrayList<ViewInfo> views = new ArrayList<ViewInfo>();
        for (ViewInfo view : this.getAllViewsForCurrentUI()) {
            if (!this.isAccessGranted(view)) continue;
            views.add(view);
        }
        return views;
    }

    protected List<ViewInfo> getAllowedViewsForCurrentUI(String viewName) {
        ArrayList<ViewInfo> views = new ArrayList<ViewInfo>();
        Set<String> allViews = this.getViewNameToBeanNamesMap().get(viewName);
        if (allViews != null) {
            for (String beanName : allViews) {
                ViewInfo viewInfo = new ViewInfo(viewName, beanName);
                if (!this.isViewValidForCurrentUI(viewInfo) || !this.isAccessGranted(viewInfo)) continue;
                views.add(viewInfo);
            }
        }
        return views;
    }

    public Collection<String> getViewNamesForCurrentUI() {
        HashSet<String> viewNames = new HashSet<String>();
        for (ViewInfo view : this.getAllowedViewsForCurrentUI()) {
            viewNames.add(view.getViewName());
        }
        return viewNames;
    }

    public String getViewName(String viewAndParameters) {
        LOGGER.trace("Extracting view name from [{}]", (Object)viewAndParameters);
        String viewName = this.getViewName(viewAndParameters, this.getAllowedViewsForCurrentUI());
        if (viewName != null) {
            return viewName;
        }
        LOGGER.trace("Found no view name in [{}]", (Object)viewAndParameters);
        if (this.getAccessDeniedViewClass() != null) {
            viewName = this.getViewName(viewAndParameters, this.getAllViewsForCurrentUI());
            return viewName;
        }
        return null;
    }

    protected String getViewName(String viewAndParameters, List<ViewInfo> views) {
        for (ViewInfo view : views) {
            if (!view.getViewName().equals(viewAndParameters)) continue;
            LOGGER.trace("[{}] is a valid view", (Object)view.getViewName());
            return view.getViewName();
        }
        int lastSlash = -1;
        String viewPart = viewAndParameters;
        while ((lastSlash = viewPart.lastIndexOf(47)) > -1) {
            viewPart = viewPart.substring(0, lastSlash);
            LOGGER.trace("Checking if [{}] is a valid view", (Object)viewPart);
            for (ViewInfo view : views) {
                if (!view.getViewName().equals(viewPart)) continue;
                LOGGER.trace("[{}] is a valid view", (Object)view.getViewName());
                return view.getViewName();
            }
        }
        return null;
    }

    protected boolean isViewValidForCurrentUI(ViewInfo viewInfo) {
        String beanName = viewInfo.getBeanName();
        try {
            Class type = this.getWebApplicationContext().getType(beanName);
            Assert.isAssignable(View.class, (Class)type, (String)"bean did not implement View interface");
            UI currentUI = UI.getCurrent();
            SpringView annotation = (SpringView)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)type, SpringView.class);
            Assert.notNull((Object)annotation, (String)"class did not have a SpringView annotation or an alias for it");
            if (annotation.ui().length == 0) {
                LOGGER.trace("View class [{}] with view name [{}] is available for all UI subclasses", (Object)type.getCanonicalName(), (Object)this.getViewNameFromAnnotation(type, annotation));
            } else {
                Class<? extends UI> validUI = this.getValidUIClass(currentUI, annotation.ui());
                if (validUI != null) {
                    LOGGER.trace("View class [%s] with view name [{}] is available for UI subclass [{}]", new Object[]{type.getCanonicalName(), this.getViewNameFromAnnotation(type, annotation), validUI.getCanonicalName()});
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    private Class<? extends UI> getValidUIClass(UI currentUI, Class<? extends UI>[] validUIClasses) {
        for (Class<? extends UI> validUI : validUIClasses) {
            if (!validUI.isAssignableFrom(currentUI.getClass())) continue;
            return validUI;
        }
        return null;
    }

    public View getView(String viewName) {
        List<ViewInfo> allowedViews = this.getAllowedViewsForCurrentUI(viewName);
        for (ViewInfo viewInfo : allowedViews) {
            View view = this.getViewFromApplicationContext(viewInfo);
            if (view == null) continue;
            return view;
        }
        LOGGER.warn("Found no view with name [{}]", (Object)viewName);
        return this.getAccessDeniedView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected View getViewFromApplicationContext(ViewInfo viewInfo) {
        View view = null;
        if (this.isAccessGranted(viewInfo)) {
            BeanDefinition beanDefinition = this.getBeanDefinitionRegistry().getBeanDefinition(viewInfo.getBeanName());
            if (beanDefinition.getScope().equals("vaadin-view")) {
                LOGGER.trace("View [{}] is view scoped, activating scope", (Object)viewInfo.getViewName());
                ViewCache viewCache = ViewScopeImpl.getViewCacheRetrievalStrategy().getViewCache((BeanFactory)this.getWebApplicationContext());
                viewCache.creatingView(viewInfo.getViewName());
                try {
                    view = this.getViewFromApplicationContextAndCheckAccess(viewInfo);
                }
                finally {
                    viewCache.viewCreated(viewInfo.getViewName(), view);
                }
            } else {
                view = this.getViewFromApplicationContextAndCheckAccess(viewInfo);
            }
        }
        return view;
    }

    protected BeanDefinitionRegistry getBeanDefinitionRegistry() {
        if (this.beanDefinitionRegistry == null) {
            AutowireCapableBeanFactory factory = this.getWebApplicationContext().getAutowireCapableBeanFactory();
            this.beanDefinitionRegistry = (BeanDefinitionRegistry)factory;
        }
        return this.beanDefinitionRegistry;
    }

    protected View getViewFromApplicationContextAndCheckAccess(ViewInfo viewInfo) {
        String beanName = viewInfo.getBeanName();
        View view = (View)this.getWebApplicationContext().getBean(beanName);
        if (this.isAccessGrantedToViewInstance(viewInfo, view)) {
            return view;
        }
        return null;
    }

    protected View getAccessDeniedView() {
        if (this.accessDeniedViewClass != null) {
            return (View)this.getWebApplicationContext().getBean(this.accessDeniedViewClass);
        }
        return null;
    }

    protected boolean isAccessGranted(ViewInfo view) {
        UI currentUI = UI.getCurrent();
        Map accessDelegates = this.getWebApplicationContext().getBeansOfType(ViewAccessControl.class);
        for (ViewAccessControl accessDelegate : accessDelegates.values()) {
            if (accessDelegate.isAccessGranted(currentUI, view.getBeanName())) continue;
            LOGGER.debug("Access delegate [{}] denied access to view with bean name [{}]", (Object)accessDelegate, (Object)view.getBeanName());
            return false;
        }
        return true;
    }

    protected boolean isAccessGrantedToViewInstance(ViewInfo viewInfo, View view) {
        UI currentUI = UI.getCurrent();
        Map accessDelegates = this.getWebApplicationContext().getBeansOfType(ViewInstanceAccessControl.class);
        for (ViewInstanceAccessControl accessDelegate : accessDelegates.values()) {
            if (accessDelegate.isAccessGranted(currentUI, viewInfo.getBeanName(), view)) continue;
            LOGGER.debug("Access delegate [{}] denied access to view [{}]", (Object)accessDelegate, (Object)view);
            return false;
        }
        return true;
    }

    protected ApplicationContext getWebApplicationContext() {
        if (this.applicationContext == null) {
            UI ui = UI.getCurrent();
            if (ui == null) {
                throw new IllegalStateException("Could not find application context and no current UI is available");
            }
            this.applicationContext = ((SpringVaadinServletService)ui.getSession().getService()).getWebApplicationContext();
        }
        return this.applicationContext;
    }

    protected Map<String, Set<String>> getViewNameToBeanNamesMap() {
        return this.viewNameToBeanNamesMap;
    }

    protected static class ViewInfo
    implements Serializable {
        private final String viewName;
        private final String beanName;

        public ViewInfo(String viewName, String beanName) {
            this.viewName = viewName;
            this.beanName = beanName;
        }

        public String getViewName() {
            return this.viewName;
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

