/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormulaFormatter
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormulaFormatter.class);

    public String unFormatFormulaValue(String formulaValue, Locale locale) {
        if (formulaValue != null && this.getCurrentDecimalSeparator(locale) == ',') {
            List<FormulaToken> tokens = this.tokenizeFormula(formulaValue, locale);
            List<FormulaToken> unLocalizedTokens = this.unLocalizeTokens(tokens, locale);
            return this.tokensToString(unLocalizedTokens);
        }
        return formulaValue;
    }

    public String reFormatFormulaValue(String formulaValue, Locale locale) {
        if (formulaValue != null && this.getCurrentDecimalSeparator(locale) == ',') {
            List<FormulaToken> tokens = this.tokenizeFormula(formulaValue, null);
            List<FormulaToken> localizedTokens = this.localizeTokens(tokens, locale);
            return this.tokensToString(localizedTokens);
        }
        return formulaValue;
    }

    public boolean isFormulaFormat(String value) {
        return value.startsWith("=") || value.startsWith("+");
    }

    public boolean isValidFormulaFormat(String value, Locale locale) {
        if (this.isFormulaFormat(value)) {
            String formulaValue = value.substring(1);
            List<FormulaToken> formulaTokens = this.tokenizeFormula(formulaValue, locale);
            for (int i = 0; i < formulaTokens.size(); ++i) {
                FormulaToken nextToken;
                FormulaToken token = formulaTokens.get(i);
                if (!(token instanceof NumberToken) || i + 1 >= formulaTokens.size() || !".".equals((nextToken = formulaTokens.get(i + 1)).toString())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<FormulaToken> localizeTokens(List<FormulaToken> tokens, Locale locale) {
        LinkedList<FormulaToken> localizedTokens = new LinkedList<FormulaToken>();
        for (FormulaToken token : tokens) {
            if (token instanceof NumberToken) {
                try {
                    localizedTokens.add(new NumberToken(this.getDecimalFormat(locale).format(Double.parseDouble(token.toString()))));
                }
                catch (NumberFormatException e) {
                    LOGGER.info("ERROR parsing token " + String.valueOf(token), (Throwable)e);
                    localizedTokens.add(token);
                }
                continue;
            }
            if (token instanceof SeparatorToken) {
                localizedTokens.add(new SeparatorToken(this.getParameterSeparator(locale)));
                continue;
            }
            localizedTokens.add(token);
        }
        return localizedTokens;
    }

    protected String tokensToString(List<FormulaToken> tokens) {
        StringBuilder tokenString = new StringBuilder();
        for (FormulaToken token : tokens) {
            tokenString.append(token.toString());
        }
        return tokenString.toString();
    }

    protected List<FormulaToken> unLocalizeTokens(List<FormulaToken> tokens, Locale locale) {
        LinkedList<FormulaToken> unlocalizedTokens = new LinkedList<FormulaToken>();
        DecimalFormat decimalFormat = this.getDecimalFormat(locale);
        for (FormulaToken token : tokens) {
            if (token instanceof NumberToken) {
                try {
                    unlocalizedTokens.add(new NumberToken(decimalFormat.parse(token.toString()).toString()));
                }
                catch (ParseException e) {
                    LOGGER.info("ERROR parsing token: " + String.valueOf(token), (Throwable)e);
                    unlocalizedTokens.add(token);
                }
                continue;
            }
            if (token instanceof SeparatorToken) {
                unlocalizedTokens.add(new SeparatorToken(this.getParameterSeparator(null)));
                continue;
            }
            unlocalizedTokens.add(token);
        }
        return unlocalizedTokens;
    }

    protected List<FormulaToken> tokenizeFormula(String formulaValue, Locale from) {
        boolean inString = false;
        StringBuilder numberBuilder = new StringBuilder();
        LinkedList<FormulaToken> tokens = new LinkedList<FormulaToken>();
        for (int i = 0; i < formulaValue.length() + 1; ++i) {
            Character current;
            Character c = current = i == formulaValue.length() ? null : Character.valueOf(formulaValue.charAt(i));
            if (!this.isNumberChar(current, from) && numberBuilder.length() > 0) {
                tokens.add(new NumberToken(numberBuilder.toString()));
                numberBuilder = new StringBuilder();
            }
            if (current == null) continue;
            if (!inString && this.isNumberChar(current, from)) {
                numberBuilder.append(current);
                continue;
            }
            if (current.charValue() == this.getParameterSeparator(from) && !inString) {
                tokens.add(new SeparatorToken(current.charValue()));
                continue;
            }
            if (current.charValue() == '\"') {
                tokens.add(new FormulaToken('\"'));
                if (!inString) {
                    inString = true;
                    continue;
                }
                inString = false;
                continue;
            }
            tokens.add(new FormulaToken(current.charValue()));
        }
        return tokens;
    }

    private char getParameterSeparator(Locale locale) {
        if (locale != null) {
            return ';';
        }
        return ',';
    }

    protected boolean isNumberChar(Character current, Locale locale) {
        return current != null && (Character.isDigit(current.charValue()) || this.getCurrentDecimalSeparator(locale) == current.charValue());
    }

    protected DecimalFormat getDecimalFormat(Locale locale) {
        DecimalFormat instance = (DecimalFormat)DecimalFormat.getInstance(locale);
        instance.setGroupingUsed(false);
        instance.setMaximumFractionDigits(16);
        return instance;
    }

    protected char getCurrentDecimalSeparator(Locale locale) {
        if (locale == null) {
            return '.';
        }
        DecimalFormat format = this.getDecimalFormat(locale);
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        return symbols.getDecimalSeparator();
    }

    private class FormulaToken
    implements Serializable {
        private final String content;

        public FormulaToken(char charContent) {
            this(Character.toString(charContent));
        }

        public FormulaToken(String content) {
            if (content == null) {
                throw new IllegalArgumentException();
            }
            this.content = content;
        }

        public String toString() {
            return this.content;
        }
    }

    protected class NumberToken
    extends FormulaToken {
        public NumberToken(String content) {
            super(content);
        }
    }

    protected class SeparatorToken
    extends FormulaToken {
        public SeparatorToken(char content) {
            super(content);
        }
    }
}

