/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.ColorConverter;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderFormatting;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;

public class HSSFColorConverter
implements ColorConverter {
    private final HSSFWorkbook wb;
    private final HSSFPalette colors;
    private String defaultBackgroundColor;
    private String defaultColor;
    private static final HSSFColor.HSSFColorPredefined HSSF_AUTO = HSSFColor.HSSFColorPredefined.AUTOMATIC;

    public HSSFColorConverter(HSSFWorkbook wb) {
        this.wb = wb;
        this.colors = wb.getCustomPalette();
    }

    @Override
    public String getBorderColorCSS(XSSFCellBorder.BorderSide borderSide, String attr, CellStyle cellStyle) {
        StringBuilder sb = new StringBuilder();
        HSSFCellStyle cs = (HSSFCellStyle)cellStyle;
        switch (borderSide) {
            case BOTTOM: {
                this.styleBorderColor(sb, attr, cs.getBottomBorderColor());
                break;
            }
            case LEFT: {
                this.styleBorderColor(sb, attr, cs.getLeftBorderColor());
                break;
            }
            case RIGHT: {
                this.styleBorderColor(sb, attr, cs.getRightBorderColor());
                break;
            }
            case TOP: {
                this.styleBorderColor(sb, attr, cs.getTopBorderColor());
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public void colorStyles(CellStyle cellStyle, StringBuilder sb) {
        String color;
        HSSFCellStyle cs = (HSSFCellStyle)cellStyle;
        short fillForegroundColor = cs.getFillForegroundColor();
        short fillBackgroundColor = cs.getFillBackgroundColor();
        String backgroundColor = null;
        HSSFColor fillForegroundColorColor = cs.getFillForegroundColorColor();
        if (fillForegroundColorColor != null && fillForegroundColor != HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex()) {
            backgroundColor = this.styleColor(fillForegroundColor);
        } else {
            HSSFColor fillBackgroundColorColor = cs.getFillBackgroundColorColor();
            if (fillBackgroundColorColor != null && fillBackgroundColor != HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex()) {
                backgroundColor = this.styleColor(fillBackgroundColor);
            }
        }
        if (backgroundColor != null && !backgroundColor.equals(this.defaultBackgroundColor)) {
            sb.append("background-color:");
            sb.append(backgroundColor);
        }
        if ((color = this.styleColor(cs.getFont((Workbook)this.wb).getColor())) != null && !color.equals(this.defaultColor)) {
            sb.append("color:");
            sb.append(color);
        }
    }

    @Override
    public void defaultColorStyles(CellStyle cellStyle, StringBuilder sb) {
        HSSFCellStyle cs = (HSSFCellStyle)cellStyle;
        this.defaultBackgroundColor = this.styleColor(cs.getFillBackgroundColor());
        if (this.defaultBackgroundColor == null) {
            this.defaultBackgroundColor = "#ffffff;";
        }
        sb.append("background-color:");
        sb.append(this.defaultBackgroundColor);
        this.defaultColor = this.styleColor(cs.getFont((Workbook)this.wb).getColor());
        if (this.defaultColor == null) {
            this.defaultColor = "#000000;";
        }
        sb.append("color:");
        sb.append(this.defaultColor);
    }

    @Override
    public boolean hasBackgroundColor(CellStyle cellStyle) {
        HSSFCellStyle cs = (HSSFCellStyle)cellStyle;
        short fillForegroundColor = cs.getFillForegroundColor();
        short fillBackgroundColor = cs.getFillBackgroundColor();
        HSSFColor fillForegroundColorColor = cs.getFillForegroundColorColor();
        if (fillForegroundColorColor != null && fillForegroundColor != HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex()) {
            return true;
        }
        HSSFColor fillBackgroundColorColor = cs.getFillBackgroundColorColor();
        return fillBackgroundColorColor != null && fillBackgroundColor != HSSFColor.HSSFColorPredefined.AUTOMATIC.getIndex();
    }

    @Override
    public String getBackgroundColorCSS(ConditionalFormattingRule rule) {
        short index = rule.getFontFormatting().getFontColorIndex();
        String styleColor = this.styleColor(index);
        return styleColor;
    }

    @Override
    public String getFontColorCSS(ConditionalFormattingRule rule) {
        short color = rule.getPatternFormatting().getFillForegroundColor();
        String styleColor = this.styleColor(color);
        return styleColor;
    }

    @Override
    public String getBorderColorCSS(XSSFCellBorder.BorderSide right, String attribute, BorderFormatting borderFormatting) {
        return "";
    }

    private String styleColor(short index) {
        HSSFColor color = this.colors.getColor(index);
        if (index != HSSF_AUTO.getIndex() && color != null) {
            short[] rgb = color.getTriplet();
            return String.format("#%02x%02x%02x;", rgb[0], rgb[1], rgb[2]);
        }
        return null;
    }

    private void styleBorderColor(StringBuilder sb, String attr, short index) {
        HSSFColor color = this.colors.getColor(index);
        sb.append(attr);
        sb.append(":");
        if (index != HSSF_AUTO.getIndex() && color != null) {
            short[] rgb = color.getTriplet();
            sb.append(String.format("#%02x%02x%02x;", rgb[0], rgb[1], rgb[2]));
        } else {
            sb.append("#000;");
        }
    }

    private void styleColor(StringBuilder sb, String attr, short index) {
        HSSFColor color = this.colors.getColor(index);
        if (index != HSSF_AUTO.getIndex() && color != null) {
            short[] rgb = color.getTriplet();
            sb.append(attr);
            sb.append(":");
            sb.append(String.format("#%02x%02x%02x;", rgb[0], rgb[1], rgb[2]));
        }
    }
}

