/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.confwriter;

import com.vaadin.flow.component.charts.model.AbstractPlotOptions;
import com.vaadin.flow.component.charts.model.AxisType;
import com.vaadin.flow.component.charts.model.ChartModel;
import com.vaadin.flow.component.charts.model.Configuration;
import com.vaadin.flow.component.charts.model.Frame;
import com.vaadin.flow.component.charts.model.HorizontalAlign;
import com.vaadin.flow.component.charts.model.LayoutDirection;
import com.vaadin.flow.component.charts.model.Legend;
import com.vaadin.flow.component.charts.model.Options3d;
import com.vaadin.flow.component.charts.model.PlotOptionsSeries;
import com.vaadin.flow.component.charts.model.Series;
import com.vaadin.flow.component.charts.model.Title;
import com.vaadin.flow.component.charts.model.VerticalAlign;
import com.vaadin.flow.component.charts.model.XAxis;
import com.vaadin.flow.component.charts.model.YAxis;
import com.vaadin.flow.component.charts.model.style.Color;
import com.vaadin.flow.component.charts.model.style.FontWeight;
import com.vaadin.flow.component.charts.model.style.GradientColor;
import com.vaadin.flow.component.charts.model.style.SolidColor;
import com.vaadin.flow.component.charts.model.style.Style;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.AbstractSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.ChartData;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.AbstractSeriesDataWriter;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.PieToDonutConverter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChartDataToVaadinConfigWriter {
    private static final int DEFAULT_LEGEND_Y_OFFSET = 30;
    private Logger logger = Logger.getLogger(ChartDataToVaadinConfigWriter.class.getSimpleName());

    public ChartDataToVaadinConfigWriter() {
        this.logger.setLevel(Level.OFF);
    }

    public Configuration createConfigurationFromChartData(ChartData definition) {
        this.logger.info("createConfData()");
        if (definition.plotData.size() > 0) {
            this.logger.info("*** NEXT CHART *** title: " + definition.title + " , series type: " + definition.plotData.get(0).getClass().getSimpleName());
        }
        Configuration conf = new Configuration();
        if (definition.view3dData != null) {
            this.logger.info("view3dData: " + definition.view3dData.rotation3dAngleA + "/" + definition.view3dData.rotation3dAngleB);
            conf.getChart().setOptions3d(this.getOptions3d(definition.view3dData));
        } else {
            this.logger.info("definition.view3dData is null");
        }
        this.convertPlotData(definition, conf);
        this.setDefaults(conf);
        PieToDonutConverter.convertIfNeeded(definition, conf);
        conf.setTitle(this.createTitle(definition.title, definition.titleStyle));
        this.updateLegendPosition(conf.getLegend(), definition);
        this.updateLegendTextProperties(conf.getLegend(), definition.legendProperties.textProperties);
        this.updateBorder(conf.getChart(), definition.borderStyle);
        this.updateBackgroundColor(conf, definition.background);
        this.updateXAxis(conf.getxAxis(), definition.xAxisProperties);
        this.updateYAxes(conf, definition.yAxesProperties);
        if (conf.getSeries().isEmpty()) {
            conf.setSubTitle("*** Unsupported chart type ***");
        }
        this.updateTooltip(definition, conf);
        return conf;
    }

    private void updateTooltip(ChartData definition, Configuration conf) {
        StringBuilder formatter = new StringBuilder();
        formatter.append("function(){");
        formatter.append("var text='';");
        Iterator<AbstractSeriesData> seriesIt = definition.plotData.iterator();
        int i = 0;
        while (seriesIt.hasNext()) {
            AbstractSeriesData series = seriesIt.next();
            String seriesTitle = "'Series'";
            String pointTitle = "'Point'";
            String pointData = series.is3d ? "z" : "y";
            String seriesName = series.name == null ? Integer.toString(i + 1) : "this.series.name";
            String seriesFormatter = "if(this.series.options.id == '$id'){\n   var formattedNumber;\n   var signlessNumer = Math.abs(this.$v);   if ($tooltipDecimals < 0 ) {\n      //Round numbers to contain only 9 digits if they contain decimals.\n      var tooltipDecimals = (signlessNumer>1.0 ? 9-Math.floor(Math.log(signlessNumer)/Math.LN10) : 9);\n      formattedNumber = (Math.round(this.$v) == this.$v ? this.$v : Math.round(this.$v * Math.pow(10,tooltipDecimals))/Math.pow(10,tooltipDecimals));\n   } else {\n      //numberFormat can handle numbers 20 digits long.\n      var tooltipDecimals = (Math.ceil(Math.log(signlessNumer)/Math.LN10) + $tooltipDecimals<= 20 ? $tooltipDecimals : 20);\n      formattedNumber = Highcharts.numberFormat(this.$v, tooltipDecimals);\n   }\n   text = $seriesTitle + ' ' + \n      (typeof $seriesName == 'number' ? $seriesName : JSON.stringify($seriesName)) + ' ' + $pointTitle + ' ' + \n      (('name' in this.point) ? JSON.stringify(this.point.name) : this.x + 1) + \n      ' <br>' + formattedNumber;}";
            formatter.append(seriesFormatter.replace("$v", pointData).replace("$id", Integer.toString(i++)).replace("$seriesTitle", seriesTitle).replace("$seriesName", seriesName).replace("$pointTitle", pointTitle).replace("$tooltipDecimals", Integer.toString(series.tooltipDecimals)));
            if (!seriesIt.hasNext()) continue;
            formatter.append(" else \n");
        }
        formatter.append("return text; }");
        conf.getTooltip().setFormatter(formatter.toString());
    }

    private void updateYAxes(Configuration conf, List<ChartData.AxisProperties> yAxisProperties) {
        if (yAxisProperties == null || yAxisProperties.size() == 0) {
            return;
        }
        YAxis defaultyAxis = conf.getyAxis();
        ChartData.AxisProperties firstYAxisProps = yAxisProperties.get(0);
        this.updateYAxisTitle(defaultyAxis, firstYAxisProps);
        defaultyAxis.setMin((Number)firstYAxisProps.minVal);
        defaultyAxis.setMax((Number)firstYAxisProps.maxVal);
        for (ChartData.AxisProperties axProp : yAxisProperties.subList(1, yAxisProperties.size())) {
            YAxis axis = new YAxis();
            axis.setOpposite(Boolean.valueOf(true));
            conf.addyAxis(axis);
            this.updateYAxisTitle(axis, axProp);
            axis.setMin((Number)axProp.minVal);
            axis.setMax((Number)axProp.maxVal);
        }
    }

    private void updateBackgroundColor(Configuration conf, ChartData.BackgroundProperties background) {
        if (background == null) {
            return;
        }
        if (background.color != null) {
            conf.getChart().setBackgroundColor((Color)this.createSolidColorFromColorProperties(background.color, SolidColor.WHITE));
        } else if (background.gradient != null) {
            conf.getChart().setBackgroundColor(this.createGradientFromGradientProps(background.gradient));
        }
    }

    private Color createGradientFromGradientProps(ChartData.GradientProperties prop) {
        double[] grPts = this.calculateGradientPoints(prop.angle);
        GradientColor linear = GradientColor.createLinear((double)grPts[0], (double)grPts[1], (double)grPts[2], (double)grPts[3]);
        for (Map.Entry<Double, ChartData.ColorProperties> grdStop : prop.colorStops.entrySet()) {
            Double position = grdStop.getKey();
            ChartData.ColorProperties colorProp = grdStop.getValue();
            linear.addColorStop(position.doubleValue(), this.createSolidColorFromColorProperties(colorProp, SolidColor.WHITE));
        }
        return linear;
    }

    private double[] calculateGradientPoints(double angle) {
        double angleInRad = angle * 2.0 * Math.PI - Math.PI;
        double x1 = Math.cos(angleInRad);
        double y1 = Math.sin(angleInRad);
        x1 = (x1 + 1.0) / 2.0;
        y1 = (y1 + 1.0) / 2.0;
        return new double[]{x1, y1, 1.0 - x1, 1.0 - y1};
    }

    private SolidColor createSolidColorFromColorProperties(ChartData.ColorProperties colorProp, SolidColor defaultColor) {
        if (colorProp == null) {
            return defaultColor;
        }
        return new SolidColor(colorProp.red, colorProp.green, colorProp.blue, colorProp.opacity);
    }

    private void updateXAxis(XAxis axis, ChartData.AxisProperties axisProperties) {
        if (axisProperties == null) {
            return;
        }
        axis.setTitle(this.wrapStringIntoItalicsTagIfNeeded(axisProperties.title, axisProperties.textProperties));
        axis.getTitle().setStyle(this.createStyleFromTextFroperties(axisProperties.textProperties));
        axis.setMin((Number)axisProperties.minVal);
        axis.setMax((Number)axisProperties.maxVal);
    }

    private void updateYAxisTitle(YAxis axis, ChartData.AxisProperties axisProperties) {
        if (axisProperties == null) {
            axis.setTitle((String)null);
            return;
        }
        axis.setTitle(this.wrapStringIntoItalicsTagIfNeeded(axisProperties.title, axisProperties.textProperties));
        axis.getTitle().setStyle(this.createStyleFromTextFroperties(axisProperties.textProperties));
    }

    private void updateLegendTextProperties(Legend legend, ChartData.TextProperties textPr) {
        Style style = this.createStyleFromTextFroperties(textPr);
        legend.setItemStyle(style);
    }

    private void updateBorder(ChartModel chart, ChartData.BorderStyle borderStyle) {
        chart.setBorderRadius((Number)borderStyle.radius);
        chart.setBorderWidth((Number)borderStyle.width);
        chart.setBorderColor((Color)this.createSolidColorFromColorProperties(borderStyle.color, null));
    }

    private Options3d getOptions3d(ChartData.View3dData view3dData) {
        this.logger.info("getOptions3d()");
        Options3d options3d = new Options3d();
        options3d.setEnabled(Boolean.valueOf(true));
        options3d.setAlpha((Number)view3dData.rotation3dAngleA);
        options3d.setBeta((Number)view3dData.rotation3dAngleB);
        options3d.setDepth((Number)100);
        options3d.setViewDistance((Number)400);
        Frame frame = new Frame();
        options3d.setFrame(frame);
        return options3d;
    }

    private void updateLegendPosition(Legend legend, ChartData definition) {
        this.logger.info("updateLegend()");
        switch (definition.legendProperties.position) {
            case NONE: {
                legend.setEnabled(Boolean.valueOf(false));
                break;
            }
            case RIGHT: {
                legend.setVerticalAlign(VerticalAlign.MIDDLE);
                legend.setAlign(HorizontalAlign.RIGHT);
                legend.setLayout(LayoutDirection.VERTICAL);
                break;
            }
            case BOTTOM: {
                legend.setVerticalAlign(VerticalAlign.BOTTOM);
                legend.setAlign(HorizontalAlign.CENTER);
                legend.setLayout(LayoutDirection.HORIZONTAL);
                break;
            }
            case LEFT: {
                legend.setVerticalAlign(VerticalAlign.MIDDLE);
                legend.setAlign(HorizontalAlign.LEFT);
                legend.setLayout(LayoutDirection.VERTICAL);
                break;
            }
            case TOP: {
                legend.setVerticalAlign(VerticalAlign.TOP);
                legend.setAlign(HorizontalAlign.CENTER);
                legend.setLayout(LayoutDirection.HORIZONTAL);
                legend.setY((Number)this.estimateTitleVerticalSize(definition));
                break;
            }
            case TOP_RIGHT: {
                legend.setVerticalAlign(VerticalAlign.TOP);
                legend.setAlign(HorizontalAlign.RIGHT);
                legend.setLayout(LayoutDirection.VERTICAL);
            }
        }
    }

    private int estimateTitleVerticalSize(ChartData definition) {
        if (definition.title == null || definition.title.isEmpty()) {
            return 0;
        }
        if (definition.titleStyle != null && definition.titleStyle.textProperties != null && definition.titleStyle.textProperties.size > 0.0) {
            return (int)definition.titleStyle.textProperties.size;
        }
        return 30;
    }

    protected void convertPlotData(ChartData definition, Configuration conf) {
        this.logger.info("convertPlotData()");
        int i = 0;
        for (AbstractSeriesData series : definition.plotData) {
            AbstractSeriesDataWriter seriesDataWriter = series.getSeriesDataWriter();
            seriesDataWriter.configureChart(conf);
            Series chartSeries = seriesDataWriter.convertSeries(definition.blanksAsZeros);
            chartSeries.setId(Integer.toString(i++));
            conf.addSeries(chartSeries);
            if (series.categories.size() <= 0) continue;
            conf.getxAxis().setType(AxisType.CATEGORY);
        }
    }

    protected Title createTitle(String titleString, ChartData.TitleProperties titleProps) {
        this.logger.info("createTitle()");
        if (titleString == null) {
            return new Title("");
        }
        Style style = this.createStyleFromTextFroperties(titleProps.textProperties);
        Title title = new Title(this.wrapStringIntoItalicsTagIfNeeded(titleString, titleProps.textProperties));
        title.setFloating(Boolean.valueOf(titleProps.isFloating));
        title.setStyle(style);
        return title;
    }

    private String wrapStringIntoItalicsTagIfNeeded(String string, ChartData.TextProperties textPr) {
        if (textPr != null && textPr.italics) {
            return "<i>" + string + "</i>";
        }
        return string;
    }

    private Style createStyleFromTextFroperties(ChartData.TextProperties textProps) {
        Style style = new Style();
        if (textProps == null) {
            return style;
        }
        style.setColor((Color)this.createSolidColorFromColorProperties(textProps.color, SolidColor.GREY));
        if (textProps.size > 0.0) {
            style.setFontSize(textProps.size + "pt");
        }
        if (textProps.fontFamily != null) {
            style.setFontFamily(textProps.fontFamily);
        }
        if (textProps.bold) {
            style.setFontWeight(FontWeight.BOLD);
        }
        return style;
    }

    protected void setDefaults(Configuration conf) {
        this.logger.info("setDefaults()");
        conf.getyAxis().setTitle((String)null);
        conf.addPlotOptions((AbstractPlotOptions)new PlotOptionsSeries(){
            {
                this.setAnimation(false);
                this.setAllowPointSelect(true);
            }
        });
    }
}

