/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.confwriter;

import com.vaadin.flow.component.charts.model.AbstractPlotOptions;
import com.vaadin.flow.component.charts.model.DataSeries;
import com.vaadin.flow.component.charts.model.PlotOptionsColumn;
import com.vaadin.flow.component.charts.model.Stacking;
import com.vaadin.flow.component.spreadsheet.charts.converter.Utils;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.ColumnSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.confwriter.AbstractSeriesDataWriter;

public class ColumnSeriesDataWriter
extends AbstractSeriesDataWriter {
    public ColumnSeriesDataWriter(ColumnSeriesData series) {
        super(series);
    }

    @Override
    protected AbstractPlotOptions createPlotOptions() {
        return new PlotOptionsColumn();
    }

    @Override
    protected ColumnSeriesData getSeriesData() {
        return (ColumnSeriesData)super.getSeriesData();
    }

    protected PlotOptionsColumn getPlotOptions() {
        return (PlotOptionsColumn)super.getPlotOptions();
    }

    @Override
    protected void configureDataSeries(DataSeries dataSeries) {
        super.configureDataSeries(dataSeries);
        String stacking = this.getSeriesData().stacking.toString();
        if (this.getSeriesData().isColorByPoint) {
            this.getPlotOptions().setColorByPoint(Boolean.valueOf(true));
        }
        this.getPlotOptions().setStacking(Utils.getEnumValueOrDefault(Stacking.class, stacking, Stacking.NONE));
        if (this.getSeriesData().is3d) {
            this.getPlotOptions().setPointPadding((Number)0.2);
            this.getPlotOptions().setBorderWidth((Number)0);
            this.getPlotOptions().setGroupZPadding((Number)10);
        }
    }
}

