/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import java.io.Serializable;
import java.util.WeakHashMap;
import org.apache.poi.ss.usermodel.Sheet;

class SheetState
implements Serializable {
    private static Spreadsheet spreadSheet;
    private static WeakHashMap<Sheet, String> selectedCells;

    SheetState(final Spreadsheet spreadSheet) {
        SheetState.spreadSheet = spreadSheet;
        spreadSheet.addSelectionChangeListener(new Spreadsheet.SelectionChangeListener(){

            @Override
            public void onSelectionChange(Spreadsheet.SelectionChangeEvent event) {
                String lastSelectionState = SheetState.this.extractStrCellRef(event);
                selectedCells.put(spreadSheet.getActiveSheet(), lastSelectionState);
            }
        });
    }

    private String extractStrCellRef(Spreadsheet.SelectionChangeEvent event) {
        String lastSelectedRange;
        Object selectedCellRef = event.getSelectedCellReference().getCellRefParts()[2] + event.getSelectedCellReference().getCellRefParts()[1];
        if (!event.getCellRangeAddresses().isEmpty() && (((String)selectedCellRef).equals((lastSelectedRange = event.getCellRangeAddresses().get(event.getCellRangeAddresses().size() - 1).formatAsString()).substring(0, lastSelectedRange.indexOf(58))) || ((String)selectedCellRef).equals(lastSelectedRange.substring(lastSelectedRange.indexOf(58) + 1)))) {
            selectedCellRef = lastSelectedRange;
        }
        return selectedCellRef;
    }

    public String getSelectedCellsOnSheet(Sheet sheetIdx) {
        return selectedCells.get(sheetIdx);
    }

    public void clear() {
        selectedCells.clear();
    }

    static {
        selectedCells = new WeakHashMap();
    }
}

