/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.grid.editor;

import java.util.HashMap;
import java.util.Map;

import com.vaadin.shared.ui.grid.AbstractGridExtensionState;
import com.vaadin.shared.ui.grid.GridConstants;

/**
 * State object for Editor in Grid.
 *
 * @author Vaadin Ltd
 * @since 8.0
 */
public class EditorState extends AbstractGridExtensionState {

    {
        // Disable editor by default.
        enabled = false;
    }

    /** Map from Column id to Component connector id. */
    public Map<String, String> columnFields = new HashMap<>();

    /** Buffer mode state. */
    public boolean buffered = true;

    /** The caption for the save button in the editor. */
    public String saveCaption = GridConstants.DEFAULT_SAVE_CAPTION;

    /** The caption for the cancel button in the editor. */
    public String cancelCaption = GridConstants.DEFAULT_CANCEL_CAPTION;

}
