/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.data;

import java.io.Serializable;

/**
 * Set of contants used in data communication of hierarchical data. These are
 * commonly used JsonObject keys which are considered to be reserved for
 * internal use.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
public class HierarchicalDataCommunicatorConstants implements Serializable {
    public static final String ROW_HIERARCHY_DESCRIPTION = "rhd";
    public static final String ROW_DEPTH = "d";
    public static final String ROW_COLLAPSED = "c";
    public static final String ROW_LEAF = "l";
    public static final String ROW_COLLAPSE_ALLOWED = "ca";
}
