/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.twincolselect;

import com.vaadin.shared.annotations.DelegateToWidget;
import com.vaadin.shared.ui.abstractmultiselect.AbstractMultiSelectState;

/**
 * Shared state for the TwinColSelect component.
 *
 * @since 7.0
 */
public class TwinColSelectState extends AbstractMultiSelectState {
    {
        primaryStyleName = "v-select-twincol";
    }
    @DelegateToWidget
    public int rows;

    public String leftColumnCaption;
    public String rightColumnCaption;
}
