/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import com.vaadin.data.Binder;
import com.vaadin.event.selection.SelectionListener;
import com.vaadin.event.selection.SingleSelectionListener;
import com.vaadin.shared.Registration;
import com.vaadin.ui.SingleSelect;

/**
 * Single selection model interface for Grid.
 *
 * @author Vaadin Ltd
 * @since 8.0
 *
 * @param <T>
 *            the type of items in grid
 */
public interface SingleSelectionModel<T> extends GridSelectionModel<T>,
        com.vaadin.data.SelectionModel.Single<T> {

    /**
     * Gets a wrapper to use this single selection model as a single select in
     * {@link Binder}.
     *
     * @return the single select wrapper
     */
    SingleSelect<T> asSingleSelect();

    /**
     * {@inheritDoc}
     * <p>
     * Use {@link #addSingleSelectionListener(SingleSelectionListener)} for more
     * specific single selection event.
     *
     * @see #addSingleSelectionListener(SingleSelectionListener)
     */
    @Override
    public default Registration addSelectionListener(
            SelectionListener<T> listener) {
        return addSingleSelectionListener(
                event -> listener.selectionChange(event));
    }

    /**
     * Adds a single selection listener that is called when the value of this
     * select is changed either by the user or programmatically.
     *
     * @param listener
     *            the value change listener, not {@code null}
     * @return a registration for the listener
     */
    public Registration addSingleSelectionListener(
            SingleSelectionListener<T> listener);
}
