/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.server;

import java.io.Serializable;

import com.vaadin.shared.ui.ErrorLevel;

/**
 * Interface for rendering error messages to terminal. All the visible errors
 * shown to user must implement this interface.
 *
 * @author Vaadin Ltd.
 * @since 3.0
 */
public interface ErrorMessage extends Serializable {

    /**
     * @deprecated As of 7.0, use {@link ErrorLevel#SYSTEM} instead
     */
    @Deprecated
    public static final ErrorLevel SYSTEMERROR = ErrorLevel.SYSTEM;

    /**
     * @deprecated As of 7.0, use {@link ErrorLevel#CRITICAL} instead
     */
    @Deprecated
    public static final ErrorLevel CRITICAL = ErrorLevel.CRITICAL;

    /**
     * @deprecated As of 7.0, use {@link ErrorLevel#ERROR} instead
     */

    @Deprecated
    public static final ErrorLevel ERROR = ErrorLevel.ERROR;

    /**
     * @deprecated As of 7.0, use {@link ErrorLevel#WARNING} instead
     */
    @Deprecated
    public static final ErrorLevel WARNING = ErrorLevel.WARNING;

    /**
     * @deprecated As of 7.0, use {@link ErrorLevel#INFO} instead
     */
    @Deprecated
    public static final ErrorLevel INFORMATION = ErrorLevel.INFO;

    /**
     * Gets the errors level.
     *
     * @return the level of error as an integer.
     */
    public ErrorLevel getErrorLevel();

    /**
     * Returns the HTML formatted message to show in as the error message on the
     * client.
     *
     * This method should perform any necessary escaping to avoid XSS attacks.
     *
     * TODO this API may still change to use a separate data transfer object
     *
     * @return HTML formatted string for the error message
     * @since 7.0
     */
    public String getFormattedHtmlMessage();

}
