/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.select;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.select.FieldValidationUtil;
import com.vaadin.flow.component.select.VaadinItem;
import com.vaadin.flow.component.select.data.SelectDataView;
import com.vaadin.flow.component.select.data.SelectListDataView;
import com.vaadin.flow.component.select.generated.GeneratedVaadinSelect;
import com.vaadin.flow.data.binder.HasItemComponents;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeEvent;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

@JsModule(value="./selectConnector.js")
public class Select<T>
extends GeneratedVaadinSelect<Select<T>, T>
implements HasItemComponents<T>,
HasSize,
HasValidation,
SingleSelect<Select<T>, T>,
HasListDataView<T, SelectListDataView<T>>,
HasDataView<T, Void, SelectDataView<T>>,
HasHelper,
HasLabel {
    public static final String LABEL_ATTRIBUTE = "label";
    private static final String VALUE_PROPERTY_NAME = "value";
    private final InternalListBox listBox = new InternalListBox();
    private final AtomicReference<DataProvider<T, ?>> dataProvider = new AtomicReference<ListDataProvider>(DataProvider.ofItems((Object[])new Object[0]));
    private ComponentRenderer<? extends Component, T> itemRenderer;
    private SerializablePredicate<T> itemEnabledProvider = null;
    private ItemLabelGenerator<T> itemLabelGenerator = null;
    private final PropertyChangeListener validationListener = this::validateSelectionEnabledState;
    private Registration validationRegistration;
    private Registration dataProviderListenerRegistration;
    private boolean resetPending = true;
    private boolean emptySelectionAllowed;
    private String emptySelectionCaption;
    private VaadinItem<T> emptySelectionItem;
    private final KeyMapper<T> keyMapper = new KeyMapper();
    private int lastNotifiedDataSize = -1;
    private volatile int lastFetchedDataSize = -1;
    private SerializableConsumer<UI> sizeRequest;

    public Select() {
        super(null, null, String.class, Select::presentationToModel, Select::modelToPresentation, true);
        this.getElement().setProperty("invalid", false);
        this.getElement().setProperty("opened", false);
        this.getElement().setAttribute("suppress-template-warning", true);
        this.setPresentationValue(null);
        this.getElement().appendChild(new Element[]{this.listBox.getElement()});
        this.registerValidation();
    }

    public Select(T ... items) {
        this();
        this.setItems(items);
    }

    private static <T> T presentationToModel(Select<T> select, String presentation) {
        if (select.keyMapper == null || !select.keyMapper.containsKey(presentation)) {
            return null;
        }
        return (T)select.keyMapper.get(presentation);
    }

    private static <T> String modelToPresentation(Select<T> select, T model) {
        if (model == null || select.keyMapper == null) {
            return "";
        }
        if (!select.keyMapper.has(model)) {
            return null;
        }
        return select.keyMapper.key(model);
    }

    public ComponentRenderer<? extends Component, T> getItemRenderer() {
        return this.itemRenderer;
    }

    public void setRenderer(ComponentRenderer<? extends Component, T> renderer) {
        this.itemRenderer = renderer;
        this.refreshItems();
    }

    public void setTextRenderer(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator);
        this.setRenderer((ComponentRenderer<? extends Component, T>)new TextRenderer(itemLabelGenerator));
    }

    public void setEmptySelectionAllowed(boolean emptySelectionAllowed) {
        if (this.isEmptySelectionAllowed() == emptySelectionAllowed) {
            return;
        }
        if (this.isEmptySelectionAllowed()) {
            this.removeEmptySelectionItem();
        } else {
            this.addEmptySelectionItem();
        }
        this.emptySelectionAllowed = emptySelectionAllowed;
    }

    public boolean isEmptySelectionAllowed() {
        return this.emptySelectionAllowed;
    }

    public void setEmptySelectionCaption(String emptySelectionCaption) {
        Objects.requireNonNull(emptySelectionCaption, "Empty selection caption must not be null");
        this.emptySelectionCaption = emptySelectionCaption;
        if (this.emptySelectionItem != null) {
            this.updateItem(this.emptySelectionItem);
        }
    }

    public String getEmptySelectionCaption() {
        return this.emptySelectionCaption == null ? "" : this.emptySelectionCaption;
    }

    public SerializablePredicate<T> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    public void setItemEnabledProvider(SerializablePredicate<T> itemEnabledProvider) {
        this.itemEnabledProvider = itemEnabledProvider;
        this.refreshItems();
    }

    public ItemLabelGenerator<T> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        this.itemLabelGenerator = itemLabelGenerator;
        this.refreshItems();
    }

    public String getPlaceholder() {
        return super.getPlaceholderString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return super.getLabelString();
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return super.isAutofocusBoolean();
    }

    @Deprecated
    public void setItems(Stream<T> streamOfItems) {
        this.setItems((ListDataProvider<T>)DataProvider.fromStream(streamOfItems));
    }

    @Deprecated
    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider.set(dataProvider);
        DataViewUtils.removeComponentFilterAndSortComparator((Component)this);
        this.reset();
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener(this::onDataChange);
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider.get();
    }

    public SelectDataView<T> setItems(DataProvider<T, Void> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getGenericDataView();
    }

    public SelectDataView<T> setItems(InMemoryDataProvider<T> inMemoryDataProvider) {
        DataProviderWrapper convertedDataProvider = new DataProviderWrapper<T, Void, SerializablePredicate<T>>((DataProvider)inMemoryDataProvider, (InMemoryDataProvider)inMemoryDataProvider){
            final /* synthetic */ InMemoryDataProvider val$inMemoryDataProvider;
            {
                this.val$inMemoryDataProvider = inMemoryDataProvider;
                super(arg0);
            }

            protected SerializablePredicate<T> getFilter(Query<T, Void> query) {
                return Optional.ofNullable(this.val$inMemoryDataProvider.getFilter()).orElse((SerializablePredicate & Serializable)item -> true);
            }
        };
        return this.setItems((DataProvider<T, Void>)convertedDataProvider);
    }

    public SelectListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        this.setDataProvider((DataProvider<T, ?>)dataProvider);
        return this.getListDataView();
    }

    public SelectDataView<T> getGenericDataView() {
        return new SelectDataView(this::getDataProvider, this, this::identifierProviderChanged);
    }

    public SelectListDataView<T> getListDataView() {
        return new SelectListDataView(this::getDataProvider, this, this::identifierProviderChanged, (SerializableBiConsumer & Serializable)(filter, sorting) -> this.reset());
    }

    public void onEnabledStateChanged(boolean enabled) {
        this.setDisabled(!enabled);
        this.getItems().forEach(this::updateItemEnabled);
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredBoolean();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return super.isInvalidBoolean();
    }

    public void add(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            if (component.getElement().hasAttribute("slot")) {
                super.add(new Component[]{component});
                continue;
            }
            this.listBox.add(new Component[]{component});
        }
    }

    public void addComponents(T afterItem, Component ... components) {
        this.listBox.addComponents(afterItem, components);
    }

    public void prependComponents(T beforeItem, Component ... components) {
        this.listBox.prependComponents(beforeItem, components);
    }

    public void addComponentAtIndex(int index, Component component) {
        Objects.requireNonNull(component, "Component should not be null");
        if (component.getElement().hasAttribute("slot")) {
            super.addComponentAtIndex(index, component);
        } else {
            this.listBox.addComponentAtIndex(index, component);
        }
    }

    public void addComponentAsFirst(Component component) {
        Objects.requireNonNull(component, "Component should not be null");
        if (component.getElement().hasAttribute("slot")) {
            super.addComponentAsFirst(component);
        } else {
            this.listBox.addComponentAsFirst(component);
        }
    }

    @Override
    public void addToPrefix(Component ... components) {
        super.addToPrefix(components);
    }

    public Stream<Component> getChildren() {
        return Stream.concat(super.getChildren().filter(component -> component != this.listBox), this.listBox.getChildren().filter(component -> !(component instanceof VaadinItem)));
    }

    @Override
    public void remove(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            if (component.getElement().hasAttribute("slot")) {
                super.remove(component);
                continue;
            }
            this.listBox.remove(components);
        }
    }

    @Override
    public void removeAll() {
        this.getChildren().forEach(xva$0 -> this.remove((Component)xva$0));
    }

    protected boolean hasValidValue() {
        String selectedKey = this.getElement().getProperty(VALUE_PROPERTY_NAME);
        Object item = this.keyMapper.get(selectedKey);
        if (item == null) {
            return this.isEmptySelectionAllowed() && this.isItemEnabled(item);
        }
        return this.isItemEnabled(item);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        FieldValidationUtil.disableClientValidation(this);
    }

    protected boolean valueEquals(T value1, T value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return this.getItemId(value1).equals(this.getItemId(value2));
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            ui.getPage().executeJs("window.Vaadin.Flow.selectConnector.initLazy($0)", new Serializable[]{this.getElement()});
            this.resetPending = false;
        });
    }

    private boolean isItemEnabled(T item) {
        return this.itemEnabledProvider == null || this.itemEnabledProvider.test(item);
    }

    private Component createItem(T bean) {
        VaadinItem<T> item = new VaadinItem<T>(this.keyMapper.key(bean), bean);
        this.updateItem(item);
        return item;
    }

    private void updateItem(VaadinItem<T> vaadinItem) {
        vaadinItem.removeAll();
        T item = vaadinItem.getItem();
        if (vaadinItem == this.emptySelectionItem) {
            vaadinItem.setText(this.emptySelectionCaption);
        } else if (this.getItemRenderer() != null) {
            vaadinItem.add(new Component[]{this.getItemRenderer().createComponent(item)});
        } else if (this.getItemLabelGenerator() != null) {
            vaadinItem.setText(this.getItemLabelGenerator().apply(item));
        } else {
            vaadinItem.setText(item.toString());
        }
        if (this.getItemLabelGenerator() != null) {
            vaadinItem.getElement().setAttribute(LABEL_ATTRIBUTE, this.getItemLabelGenerator().apply(item));
        } else if (item == this.emptySelectionItem) {
            vaadinItem.getElement().setAttribute(LABEL_ATTRIBUTE, "");
        } else {
            vaadinItem.getElement().removeAttribute(LABEL_ATTRIBUTE);
        }
        this.updateItemEnabled(vaadinItem);
        this.requestClientSideContentUpdateIfNotPending();
    }

    private void updateItemEnabled(VaadinItem<T> item) {
        boolean itemEnabled = this.isItemEnabled(item.getItem());
        boolean disabled = this.isDisabledBoolean() || !itemEnabled;
        item.getElement().setEnabled(!disabled);
        item.getElement().setAttribute("disabled", !itemEnabled);
    }

    private void refreshItems() {
        this.getItems().forEach(this::updateItem);
    }

    private Stream<VaadinItem<T>> getItems() {
        return this.listBox.getChildren().filter(component -> component instanceof VaadinItem).map(child -> (VaadinItem)((Object)child));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        this.keyMapper.removeAll();
        this.listBox.removeAll();
        this.clear();
        this.requestClientSideContentUpdateIfNotPending();
        if (this.isEmptySelectionAllowed()) {
            this.addEmptySelectionItem();
        }
        AtomicReference<DataProvider<T, ?>> atomicReference = this.dataProvider;
        synchronized (atomicReference) {
            AtomicInteger itemCounter = new AtomicInteger(0);
            this.getDataProvider().fetch(DataViewUtils.getQuery((Component)this)).map(item -> this.createItem(item)).forEach(component -> {
                this.add((Component)component);
                itemCounter.incrementAndGet();
            });
            this.lastFetchedDataSize = itemCounter.get();
            if (this.sizeRequest == null) {
                this.sizeRequest = (SerializableConsumer & Serializable)ui -> {
                    this.fireSizeEvent();
                    this.sizeRequest = null;
                };
                this.runBeforeClientResponse(this.sizeRequest);
            }
        }
    }

    private void requestClientSideContentUpdateIfNotPending() {
        if (!this.resetPending) {
            this.resetPending = true;
            this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
                ui.getPage().executeJs("$0.requestContentUpdate();", new Serializable[]{this.getElement()});
                this.resetPending = false;
            });
        }
    }

    private void onDataChange(DataChangeEvent<T> event) {
        if (event instanceof DataChangeEvent.DataRefreshEvent) {
            Object updatedItem = ((DataChangeEvent.DataRefreshEvent)event).getItem();
            IdentifierProvider identifierProvider = this.getIdentifierProvider();
            Object updatedItemId = identifierProvider.apply(updatedItem);
            this.getItems().filter(vaadinItem -> updatedItemId.equals(identifierProvider.apply(vaadinItem.getItem()))).findAny().ifPresent(this::updateItem);
        } else {
            this.reset();
        }
    }

    private T getValue(Serializable key) {
        if (key == null || "".equals(key)) {
            return null;
        }
        return (T)this.keyMapper.get(key.toString());
    }

    private void addEmptySelectionItem() {
        if (this.emptySelectionItem == null) {
            this.emptySelectionItem = new VaadinItem<Object>("", null);
        }
        this.updateItem(this.emptySelectionItem);
        this.addComponentAsFirst(this.emptySelectionItem);
        if (this.getValue() == null) {
            this.setValue(null);
        }
    }

    private void removeEmptySelectionItem() {
        if (this.emptySelectionItem != null) {
            this.listBox.remove(new Component[]{this.emptySelectionItem});
        }
        this.emptySelectionItem = null;
    }

    private void validateSelectionEnabledState(PropertyChangeEvent event) {
        if (!event.isUserOriginated()) {
            return;
        }
        if (!this.hasValidValue() || this.isReadOnly()) {
            T oldValue = this.getValue(event.getOldValue());
            try {
                this.validationRegistration.remove();
                this.getElement().setProperty(VALUE_PROPERTY_NAME, this.keyMapper.key(oldValue));
            }
            finally {
                this.registerValidation();
            }
            Optional<VaadinItem> selectedItem = this.getItems().filter(item -> item.getItem() == this.getValue(event.getValue())).findFirst();
            selectedItem.ifPresent(this::updateItemEnabled);
        }
    }

    private void registerValidation() {
        if (this.validationRegistration != null) {
            this.validationRegistration.remove();
        }
        this.validationRegistration = this.getElement().addPropertyChangeListener(VALUE_PROPERTY_NAME, this.validationListener);
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private void fireSizeEvent() {
        int newSize = this.lastFetchedDataSize;
        if (this.lastNotifiedDataSize != newSize) {
            this.lastNotifiedDataSize = newSize;
            this.fireEvent((ComponentEvent)new ItemCountChangeEvent((Component)this, newSize, false));
        }
    }

    private IdentifierProvider<T> getIdentifierProvider() {
        IdentifierProvider identifierProviderObject = (IdentifierProvider)ComponentUtil.getData((Component)this, IdentifierProvider.class);
        if (identifierProviderObject == null) {
            DataProvider<T, ?> dataProvider = this.getDataProvider();
            if (dataProvider != null) {
                return arg_0 -> dataProvider.getId(arg_0);
            }
            return IdentifierProvider.identity();
        }
        return identifierProviderObject;
    }

    private Object getItemId(T item) {
        return this.getIdentifierProvider().apply(item);
    }

    private void identifierProviderChanged(IdentifierProvider<T> identifierProvider) {
        this.keyMapper.setIdentifierGetter(identifierProvider);
    }

    @Tag(value="vaadin-select-list-box")
    @NpmPackage(value="@vaadin/polymer-legacy-adapter", version="23.0.4")
    @JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js")
    private class InternalListBox
    extends Component
    implements HasItemComponents<T> {
        private InternalListBox() {
        }

        public int getItemPosition(T item) {
            if (item == null && Select.this.isEmptySelectionAllowed()) {
                return 0;
            }
            return super.getItemPosition(item);
        }
    }
}

