/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.dom.Element;

public class TextRenderer<ITEM>
extends ComponentRenderer<Component, ITEM> {
    private final ItemLabelGenerator<ITEM> itemLabelGenerator;

    public TextRenderer() {
        this.itemLabelGenerator = String::valueOf;
    }

    public TextRenderer(ItemLabelGenerator<ITEM> itemLabelGenerator) {
        this.itemLabelGenerator = itemLabelGenerator;
    }

    @Override
    public Component createComponent(ITEM item) {
        String text = this.itemLabelGenerator.apply(item);
        if (text == null) {
            throw new IllegalStateException(String.format("Got 'null' as a label value for the item '%s'. '%s' instance may not return 'null' values", item, ItemLabelGenerator.class.getSimpleName()));
        }
        return new TextRendererComponent(this.createElement(text));
    }

    protected Element createElement(String item) {
        return new Element("span").setText(item);
    }

    private static class TextRendererComponent
    extends Component {
        TextRendererComponent(Element element) {
            super(element);
        }
    }
}

