/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.progressbar;

import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.progressbar.GeneratedVaadinProgressBar;
import com.vaadin.flow.component.progressbar.ProgressBarVariant;

@NpmPackage.Container(value={@NpmPackage(value="@vaadin/progress-bar", version="23.3.25"), @NpmPackage(value="@vaadin/vaadin-progress-bar", version="23.3.25")})
public class ProgressBar
extends GeneratedVaadinProgressBar<ProgressBar>
implements HasSize {
    public ProgressBar() {
        this(0.0, 1.0);
    }

    public ProgressBar(double min, double max) {
        this(min, max, min);
    }

    public ProgressBar(double min, double max, double value) {
        if (min >= max) {
            throw new IllegalArgumentException(String.format("min ('%s') must be less than max ('%s')", min, max));
        }
        this.setMin(min);
        this.setMax(max);
        this.setValue(value);
    }

    @Override
    public void setValue(double value) {
        double min = this.getMin();
        double max = this.getMax();
        if (min > value || value > max) {
            throw new IllegalArgumentException(String.format("value must be between min ('%s') and max ('%s')", min, max));
        }
        super.setValue(value);
    }

    public double getValue() {
        return this.getValueDouble();
    }

    @Override
    public void setMax(double max) {
        super.setMax(max);
    }

    public double getMax() {
        return this.getMaxDouble();
    }

    @Override
    public void setMin(double min) {
        super.setMin(min);
    }

    public double getMin() {
        return this.getMinDouble();
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
    }

    public boolean isIndeterminate() {
        return this.isIndeterminateBoolean();
    }

    @Override
    public void addThemeVariants(ProgressBarVariant ... variants) {
        super.addThemeVariants(variants);
    }

    @Override
    public void removeThemeVariants(ProgressBarVariant ... variants) {
        super.removeThemeVariants(variants);
    }
}

