/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.notification;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.internal.OverlayClassListProxy;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementDetachEvent;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.HtmlUtils;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Tag(value="vaadin-notification")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.2.4"), @NpmPackage(value="@vaadin/notification", version="24.2.4")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/notification/src/vaadin-notification.js"), @JsModule(value="./flow-component-renderer.js")})
public class Notification
extends Component
implements HasComponents,
HasStyle,
HasThemeVariant<NotificationVariant> {
    private static final int DEFAULT_DURATION = 5000;
    private static final Position DEFAULT_POSITION = Position.BOTTOM_START;
    private static final String OPENED_PROPERTY = "opened";
    private static final String OPENED_CHANGED_EVENT = "opened-changed";
    private boolean autoAddedToTheUi = false;
    private Registration afterProgrammaticNavigationListenerRegistration;
    private Map<Element, Registration> childDetachListenerMap = new HashMap<Element, Registration>();
    private ElementDetachListener childDetachListener = new ElementDetachListener(){

        public void onDetach(ElementDetachEvent e) {
            boolean childDetachedFromContainer;
            Element child = e.getSource();
            boolean bl = childDetachedFromContainer = !Notification.this.getElement().getChildren().anyMatch(containerChild -> Objects.equals(child, containerChild));
            if (childDetachedFromContainer) {
                Notification.this.childDetachListenerMap.get(child).remove();
                Notification.this.childDetachListenerMap.remove(child);
                Notification.this.configureComponentRenderer();
            }
        }
    };

    private void configureRenderer() {
        String appId = UI.getCurrent() != null ? UI.getCurrent().getInternals().getAppId() : "ROOT";
        this.getElement().executeJs("this.renderer = (root) => {  if (this.text) {    root.textContent = this.text;  } else {    Vaadin.FlowComponentHost.setChildNodes($0, this.virtualChildNodeIds, root)  }}", new Serializable[]{appId});
    }

    public Notification() {
        this.initBaseElementsAndListeners();
        this.setPosition(DEFAULT_POSITION);
        this.setDuration(0);
    }

    public Notification(String text) {
        this(text, 0, DEFAULT_POSITION);
    }

    public Notification(String text, int duration) {
        this(text, duration, DEFAULT_POSITION);
    }

    public Notification(String text, int duration, Position position) {
        this.initBaseElementsAndListeners();
        this.setText(text);
        this.setDuration(duration);
        this.setPosition(position);
    }

    public Notification(Component ... components) {
        this();
        this.add(components);
    }

    private void initBaseElementsAndListeners() {
        this.getElement().addPropertyChangeListener(OPENED_PROPERTY, (PropertyChangeListener & Serializable)event -> this.fireEvent(new OpenedChangeEvent(this, event.isUserOriginated())));
        this.getElement().addEventListener(OPENED_CHANGED_EVENT, (DomEventListener & Serializable)event -> this.removeAutoAdded());
    }

    private void removeAutoAdded() {
        if (this.autoAddedToTheUi && !this.isOpened()) {
            this.autoAddedToTheUi = false;
            this.getElement().removeFromParent();
        }
    }

    public static Notification show(String text, int duration, Position position) {
        Notification notification = new Notification(text, duration, position);
        notification.open();
        return notification;
    }

    public static Notification show(String text) {
        return Notification.show(text, 5000, DEFAULT_POSITION);
    }

    public void setText(String text) {
        this.removeAll();
        this.getElement().setProperty("text", text != null ? HtmlUtils.escape((String)text) : null);
        this.getElement().callJsFunction("requestContentUpdate", new Serializable[0]);
    }

    public void setPosition(Position position) {
        String positionName = position.getClientName();
        this.getElement().setProperty("position", positionName == null ? "" : positionName);
    }

    public Position getPosition() {
        String position = this.getElement().getProperty("position");
        return Optional.ofNullable(position).map(Position::fromClientName).orElse(DEFAULT_POSITION);
    }

    public void open() {
        this.setOpened(true);
    }

    public void close() {
        this.setOpened(false);
    }

    public void add(Collection<Component> components) {
        super.add(components);
        this.configureComponentRenderer();
    }

    public void addComponentAtIndex(int index, Component component) {
        super.addComponentAtIndex(index, component);
        this.configureComponentRenderer();
    }

    public void setOpened(boolean opened) {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        StateTree.ExecutionRegistration addToUiRegistration = ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
            if (this.isOpened() && this.getElement().getNode().getParent() == null) {
                ui.addToModalComponent((Component)this);
                this.autoAddedToTheUi = true;
            }
            if (this.afterProgrammaticNavigationListenerRegistration != null) {
                this.afterProgrammaticNavigationListenerRegistration.remove();
            }
        });
        if (ui.getSession() != null) {
            this.afterProgrammaticNavigationListenerRegistration = ui.addAfterNavigationListener((AfterNavigationListener & Serializable)event -> {
                if (event.getLocationChangeEvent().getTrigger() == NavigationTrigger.PROGRAMMATIC) {
                    addToUiRegistration.remove();
                    this.afterProgrammaticNavigationListenerRegistration.remove();
                }
            });
        }
        this.getElement().setProperty(OPENED_PROPERTY, opened);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty(OPENED_PROPERTY, false);
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    public void setDuration(int duration) {
        this.getElement().setProperty("duration", (double)duration);
    }

    public int getDuration() {
        return this.getElement().getProperty("duration", 0);
    }

    public Registration addAttachListener(ComponentEventListener<AttachEvent> listener) {
        return super.addAttachListener(listener);
    }

    public Registration addDetachListener(ComponentEventListener<DetachEvent> listener) {
        return super.addDetachListener(listener);
    }

    private void configureComponentRenderer() {
        this.getElement().removeProperty("text");
        this.updateVirtualChildNodeIds();
    }

    private void updateVirtualChildNodeIds() {
        this.getElement().getChildren().forEach(child -> {
            if (!this.childDetachListenerMap.containsKey(child)) {
                this.childDetachListenerMap.put((Element)child, child.addDetachListener(this.childDetachListener));
            }
        });
        this.getElement().setPropertyList("virtualChildNodeIds", this.getElement().getChildren().map(element -> element.getNode().getId()).collect(Collectors.toList()));
        this.getElement().callJsFunction("requestContentUpdate", new Serializable[0]);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getElement().executeJs("Vaadin.FlowComponentHost.patchVirtualContainer(this)", new Serializable[0]);
        this.configureRenderer();
        this.updateVirtualChildNodeIds();
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        detachEvent.getUI().beforeClientResponse((Component)this, (SerializableConsumer & Serializable)executionContext -> {
            this.setOpened(false);
            this.removeAutoAdded();
        });
    }

    public void setClassName(String className) {
        this.getClassNames().clear();
        if (className != null) {
            this.addClassNames(className.split(" "));
        }
    }

    public ClassList getClassNames() {
        return new OverlayClassListProxy((HasStyle)this);
    }

    public Style getStyle() {
        throw new UnsupportedOperationException("Notification does not support adding styles to card element");
    }

    public static enum Position {
        TOP_STRETCH,
        TOP_START,
        TOP_CENTER,
        TOP_END,
        MIDDLE,
        BOTTOM_START,
        BOTTOM_CENTER,
        BOTTOM_END,
        BOTTOM_STRETCH;

        private final String clientName = this.name().toLowerCase(Locale.ENGLISH).replace('_', '-');

        public String getClientName() {
            return this.clientName;
        }

        static Position fromClientName(String clientName) {
            return clientName == null ? null : Position.valueOf(clientName.replace('-', '_').toUpperCase(Locale.ENGLISH));
        }
    }

    public static class OpenedChangeEvent
    extends ComponentEvent<Notification> {
        private final boolean opened;

        public OpenedChangeEvent(Notification source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

