/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.theme.material;

import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.theme.AbstractTheme;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

@HtmlImport.Container(value={@HtmlImport(value="frontend://bower_components/vaadin-material-styles/color.html"), @HtmlImport(value="frontend://bower_components/vaadin-material-styles/typography.html")})
@NpmPackage(value="@vaadin/vaadin-material-styles", version="1.3.2")
@JsModule.Container(value={@JsModule(value="@vaadin/vaadin-material-styles/color.js"), @JsModule(value="@vaadin/vaadin-material-styles/typography.js")})
public class Material
implements AbstractTheme {
    public static final String LIGHT = "light";
    public static final String DARK = "dark";

    public String getBaseUrl() {
        return "src/";
    }

    public String getThemeUrl() {
        return "theme/material/";
    }

    public List<String> getHeaderInlineContents() {
        return Collections.singletonList("<custom-style>    <style include=\"material-color-light material-typography\"></style></custom-style>");
    }

    @Deprecated
    public Map<String, String> getBodyAttributes(String variant) {
        return this.getHtmlAttributes(variant);
    }

    public Map<String, String> getHtmlAttributes(String variant) {
        switch (variant) {
            case "light": {
                return Collections.singletonMap("theme", LIGHT);
            }
            case "dark": {
                return Collections.singletonMap("theme", DARK);
            }
        }
        if (!variant.isEmpty()) {
            LoggerFactory.getLogger((String)this.getClass().getName()).warn("Material theme variant not recognized: '{}'. Using no variant.", (Object)variant);
        }
        return Collections.emptyMap();
    }
}

