/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.markdown;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.Objects;

@Tag(value="vaadin-markdown")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.9.2"), @NpmPackage(value="@vaadin/markdown", version="24.9.2")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/markdown/src/vaadin-markdown.js")})
public class Markdown
extends Component
implements HasSize {
    private String serverContent;
    private String clientContent;

    public Markdown() {
    }

    public Markdown(String content) {
        this.setContent(content);
    }

    public void setContent(String content) {
        this.serverContent = content;
        this.scheduleContentUpdate();
    }

    public void appendContent(String content) {
        if (this.serverContent == null) {
            this.serverContent = "";
        }
        this.setContent(this.serverContent + content);
    }

    public String getContent() {
        return this.serverContent;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.serverContent != null) {
            this.clientContent = null;
            this.scheduleContentUpdate();
        }
    }

    private void scheduleContentUpdate() {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> {
            if (Objects.equals(this.clientContent, this.serverContent)) {
                return;
            }
            if (this.serverContent != null && this.clientContent != null && this.serverContent.startsWith(this.clientContent)) {
                this.getElement().executeJs("this.content += $0", new Serializable[]{this.serverContent.substring(this.clientContent.length())});
            } else {
                this.getElement().executeJs("this.content = $0", new Serializable[]{this.serverContent});
            }
            this.clientContent = this.serverContent;
        }));
    }
}

