/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.testbench;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

@Element(value="vaadin-map")
public class MapElement
extends TestBenchElement {
    public Object evaluateOLExpression(String expression) {
        return this.executeScript("const map = arguments[0].configuration; return " + expression, new Object[]{this.getWrappedElement()});
    }

    public String getOLTypeNameExpression(String jsExpression) {
        return jsExpression + ".typeName";
    }

    public void clickAtCoordinates(double x, double y) {
        Rectangle mapRectangle = this.getRect();
        int startLeft = -mapRectangle.width / 2;
        int startTop = -mapRectangle.height / 2;
        List pixelCoordinates = (List)this.executeScript("return arguments[0].configuration.getPixelFromCoordinate([arguments[1], arguments[2]])", new Object[]{this, x, y});
        int clickX = startLeft + ((Number)pixelCoordinates.get(0)).intValue();
        int clickY = startTop + ((Number)pixelCoordinates.get(1)).intValue();
        new Actions(this.getDriver()).moveToElement((WebElement)this, clickX, clickY).click().build().perform();
    }

    public String getLayerExpression(String layerId) {
        return String.format("map.getLayers().getArray().find(layer => layer.id === '%s')", layerId);
    }

    public String getFeatureCollectionExpression(String layerId) {
        return this.getLayerExpression(layerId) + ".getSource().getFeaturesCollection()";
    }

    public TestBenchElement getAttributionContainer() {
        return this.$("div").attributeContains("class", "ol-attribution").first();
    }

    public List<TestBenchElement> getAttributionItems() {
        return this.getAttributionContainer().$("li").all();
    }

    public void disableInteractions() {
        String script = "const interactions = arguments[0].configuration.getInteractions();interactions.forEach(interaction => interaction.setActive && interaction.setActive(false));";
        this.executeScript(script, new Object[]{this});
    }
}

