/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.events;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.map.MapBase;
import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.Extent;
import com.vaadin.flow.component.map.events.MapEventUtil;
import elemental.json.JsonArray;

@DomEvent(value="map-view-moveend")
public class MapViewMoveEndEvent
extends ComponentEvent<MapBase> {
    private final double rotation;
    private final double zoom;
    private final Coordinate center;
    private final Extent extent;

    public MapViewMoveEndEvent(MapBase source, boolean fromClient, @EventData(value="event.detail.rotation") double rotation, @EventData(value="event.detail.zoom") double zoom, @EventData(value="event.detail.center") JsonArray center, @EventData(value="event.detail.extent") JsonArray extent) {
        super((Component)source, fromClient);
        this.rotation = rotation;
        this.zoom = zoom;
        this.center = MapEventUtil.getCoordinate(center);
        this.extent = MapEventUtil.getExtent(extent);
    }

    public double getRotation() {
        return this.rotation;
    }

    public double getZoom() {
        return this.zoom;
    }

    public Coordinate getCenter() {
        return this.center;
    }

    public Extent getExtent() {
        return this.extent;
    }
}

