/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.feature;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.flow.component.map.Assets;
import com.vaadin.flow.component.map.configuration.Coordinate;
import com.vaadin.flow.component.map.configuration.feature.PointBasedFeature;
import com.vaadin.flow.component.map.configuration.style.Icon;
import com.vaadin.flow.component.map.configuration.style.Style;
import java.util.Objects;

public class MarkerFeature
extends PointBasedFeature {
    public static final Icon PIN_ICON;
    public static final Icon POINT_ICON;

    public MarkerFeature() {
        this(new Coordinate(0.0, 0.0), PIN_ICON);
    }

    public MarkerFeature(Coordinate coordinates) {
        this(coordinates, PIN_ICON);
    }

    public MarkerFeature(Coordinate coordinates, Icon icon) {
        super(coordinates);
        Objects.requireNonNull(coordinates);
        Objects.requireNonNull(icon);
        Style style = new Style();
        this.setStyle(style);
        this.setIcon(icon);
    }

    @JsonIgnore
    public Icon getIcon() {
        return (Icon)this.getStyle().getImage();
    }

    public void setIcon(Icon icon) {
        Objects.requireNonNull(icon);
        this.getStyle().setImage(icon);
    }

    static {
        Icon.ImageSize pinImageSize = new Icon.ImageSize(Assets.PIN.getWidth(), Assets.PIN.getHeight());
        PIN_ICON = new Icon(((Icon.Options)new Icon.Options().setImg(Assets.PIN.getResource()).setImgSize(pinImageSize).setScale(0.5f)).setAnchorOrigin(Icon.AnchorOrigin.BOTTOM_LEFT).setAnchor(new Icon.Anchor(0.5f, 0.12f)));
        Icon.ImageSize pointImageSize = new Icon.ImageSize(Assets.POINT.getWidth(), Assets.POINT.getHeight());
        POINT_ICON = new Icon(((Icon.Options)new Icon.Options().setImg(Assets.POINT.getResource()).setImgSize(pointImageSize).setScale(0.25f)).setAnchorOrigin(Icon.AnchorOrigin.TOP_LEFT).setAnchor(new Icon.Anchor(0.5f, 0.5f)));
    }
}

