/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.source;

import com.vaadin.flow.component.map.configuration.source.ImageSource;
import java.util.Map;
import java.util.Objects;

public class ImageWMSSource
extends ImageSource {
    private String url;
    private final Map<String, Object> params;
    private final String serverType;
    private final String crossOrigin;
    private final float ratio;

    public ImageWMSSource(Options options) {
        super(options);
        Objects.requireNonNull(options.params, "WMS request parameters must not be null");
        Objects.requireNonNull(options.params.get("LAYERS"), "WMS request parameter LAYERS must not be null");
        this.url = options.url;
        this.params = options.params;
        this.serverType = options.serverType;
        this.crossOrigin = options.crossOrigin;
        this.ratio = options.ratio;
    }

    @Override
    public String getType() {
        return "ol/source/ImageWMS";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getCrossOrigin() {
        return this.crossOrigin;
    }

    public float getRatio() {
        return this.ratio;
    }

    public static class Options
    extends ImageSource.BaseOptions<Options> {
        private String url;
        private Map<String, Object> params;
        private String serverType;
        private String crossOrigin;
        private float ratio = 1.5f;

        public Options setUrl(String url) {
            this.url = url;
            return (Options)this.getThis();
        }

        public Options setParams(Map<String, Object> params) {
            this.params = params;
            return (Options)this.getThis();
        }

        public Options setServerType(String serverType) {
            this.serverType = serverType;
            return (Options)this.getThis();
        }

        public Options setCrossOrigin(String crossOrigin) {
            this.crossOrigin = crossOrigin;
            return (Options)this.getThis();
        }

        public Options setRatio(float ratio) {
            this.ratio = ratio;
            return (Options)this.getThis();
        }
    }
}

