/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.contextmenu.ContextMenuBase;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.dom.DomEventListener;
import java.io.Serializable;
import java.util.Optional;

public class GridContextMenu<T>
extends ContextMenuBase<GridContextMenu<T>> {
    public GridContextMenu() {
    }

    public GridContextMenu(Grid<T> target) {
        this();
        this.setTarget(target);
    }

    public void setTarget(Component target) {
        if (!(target instanceof Grid)) {
            throw new IllegalArgumentException("Only an instance of Grid can be used as the target for GridContextMenu. Use ContextMenu for any other component.");
        }
        super.setTarget(target);
    }

    public MenuItem addItem(String text, ComponentEventListener<GridContextMenuItemClickEvent<T>> clickListener) {
        MenuItem menuItem = this.addItem(text);
        this.addMenuItemClickListener(menuItem, clickListener);
        return menuItem;
    }

    public MenuItem addItem(Component component, ComponentEventListener<GridContextMenuItemClickEvent<T>> clickListener) {
        MenuItem menuItem = this.addItem(component);
        this.addMenuItemClickListener(menuItem, clickListener);
        return menuItem;
    }

    private void addMenuItemClickListener(MenuItem menuItem, ComponentEventListener<GridContextMenuItemClickEvent<T>> clickListener) {
        if (clickListener != null) {
            menuItem.getElement().addEventListener("click", (DomEventListener & Serializable)event -> clickListener.onComponentEvent(new GridContextMenuItemClickEvent(menuItem, true)));
        }
    }

    public static class GridContextMenuItemClickEvent<T>
    extends ComponentEvent<MenuItem> {
        private Grid<T> grid = (Grid)((MenuItem)this.getSource()).getContextMenu().getTarget();

        GridContextMenuItemClickEvent(MenuItem source, boolean fromClient) {
            super((Component)source, fromClient);
        }

        public Grid<T> getGrid() {
            return this.grid;
        }

        public Optional<T> getItem() {
            return Optional.ofNullable(this.grid.getContextMenuTargetItem());
        }
    }
}

