/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.SortOrder;
import com.vaadin.flow.data.provider.hierarchy.AbstractHierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.BackEndHierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractBackEndHierarchicalDataProvider<T, F>
extends AbstractHierarchicalDataProvider<T, F>
implements BackEndHierarchicalDataProvider<T, F> {
    private List<QuerySortOrder> sortOrders = new ArrayList<QuerySortOrder>();

    private HierarchicalQuery<T, F> mixInSortOrders(HierarchicalQuery<T, F> query) {
        if (this.sortOrders.isEmpty()) {
            return query;
        }
        Set sortedPropertyNames = query.getSortOrders().stream().map(SortOrder::getSorted).collect(Collectors.toSet());
        List<QuerySortOrder> combinedSortOrders = Stream.concat(query.getSortOrders().stream(), this.sortOrders.stream().filter(order -> !sortedPropertyNames.contains(order.getSorted()))).collect(Collectors.toList());
        return new HierarchicalQuery<T, Object>(query.getOffset(), query.getLimit(), combinedSortOrders, query.getInMemorySorting(), query.getFilter().orElse(null), query.getParent());
    }

    @Override
    public Stream<T> fetchChildren(HierarchicalQuery<T, F> query) {
        return this.fetchChildrenFromBackEnd(this.mixInSortOrders(query));
    }

    public boolean isInMemory() {
        return false;
    }

    public void setSortOrders(List<QuerySortOrder> sortOrders) {
        this.sortOrders = Objects.requireNonNull(sortOrders, "Sort orders cannot be null");
        this.refreshAll();
    }

    protected abstract Stream<T> fetchChildrenFromBackEnd(HierarchicalQuery<T, F> var1);
}

