/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.validation;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.tests.AbstractComponentIT;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractValidationIT<T extends TestBenchElement>
extends AbstractComponentIT {
    protected T testField;

    @Before
    public void init() {
        this.open();
        this.testField = this.getTestField();
    }

    protected abstract T getTestField();

    protected void assertErrorMessage(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.testField.getPropertyString(new String[]{"errorMessage"}));
    }

    protected void assertClientValid() {
        Assert.assertTrue((String)"The field should be valid on the client-side", (boolean)this.isClientValid());
    }

    protected void assertClientInvalid() {
        Assert.assertFalse((String)"The field should be invalid on the client-side", (boolean)this.isClientValid());
    }

    protected void assertServerValid() {
        Assert.assertTrue((String)"The field should be valid on the server-side", (boolean)this.isServerValid());
    }

    protected void assertServerInvalid() {
        Assert.assertFalse((String)"The field should be invalid on the server-side", (boolean)this.isServerValid());
    }

    private boolean isServerValid() {
        this.$("button").id("server-validity-state-button").click();
        String actual = this.$("div").id("server-validity-state").getText();
        return actual.equals("true");
    }

    private boolean isClientValid() {
        return this.testField.getPropertyBoolean(new String[]{"invalid"}) == false;
    }
}

