/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared;

import com.vaadin.flow.data.binder.ValidationResult;
import java.util.Objects;

public class ValidationUtil {
    private ValidationUtil() {
    }

    @Deprecated
    public static <V> ValidationResult checkRequired(boolean required, V value, V emptyValue) {
        return ValidationUtil.validateRequiredConstraint("", required, value, emptyValue);
    }

    public static <V> ValidationResult validateRequiredConstraint(String errorMessage, boolean required, V value, V emptyValue) {
        boolean isError = required && Objects.equals(emptyValue, value);
        return isError ? ValidationResult.error((String)errorMessage) : ValidationResult.ok();
    }

    @Deprecated
    public static <V extends Comparable<V>> ValidationResult checkGreaterThanMax(V value, V maxValue) {
        return ValidationUtil.validateMaxConstraint("", value, maxValue);
    }

    public static <V extends Comparable<V>> ValidationResult validateMaxConstraint(String errorMessage, V value, V maxValue) {
        boolean isError = value != null && maxValue != null && value.compareTo(maxValue) > 0;
        return isError ? ValidationResult.error((String)errorMessage) : ValidationResult.ok();
    }

    @Deprecated
    public static <V extends Comparable<V>> ValidationResult checkSmallerThanMin(V value, V minValue) {
        return ValidationUtil.validateMinConstraint("", value, minValue);
    }

    public static <V extends Comparable<V>> ValidationResult validateMinConstraint(String errorMessage, V value, V minValue) {
        boolean isError = value != null && minValue != null && value.compareTo(minValue) < 0;
        return isError ? ValidationResult.error((String)errorMessage) : ValidationResult.ok();
    }

    public static ValidationResult validateMinLengthConstraint(String errorMessage, String value, Integer minLength) {
        boolean isError = value != null && !value.isEmpty() && minLength != null && value.length() < minLength;
        return isError ? ValidationResult.error((String)errorMessage) : ValidationResult.ok();
    }

    public static ValidationResult validateMaxLengthConstraint(String errorMessage, String value, Integer maxLength) {
        boolean isError = value != null && maxLength != null && value.length() > maxLength;
        return isError ? ValidationResult.error((String)errorMessage) : ValidationResult.ok();
    }

    public static ValidationResult validatePatternConstraint(String errorMessage, String value, String pattern) {
        boolean isError = value != null && !value.isEmpty() && pattern != null && !pattern.isEmpty() && !value.matches(pattern);
        return isError ? ValidationResult.error((String)errorMessage) : ValidationResult.ok();
    }
}

