/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.dom.Element;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SlotUtils {
    public static Stream<Element> getElementsInSlot(HasElement parent, String slot) {
        return parent.getElement().getChildren().filter(child -> slot.equals(child.getAttribute("slot")));
    }

    public static void clearSlot(HasElement parent, String slot) {
        SlotUtils.getElementsInSlot(parent, slot).collect(Collectors.toList()).forEach(arg_0 -> SlotUtils.lambda$clearSlot$1(parent.getElement(), arg_0));
    }

    public static Component getChildInSlot(HasElement parent, String slot) {
        Optional<Element> element = SlotUtils.getElementsInSlot(parent, slot).findFirst();
        return element.flatMap(Element::getComponent).orElse(null);
    }

    public static void addToSlot(HasElement parent, String slot, Component ... components) {
        Objects.requireNonNull(parent, "Parent cannot be null");
        for (Component component : components) {
            if (component == null) continue;
            if (component instanceof Text) {
                throw new IllegalArgumentException("Text as a " + slot + " slot content is not supported. Consider wrapping the Text inside a Div.");
            }
            SlotUtils.addElementToSlot(parent, component.getElement(), slot);
        }
    }

    public static void addToSlot(HasElement parent, String slot, Element ... elements) {
        Objects.requireNonNull(parent, "Parent cannot be null");
        for (Element element : elements) {
            if (element == null) continue;
            SlotUtils.addElementToSlot(parent, element, slot);
        }
    }

    public static void setSlot(HasElement parent, String slot, Component ... components) {
        Objects.requireNonNull(parent, "Parent cannot be null");
        SlotUtils.clearSlot(parent, slot);
        SlotUtils.addToSlot(parent, slot, components);
    }

    public static void setSlot(HasElement parent, String slot, Element ... elements) {
        Objects.requireNonNull(parent, "Parent cannot be null");
        SlotUtils.clearSlot(parent, slot);
        SlotUtils.addToSlot(parent, slot, elements);
    }

    private static void addElementToSlot(HasElement parent, Element element, String slot) {
        element.setAttribute("slot", slot);
        parent.getElement().appendChild(new Element[]{element});
    }

    private static /* synthetic */ void lambda$clearSlot$1(Element rec$, Element xva$0) {
        Element cfr_ignored_0 = (Element)rec$.removeChild(new Element[]{xva$0});
    }
}

