/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.shared;

import com.vaadin.flow.data.binder.ValidationResult;
import java.util.Objects;

public class ValidationUtil {
    private ValidationUtil() {
    }

    public static <V> ValidationResult checkRequired(boolean required, V value, V emptyValue) {
        boolean isRequiredButEmpty;
        boolean bl = isRequiredButEmpty = required && Objects.equals(emptyValue, value);
        if (isRequiredButEmpty) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    public static <V extends Comparable<V>> ValidationResult checkGreaterThanMax(V value, V maxValue) {
        boolean isGreaterThanMax;
        boolean bl = isGreaterThanMax = value != null && maxValue != null && value.compareTo(maxValue) > 0;
        if (isGreaterThanMax) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    public static <V extends Comparable<V>> ValidationResult checkSmallerThanMin(V value, V minValue) {
        boolean isSmallerThanMin;
        boolean bl = isSmallerThanMin = value != null && minValue != null && value.compareTo(minValue) < 0;
        if (isSmallerThanMin) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }
}

